/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragHandler
extends DragHandler {
    @Nullable
    protected SceneComponent myComponent;

    public ConstraintDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, DragType type) {
        if (editor == null) {
            ConstraintDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            ConstraintDragHandler.$$$reportNull$$$0(1);
        }
        if (layout2 == null) {
            ConstraintDragHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            ConstraintDragHandler.$$$reportNull$$$0(3);
        }
        super(editor, handler, layout2, components, type);
        if (components.size() == 1) {
            NlComponent component2 = components.get(0);
            this.myComponent = new TemporarySceneComponent(layout2.getScene(), component2);
            this.myComponent.setSize(editor.pxToDp(NlComponentHelperKt.getW(component2)), editor.pxToDp(NlComponentHelperKt.getH(component2)));
            if (AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component2.getTagName())) {
                if ("vertical".equals(component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation"))) {
                    this.myComponent.setSize(2, 200);
                } else {
                    this.myComponent.setSize(200, 2);
                }
            }
            this.myComponent.setTargetProvider(sceneComponent -> ImmutableList.of((Object)new ConstraintDragDndTarget()));
            this.myComponent.updateTargets();
            this.myComponent.setDrawState(SceneComponent.DrawState.DRAG);
            layout2.addChild(this.myComponent);
        }
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        if (this.myComponent == null) {
            return;
        }
        Scene scene = this.editor.getScene();
        scene.needsRebuildList();
        int dx = x - this.myComponent.getDrawWidth() / 2;
        int dy = y - this.myComponent.getDrawHeight() / 2;
        for (Target target : this.myComponent.getTargets()) {
            if (!(target instanceof ConstraintDragDndTarget)) continue;
            target.mouseDown(dx, dy);
            break;
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        if (sceneContext == null) {
            ConstraintDragHandler.$$$reportNull$$$0(4);
        }
        String result = super.update(x, y, modifiers, sceneContext);
        if (this.myComponent == null) {
            return "undefined";
        }
        Scene scene = this.editor.getScene();
        int dx = x - this.myComponent.getDrawWidth() / 2;
        int dy = y - this.myComponent.getDrawHeight() / 2;
        this.myComponent.setPosition(dx, dy);
        ImmutableList<Target> targets = this.myComponent.getTargets();
        for (int i = 0; i < targets.size(); ++i) {
            if (!(targets.get(i) instanceof ConstraintDragDndTarget)) continue;
            ConstraintDragDndTarget target = (ConstraintDragDndTarget)targets.get(i);
            target.mouseDrag(dx, dy, (List<Target>)targets, sceneContext);
            break;
        }
        scene.requestLayoutIfNeeded();
        return result;
    }

    @Override
    public void cancel() {
        Scene scene = this.editor.getScene();
        if (this.myComponent != null) {
            scene.removeComponent(this.myComponent);
        }
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            ConstraintDragHandler.$$$reportNull$$$0(5);
        }
        Scene scene = this.editor.getScene();
        if (this.myComponent != null) {
            NlComponent root = this.myComponent.getNlComponent().getRoot();
            String prefix = (String)NlWriteCommandActionUtil.compute(root, "Add App Namespace", () -> root.ensureNamespace("app", "http://schemas.android.com/apk/res-auto"));
            if (prefix == null) {
                return;
            }
            int dx = this.editor.pxToDp(x) - this.myComponent.getDrawWidth() / 2;
            int dy = this.editor.pxToDp(y) - this.myComponent.getDrawHeight() / 2;
            for (Target target : this.myComponent.getTargets()) {
                if (!(target instanceof ConstraintDragDndTarget)) continue;
                ((ConstraintDragDndTarget)target).mouseRelease(dx, dy, (NlComponent)this.components.get(0));
                break;
            }
        }
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, -1, insertType);
        scene.removeComponent(this.myComponent);
        scene.requestLayoutIfNeeded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

