/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentReference;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintHelperHandler
extends ViewGroupHandler
implements DelegatedTreeEventHandler {
    public static final boolean USE_HELPER_TAGS = false;

    @Override
    public void performDrop(@NotNull NlModel model2, @NotNull NlDropEvent event, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (model2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(0);
        }
        if (event == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(1);
        }
        if (receiver == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(2);
        }
        if (dragged == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(3);
        }
        if (insertType == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(4);
        }
        if (NlComponentHelperKt.isOrHasSuperclass(receiver, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER)) {
            try {
                ConstraintHelperHandler.addComponentsIds(receiver, dragged);
                if (NlComponentHelperKt.isOrHasSuperclass(receiver, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW)) {
                    for (NlComponent toDrag : dragged) {
                        if (insertType != InsertType.MOVE || toDrag.getParent() == receiver) continue;
                        AttributesTransaction transaction = toDrag.startAttributeTransaction();
                        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
                        transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
                        NlWriteCommandActionUtil.run(toDrag, "", transaction::commit);
                    }
                }
                event.accept(insertType);
                event.complete();
                model2.notifyModified(NlModel.ChangeType.DROP);
            }
            catch (Exception exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
                event.reject();
            }
        }
    }

    private static void addComponentsIds(@NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        if (receiver == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(5);
        }
        if (dragged == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(6);
        }
        ArrayList<String> draggedIds = new ArrayList<String>();
        for (NlComponent component2 : dragged) {
            draggedIds.add(NlComponentHelperKt.ensureLiveId(component2));
        }
        ConstraintHelperHandler.addReferencesIds(receiver, draggedIds, null);
    }

    @Override
    public boolean holdsReferences() {
        return true;
    }

    @Override
    public void removeReference(@NotNull NlComponent component2, @NotNull String id2) {
        if (component2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(7);
        }
        if (id2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(8);
        }
        this.deleteReferences(component2, (List<String>)ImmutableList.of((Object)id2));
    }

    @Override
    public void addReferences(@NotNull NlComponent component2, @NotNull List<String> ids, @Nullable String before) {
        if (component2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(9);
        }
        if (ids == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(10);
        }
        ConstraintHelperHandler.addReferencesIds(component2, ids, before);
    }

    private static void addReferencesIds(@NotNull NlComponent receiver, @NotNull List<String> draggedIds, @Nullable String before) {
        if (receiver == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(11);
        }
        if (draggedIds == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(12);
        }
        AttributesTransaction transaction = receiver.startAttributeTransaction();
        String originalIdsList = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids");
        String idList = ConstraintHelperHandler.addIds(originalIdsList, draggedIds, before);
        ConstraintHelperHandler.writeIds(receiver, transaction, idList);
    }

    @Nullable
    private static String removeIds(@NotNull String originalIds, @NotNull List<String> toRemove) {
        if (originalIds == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(13);
        }
        if (toRemove == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(14);
        }
        String[] splitIds = originalIds.split(",");
        ArrayList strings = new ArrayList(splitIds.length);
        Collections.addAll(strings, splitIds);
        strings.removeAll(toRemove);
        return strings.isEmpty() ? null : String.join((CharSequence)",", strings);
    }

    @Nullable
    private static String addIds(@Nullable String ids, @NotNull List<String> newIds, @Nullable String before) {
        int insertionIndex;
        ArrayList<String> idsList;
        if (newIds == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(15);
        }
        if (newIds.isEmpty()) {
            return ids;
        }
        if (ids != null) {
            String[] splitIds = ids.split(",");
            idsList = new ArrayList(splitIds.length);
            Collections.addAll(idsList, splitIds);
            idsList.removeAll(newIds);
        } else {
            idsList = new ArrayList<String>();
        }
        int n = insertionIndex = before == null ? -1 : idsList.indexOf(before);
        if (insertionIndex >= 0) {
            idsList.addAll(insertionIndex, newIds);
        } else {
            idsList.addAll(newIds);
        }
        return String.join((CharSequence)",", new LinkedHashSet(idsList));
    }

    public static void willDelete(@NotNull NlComponent parent, @NotNull String id2) {
        if (parent == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(16);
        }
        if (id2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(17);
        }
        for (NlComponent child : parent.getChildren()) {
            String ids;
            if (!NlComponentHelperKt.isOrHasSuperclass(child, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) || (ids = child.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) == null) continue;
            ids = ConstraintHelperHandler.removeIds(ids, Collections.singletonList(id2));
            AttributesTransaction transaction = child.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(child, transaction, ids);
        }
    }

    @Override
    public int getComponentTreeChildCount(@NotNull Object element) {
        String ids;
        NlComponent component2;
        if (element == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(18);
        }
        if (element instanceof NlComponent && NlComponentHelperKt.isOrHasSuperclass(component2 = (NlComponent)element, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
            String[] list = ids.split(",");
            return list.length;
        }
        return 0;
    }

    @Override
    public Object getComponentTreeChild(@NotNull Object element, int i) {
        if (element == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(19);
        }
        if (element instanceof NlComponent) {
            String ids;
            NlComponent component2 = (NlComponent)element;
            if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
                String[] list = ids.split(",");
                return (Boolean)StudioFlags.NELE_NEW_COMPONENT_TREE.get() != false ? new NlComponentReference(component2, list[i]) : list[i];
            }
            return component2.getChild(i);
        }
        return null;
    }

    @Override
    public List<?> getComponentTreeChildren(@NotNull Object element) {
        if (element == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(20);
        }
        if (element instanceof NlComponent) {
            String ids;
            NlComponent component2 = (NlComponent)element;
            if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_HELPER) && (ids = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
                List<String> list = Arrays.asList(ids.split(","));
                if (!((Boolean)StudioFlags.NELE_NEW_COMPONENT_TREE.get()).booleanValue()) {
                    return list;
                }
                return list.stream().map(id2 -> new NlComponentReference(component2, (String)id2)).collect(Collectors.toList());
            }
            return component2.getChildren();
        }
        return Collections.emptyList();
    }

    private void deleteReferences(@NotNull NlComponent component2, @NotNull List<String> ids) {
        String refs;
        if (component2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(21);
        }
        if (ids == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(22);
        }
        if ((refs = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) != null) {
            refs = ConstraintHelperHandler.removeIds(refs, ids);
            AttributesTransaction transaction = component2.startAttributeTransaction();
            ConstraintHelperHandler.writeIds(component2, transaction, refs);
        }
    }

    private static void writeIds(@NotNull NlComponent component2, @NotNull AttributesTransaction transaction, @Nullable String idList) {
        if (component2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(23);
        }
        if (transaction == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(24);
        }
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids", idList);
        NlWriteCommandActionUtil.run(component2, "", transaction::commit);
    }

    @Override
    public boolean handleTreeEvent(@NotNull DelegatedTreeEvent event, @NotNull NlComponent constraintHelper) {
        if (event == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(25);
        }
        if (constraintHelper == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(26);
        }
        if (event.getType() == DelegatedTreeEvent.Type.DELETE) {
            this.handleDeletion(event, constraintHelper);
        } else if (event.getType() == DelegatedTreeEvent.Type.DROP) {
            ConstraintHelperHandler.handleHelperIdDrop(event, constraintHelper);
        }
        return true;
    }

    private void handleDeletion(@NotNull DelegatedTreeEvent event, @NotNull NlComponent constraintHelper) {
        if (event == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(27);
        }
        if (constraintHelper == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(28);
        }
        for (Object last : event.getSelected()) {
            if (!(last instanceof String)) continue;
            this.deleteReferences(constraintHelper, (List<String>)ImmutableList.of((Object)((String)last)));
        }
    }

    private static void handleHelperIdDrop(@NotNull DelegatedTreeEvent event, @NotNull NlComponent component2) {
        if (event == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(29);
        }
        if (component2 == null) {
            ConstraintHelperHandler.$$$reportNull$$$0(30);
        }
        List<Object> selected = event.getSelected();
        List<String> ids = selected.stream().filter(o -> o instanceof String).map(o -> (String)o).collect(Collectors.toList());
        Object sibling = event.getNextSibling();
        String nextSibling = sibling instanceof String ? (String)sibling : null;
        ConstraintHelperHandler.addReferencesIds(component2, ids, nextSibling);
    }

    @Override
    public Transferable getTransferable(TreePath[] paths) {
        ArrayList<String> barriersList = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            Object component2 = paths[i].getLastPathComponent();
            if (!(component2 instanceof String)) continue;
            barriersList.add((String)component2);
        }
        if (barriersList.isEmpty()) {
            return null;
        }
        return new BarrierTransferable(barriersList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 7: 
            case 9: 
            case 21: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedIds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalIds";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIds";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintHelper";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintHelperHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performDrop";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addComponentsIds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeReference";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addReferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addReferencesIds";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIds";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addIds";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "willDelete";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentTreeChildCount";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentTreeChild";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentTreeChildren";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteReferences";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "writeIds";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTreeEvent";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDeletion";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "handleHelperIdDrop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BarrierTransferable
    implements Transferable {
        public static final DataFlavor BARRIER_FLAVOR = new DataFlavor(BarrierTransferable.class, "Barrier Item");
        private final List<String> myBarrierReferences;

        public BarrierTransferable(List<String> barrierReferences) {
            this.myBarrierReferences = barrierReferences;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BARRIER_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BARRIER_FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (BARRIER_FLAVOR.equals(flavor)) {
                return this.myBarrierReferences;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

