/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.uibuilder.scout.Scout;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarginPopup
extends JPanel {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final String DEFAULT_RES_DISPLAY = "@ ...";
    private final JBTextField myTextField = new JBTextField();
    private final JButton[] myHistoryButtons = new JButton[3];
    private final JButton myResourcePickerButton = new JButton();
    private final int[] myDefaultValues = new int[]{0, 8, 16, 24};
    private final int[] myHistoryValues = new int[]{-1, -1, -1};
    ActionListener myListener;
    private JBPopup myPopup;
    private final MarginValue myValue = new MarginValue();
    private ActionListener myTextListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarginPopup.this.saveNewValue(e);
            SwingUtilities.getWindowAncestor(MarginPopup.this).setVisible(false);
        }
    };
    private ActionListener myDefaultListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            String s = b.getText();
            try {
                MarginPopup.this.myValue.setValue(Integer.parseInt(s), null);
            }
            catch (NumberFormatException e1) {
                MarginPopup.this.myValue.setValue(0, null);
            }
            MarginPopup.this.updateText();
            if (MarginPopup.this.myListener != null) {
                MarginPopup.this.myListener.actionPerformed(e);
            }
            MarginPopup.this.cancel();
        }
    };

    public MarginValue getMargin() {
        return this.myValue;
    }

    public void setPopup(@Nullable JBPopup popup2) {
        for (Component component2 : this.getComponents()) {
            MarginPopup.updateFontsForPresentationMode(component2);
        }
        this.myPopup = popup2;
    }

    public void cancel() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        this.myPopup = null;
    }

    public void updateText() {
        this.myTextField.setText(String.valueOf(this.myValue.getValue()));
    }

    private boolean isADefault(int value2) {
        return Arrays.stream(this.myDefaultValues).anyMatch(defaultValue -> defaultValue == value2);
    }

    public void setActionListener(@Nullable ActionListener actionListener) {
        this.myListener = actionListener;
    }

    void saveNewValue(ActionEvent e) {
        try {
            this.myValue.setValue(Integer.parseInt(this.myTextField.getText()), null);
            int value2 = this.myValue.getValue();
            if (!this.isADefault(value2)) {
                for (int i = 0; i < this.myHistoryValues.length; ++i) {
                    int old = this.myHistoryValues[i];
                    this.myHistoryValues[i] = value2;
                    if (value2 > 0) {
                        this.myHistoryButtons[i].setText(Integer.toString(value2));
                    }
                    value2 = old;
                }
            }
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
        if (this.myListener != null) {
            this.myListener.actionPerformed(e);
        }
    }

    public MarginPopup() {
        super(new GridBagLayout());
        int i;
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
        this.setBackground(JBColor.background());
        GridBagConstraints gc = new GridBagConstraints();
        JBTextField defaultMargin = new JBTextField("Default Margin : ");
        defaultMargin.setEditable(false);
        defaultMargin.setFocusable(false);
        defaultMargin.setBorder(BorderFactory.createEmptyBorder());
        defaultMargin.setBackground(JBColor.background());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.insets = JBUI.insets((int)10, (int)5, (int)5, (int)0);
        gc.fill = 1;
        defaultMargin.setHorizontalAlignment(4);
        this.add((Component)defaultMargin, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.insets = JBUI.insets((int)10, (int)5, (int)5, (int)0);
        gc.fill = 1;
        this.myTextField.setHorizontalAlignment(4);
        this.myTextField.setText(Integer.toString(this.myValue.getValue()));
        this.add((Component)this.myTextField, gc);
        gc.gridx = 3;
        gc.gridwidth = 1;
        gc.insets.bottom = JBUIScale.scale((int)0);
        gc.insets.left = JBUIScale.scale((int)2);
        gc.insets.right = JBUIScale.scale((int)5);
        gc.insets.top = JBUIScale.scale((int)2);
        this.add((Component)new JBLabel("dp"), gc);
        gc.gridwidth = 1;
        gc.gridy = 1;
        gc.insets.bottom = JBUIScale.scale((int)0);
        gc.insets.left = JBUIScale.scale((int)0);
        gc.insets.right = JBUIScale.scale((int)0);
        gc.insets.top = JBUIScale.scale((int)0);
        ((AbstractDocument)this.myTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset2, int length, String text, AttributeSet attrs) throws BadLocationException {
                for (int i = 0; i < text.length(); ++i) {
                    if (Character.isDigit(text.charAt(i))) continue;
                    return;
                }
                super.replace(fb, offset2, length, text, attrs);
            }
        });
        gc.fill = 2;
        this.myTextField.addActionListener(this.myTextListener);
        JBInsets margin = JBInsets.emptyInsets();
        for (i = 0; i < 4; ++i) {
            JButton b = new JButton(String.valueOf(this.myDefaultValues[i]));
            b.setMargin((Insets)margin);
            b.addActionListener(this.myDefaultListener);
            b.setBackground(JBColor.background());
            gc.gridx = i;
            gc.insets.left = JBUIScale.scale((int)(i == 0 ? 5 : 0));
            gc.insets.right = JBUIScale.scale((int)(i == 3 ? 5 : 0));
            this.add((Component)b, gc);
        }
        gc.gridy = 2;
        gc.insets.bottom = JBUIScale.scale((int)7);
        for (i = 0; i < this.myHistoryButtons.length; ++i) {
            this.myHistoryButtons[i] = new JButton("XXX");
            this.myHistoryButtons[i].setMargin((Insets)margin);
            this.myHistoryButtons[i].setBackground(JBColor.background());
            if (this.myHistoryValues[i] > 0) {
                this.myHistoryButtons[i].setText(Integer.toString(this.myHistoryValues[i]));
            } else {
                this.myHistoryButtons[i].setText("");
            }
            this.myHistoryButtons[i].addActionListener(this.myDefaultListener);
            gc.gridx = i;
            gc.insets.left = JBUIScale.scale((int)(i == 0 ? 5 : 0));
            gc.insets.right = JBUIScale.scale((int)(i == this.myHistoryButtons.length - 1 ? 5 : 0));
            this.add((Component)this.myHistoryButtons[i], gc);
        }
        this.myResourcePickerButton.setMargin((Insets)margin);
        this.myResourcePickerButton.setText(DEFAULT_RES_DISPLAY);
        gc.gridx = 3;
        gc.insets.left = JBUIScale.scale((int)0);
        gc.insets.right = JBUIScale.scale((int)5);
        this.add((Component)this.myResourcePickerButton, gc);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MarginPopup.this.saveNewValue(null);
            }
        });
    }

    public JComponent getTextField() {
        return this.myTextField;
    }

    private static void updateFontsForPresentationMode(Component component2) {
        Font font = component2.getFont();
        component2.setFont(font.deriveFont((float)JBUIScale.scaleFontSize((float)12.0f)));
    }

    public void addResourcePickerActionListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            MarginPopup.$$$reportNull$$$0(0);
        }
        this.myResourcePickerButton.addActionListener(listener2);
    }

    public void removeResourcePickerActionListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            MarginPopup.$$$reportNull$$$0(1);
        }
        this.myResourcePickerButton.removeActionListener(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addResourcePickerActionListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeResourcePickerActionListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MarginValue {
        private int myValue = 0;
        @NotNull
        private String myDisplayValue = this.myValue + "dp";

        public void setValue(int value2, String resName) {
            this.myValue = value2;
            Scout.setMargin(value2);
            if (resName != null) {
                this.myDisplayValue = MarginPopup.DEFAULT_RES_DISPLAY;
                Scout.setMarginResource(resName);
            } else {
                this.myDisplayValue = value2 + "dp";
                Scout.setMarginResource(null);
            }
        }

        public int getValue() {
            return this.myValue;
        }

        @NotNull
        public String getDisplayValue() {
            String string2 = this.myDisplayValue;
            if (string2 == null) {
                MarginValue.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/MarginPopup$MarginValue", "getDisplayValue"));
        }
    }
}

