/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.model.NlComponent;
import java.util.ArrayList;
import java.util.HashSet;

public class SecondarySelector {
    private static boolean DEBUG = false;
    NlComponent myComponent;
    Constraint myConstraint;
    String myTrace;
    private static ArrayList<SecondarySelector> freeList = new ArrayList();
    private static HashSet<SecondarySelector> freeSet = new HashSet();
    private static ArrayList<SecondarySelector> unFreed;

    public String toString() {
        return " " + this.hashCode() + " " + this.myComponent + " : " + this.myConstraint;
    }

    private SecondarySelector() {
    }

    public static void debug() {
        System.out.println("freelist size = " + unFreed.size() + " ");
        for (SecondarySelector selector : unFreed) {
            System.out.println("created at  .(" + selector.myTrace + ") but not freed");
        }
        System.out.println("freelist size = " + unFreed.size() + " ");
    }

    public static SecondarySelector get(NlComponent component2, Constraint constraint) {
        SecondarySelector selector = freeList.isEmpty() ? new SecondarySelector() : freeList.remove(0);
        freeSet.remove(selector);
        selector.myComponent = component2;
        selector.myConstraint = constraint;
        if (DEBUG) {
            StackTraceElement st = new Throwable().getStackTrace()[1];
            selector.myTrace = st.getFileName() + ":" + st.getLineNumber();
            unFreed.add(selector);
        }
        return selector;
    }

    public Constraint getConstraint() {
        return this.myConstraint;
    }

    public NlComponent getComponent() {
        return this.myComponent;
    }

    public void release() {
        this.myComponent = null;
        this.myConstraint = null;
        if (DEBUG) {
            unFreed.remove(this);
        }
        if (freeSet.add(this)) {
            freeList.add(this);
        }
    }

    static {
        if (DEBUG) {
            unFreed = new ArrayList();
        }
    }

    public static enum Constraint {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        BASELINE;

    }
}

