/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchorConstants;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Guideline;
import java.util.HashSet;

public class ConstraintAnchor {
    private static final int UNSET_GONE_MARGIN = -1;
    final ConstraintWidget mOwner;
    final ConstraintAnchorConstants.Type mType;
    ConstraintAnchor mTarget;
    public int mMargin = 0;
    int mGoneMargin = -1;

    public ConstraintAnchor(ConstraintWidget owner, ConstraintAnchorConstants.Type type) {
        this.mOwner = owner;
        this.mType = type;
    }

    public ConstraintWidget getOwner() {
        return this.mOwner;
    }

    public ConstraintAnchorConstants.Type getType() {
        return this.mType;
    }

    public int getMargin() {
        if (this.mOwner.getVisibility() == 8) {
            return 0;
        }
        if (this.mGoneMargin > -1 && this.mTarget != null && this.mTarget.mOwner.getVisibility() == 8) {
            return this.mGoneMargin;
        }
        return this.mMargin;
    }

    public ConstraintAnchor getTarget() {
        return this.mTarget;
    }

    public void reset() {
        this.mTarget = null;
        this.mMargin = 0;
        this.mGoneMargin = -1;
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, ConstraintAnchorConstants.Strength strength, int creator) {
        return this.connect(toAnchor, margin, -1, strength, creator, false);
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, int goneMargin, ConstraintAnchorConstants.Strength strength, int creator, boolean forceConnection) {
        if (toAnchor == null) {
            this.mTarget = null;
            this.mMargin = 0;
            this.mGoneMargin = -1;
            return true;
        }
        if (!forceConnection && !this.isValidConnection(toAnchor)) {
            return false;
        }
        this.mTarget = toAnchor;
        this.mMargin = margin > 0 ? margin : 0;
        this.mGoneMargin = goneMargin;
        return true;
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, int creator) {
        return this.connect(toAnchor, margin, -1, ConstraintAnchorConstants.Strength.STRONG, creator, false);
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin) {
        return this.connect(toAnchor, margin, -1, ConstraintAnchorConstants.Strength.STRONG, 0, false);
    }

    public boolean isConnected() {
        return this.mTarget != null;
    }

    public boolean isValidConnection(ConstraintAnchor anchor) {
        if (anchor == null) {
            return false;
        }
        ConstraintAnchorConstants.Type target = anchor.getType();
        if (target == this.mType) {
            return this.mType != ConstraintAnchorConstants.Type.BASELINE || anchor.getOwner().hasBaseline() && this.getOwner().hasBaseline();
        }
        switch (this.mType) {
            case CENTER: {
                return target != ConstraintAnchorConstants.Type.BASELINE && target != ConstraintAnchorConstants.Type.CENTER_X && target != ConstraintAnchorConstants.Type.CENTER_Y;
            }
            case LEFT: 
            case RIGHT: {
                boolean isCompatible;
                boolean bl = isCompatible = target == ConstraintAnchorConstants.Type.LEFT || target == ConstraintAnchorConstants.Type.RIGHT;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == ConstraintAnchorConstants.Type.CENTER_X;
                }
                return isCompatible;
            }
            case TOP: 
            case BOTTOM: {
                boolean isCompatible;
                boolean bl = isCompatible = target == ConstraintAnchorConstants.Type.TOP || target == ConstraintAnchorConstants.Type.BOTTOM;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == ConstraintAnchorConstants.Type.CENTER_Y;
                }
                return isCompatible;
            }
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public void setMargin(int margin) {
        if (this.isConnected()) {
            this.mMargin = margin;
        }
    }

    public String toString() {
        HashSet<ConstraintAnchor> visited = new HashSet<ConstraintAnchor>();
        return this.mOwner.getDebugName() + ":" + this.mType.toString() + (String)(this.mTarget != null ? " connected to " + this.mTarget.toString(visited) : "");
    }

    private String toString(HashSet<ConstraintAnchor> visited) {
        if (visited.add(this)) {
            return this.mOwner.getDebugName() + ":" + this.mType.toString() + (String)(this.mTarget != null ? " connected to " + this.mTarget.toString(visited) : "");
        }
        return "<-";
    }

    public final ConstraintAnchor getOpposite() {
        switch (this.mType) {
            case LEFT: {
                return this.mOwner.mRight;
            }
            case RIGHT: {
                return this.mOwner.mLeft;
            }
            case TOP: {
                return this.mOwner.mBottom;
            }
            case BOTTOM: {
                return this.mOwner.mTop;
            }
            case CENTER: 
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }
}

