/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutGuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConstraintDragDndTarget
extends ConstraintDragTarget {
    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent instanceof TemporarySceneComponent) {
            this.getTargetNotchSnapper().gatherNotches(this.myComponent);
        } else {
            super.mouseDown(x, y);
        }
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTarget, @NotNull SceneContext sceneContext) {
        if (closestTarget == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(1);
        }
        if (this.myComponent instanceof TemporarySceneComponent) {
            Scene scene = this.myComponent.getScene();
            int dx = this.getTargetNotchSnapper().trySnapHorizontal(x).orElse(x);
            int dy = this.getTargetNotchSnapper().trySnapVertical(y).orElse(y);
            this.myComponent.setPosition(dx, dy);
            scene.needsRebuildList();
        } else {
            super.mouseDrag(x, y, closestTarget, sceneContext);
        }
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(3);
        }
        super.render(list, sceneContext);
    }

    public void mouseRelease(int x, int y, @NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(4);
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            AttributesTransaction attributes = component2.startAttributeTransaction();
            int dx = x - this.myOffsetX;
            int dy = y - this.myOffsetY;
            TargetSnapper snapper = this.getTargetNotchSnapper();
            Point snappedCoordinates = new Point(snapper.trySnapHorizontal(dx).orElse(dx), snapper.trySnapVertical(dy).orElse(dy));
            if (this.isAutoConnectionEnabled()) {
                snapper.applyNotches(attributes);
            }
            this.updateAttributes(attributes, snappedCoordinates.x, snappedCoordinates.y);
            this.setGuidelineBegin(attributes, x, y);
            boolean horizontalMatchParent = false;
            boolean verticalMatchParent = false;
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width"))) {
                horizontalMatchParent = true;
            }
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height"))) {
                verticalMatchParent = true;
            }
            if (horizontalMatchParent || verticalMatchParent) {
                NlComponentHelperKt.setX(component2, Coordinates.dpToPx(this.getComponent().getScene().getSceneManager(), (float)dx));
                NlComponentHelperKt.setY(component2, Coordinates.dpToPx(this.getComponent().getScene().getSceneManager(), (float)dy));
                ScoutWidget parentScoutWidget = new ScoutWidget(this.myComponent.getParent().getNlComponent(), null);
                ScoutWidget[] scoutWidgets = ScoutWidget.create(Collections.singletonList(component2), parentScoutWidget);
                int margin = Scout.getMargin();
                if (horizontalMatchParent) {
                    ScoutArrange.expandHorizontally(scoutWidgets, parentScoutWidget, margin, false);
                }
                if (verticalMatchParent) {
                    ScoutArrange.expandVertically(scoutWidgets, parentScoutWidget, margin, false);
                }
            }
            attributes.apply();
            NlWriteCommandActionUtil.run(component2, "drag", attributes::commit);
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().markNeedsLayout(1);
        }
    }

    private void setGuidelineBegin(@NotNull AttributesTransaction attributes, int x, int y) {
        if (attributes == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(5);
        }
        if (ConstraintComponentUtilities.isGuideLine(this.myComponent.getNlComponent())) {
            if (ConstraintLayoutGuidelineHandler.isVertical(this.myComponent.getNlComponent())) {
                int dx = x - this.getLeftTargetOrigin(this.myComponent.getParent());
                String positionX = String.format("%ddp", dx);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", positionX);
            } else {
                int dy = y - this.getTopTargetOrigin(this.myComponent.getParent());
                String positionY = String.format("%ddp", dy);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", positionY);
            }
        }
    }

    private int getLeftTargetOrigin(SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
            origin += target.getDrawWidth();
        }
        return origin;
    }

    protected int getTopTargetOrigin(SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
            origin += target.getDrawHeight();
        }
        return origin;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTarget";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/ConstraintDragDndTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setGuidelineBegin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

