/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0016J.\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00042\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0014J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget;", "Lcom/android/tools/idea/common/scene/target/DragBaseTarget;", "()V", "myAttributes", "", "", "myOriginalAttributes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mySnapTarget", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget;", "getPreferenceLevel", "", "layout", "", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "left", "top", "right", "bottom", "mouseCancel", "", "mouseDown", "x", "y", "mouseDrag", "closestTarget", "Lcom/android/tools/idea/common/scene/target/Target;", "ignored", "mouseRelease", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "closestTargets", "rememberAttributes", "render", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "restoreAttributes", "transaction", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "updateAttributes", "attributes", "updateInteractionState", "interactionState", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorLayoutHandler$InteractionState;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nCoordinatorDragTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatorDragTarget.kt\ncom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n288#2,2:169\n*S KotlinDebug\n*F\n+ 1 CoordinatorDragTarget.kt\ncom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget\n*L\n119#1:169,2\n*E\n"})
public final class CoordinatorDragTarget
extends DragBaseTarget {
    @Nullable
    private CoordinatorSnapTarget mySnapTarget;
    @NotNull
    private List<String> myAttributes;
    @NotNull
    private HashMap<String, String> myOriginalAttributes;

    public CoordinatorDragTarget() {
        Object[] objectArray = new String[]{"layout_anchor", "layout_anchorGravity"};
        this.myAttributes = CollectionsKt.listOf((Object[])objectArray);
        this.myOriginalAttributes = new HashMap();
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int left, int top, int right2, int bottom2) {
        int d;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int minWidth = 16;
        int minHeight = 16;
        int l = left;
        int t = top;
        int r = right2;
        int b = bottom2;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
    }

    private final void rememberAttributes() {
        this.myOriginalAttributes.clear();
        for (String attribute : this.myAttributes) {
            String value2 = this.myComponent.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if (value2 == null) continue;
            ((Map)this.myOriginalAttributes).put(attribute, value2);
        }
    }

    private final void restoreAttributes(NlAttributesHolder transaction) {
        for (String attribute : this.myAttributes) {
            String value2 = this.myOriginalAttributes.get(attribute);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value2);
        }
    }

    private final void updateInteractionState(CoordinatorLayoutHandler.InteractionState interactionState) {
        block2: {
            Object object = this.myComponent.getParent();
            if (object == null || (object = ((SceneComponent)object).getNlComponent()) == null || (object = NlComponentHelperKt.getViewHandler((NlComponent)object)) == null) {
                return;
            }
            Object handler = object;
            if (!(handler instanceof CoordinatorLayoutHandler)) break block2;
            ((CoordinatorLayoutHandler)handler).setInteractionState(interactionState);
            SceneComponent sceneComponent = this.myComponent.getParent();
            if (sceneComponent != null) {
                sceneComponent.updateTargets();
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.DRAGGING);
        this.rememberAttributes();
    }

    public void mouseDrag(int x, int y, @NotNull List<? extends Target> closestTarget, @NotNull SceneContext ignored) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter(closestTarget, (String)"closestTarget");
            Intrinsics.checkNotNullParameter((Object)ignored, (String)"ignored");
            if (this.myComponent.getParent() == null) {
                return;
            }
            CoordinatorSnapTarget coordinatorSnapTarget = this.mySnapTarget;
            if (coordinatorSnapTarget != null) {
                coordinatorSnapTarget.setMouseHovered(false);
            }
            this.mySnapTarget = null;
            Iterable $this$firstOrNull$iv = closestTarget;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Target it = (Target)element$iv;
                boolean bl = false;
                if (!(it instanceof CoordinatorSnapTarget)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Target snapTarget = v1;
        if (snapTarget instanceof CoordinatorSnapTarget) {
            this.mySnapTarget = (CoordinatorSnapTarget)snapTarget;
            ((CoordinatorSnapTarget)snapTarget).setMouseHovered(true);
        }
        this.myComponent.setDragging(true);
        this.myComponent.setPosition(x - this.myOffsetX, y - this.myOffsetY);
        this.myComponent.getScene().repaint();
        this.myChangedComponent = true;
    }

    public void mouseRelease(int x, int y, @NotNull List<? extends Target> closestTargets) {
        Intrinsics.checkNotNullParameter(closestTargets, (String)"closestTargets");
        super.mouseRelease(x, y, closestTargets);
        if (this.myChangedComponent) {
            this.myComponent.getScene().markNeedsLayout(1);
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (this.mySnapTarget != null) {
            CoordinatorSnapTarget coordinatorSnapTarget = this.mySnapTarget;
            Intrinsics.checkNotNull((Object)coordinatorSnapTarget);
            coordinatorSnapTarget.snap(attributes);
        } else {
            this.restoreAttributes(attributes);
        }
    }

    @Override
    public void mouseCancel() {
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
        super.mouseCancel();
    }

    public final void mouseRelease(int x, int y, @NotNull NlComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            AttributesTransaction attributesTransaction = component2.startAttributeTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)attributesTransaction, (String)"component.startAttributeTransaction()");
            AttributesTransaction attributes = attributesTransaction;
            this.updateAttributes(attributes, x, y);
            attributes.apply();
            if (Math.abs(x - this.myFirstMouseX) > 1 || Math.abs(y - this.myFirstMouseY) > 1) {
                NlWriteCommandActionUtil.run(component2, "Dragged " + StringUtil.getShortName((String)component2.getTagName()), () -> CoordinatorDragTarget.mouseRelease$lambda$1(attributes));
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().markNeedsLayout(1);
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
    }

    private static final void mouseRelease$lambda$1(AttributesTransaction $attributes) {
        Intrinsics.checkNotNullParameter((Object)$attributes, (String)"$attributes");
        $attributes.commit();
    }
}

