/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.GridDragHandler;
import com.android.tools.idea.uibuilder.handlers.grid.GridPlaceholder;
import com.android.tools.idea.uibuilder.handlers.grid.GridUtilsKt;
import com.android.tools.idea.uibuilder.handlers.grid.targets.GridDragTarget;
import com.android.tools.idea.uibuilder.handlers.grid.targets.GridResizeTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0014J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0016\u0010\"\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0002J$\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u0010!\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\b\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler;", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "()V", "namespace", "", "getNamespace", "()Ljava/lang/String;", "createChildTargets", "", "Lcom/android/tools/idea/common/scene/target/Target;", "parentComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "childComponent", "createDragHandler", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "layout", "components", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "createDragTarget", "", "listBuilder", "Lcom/google/common/collect/ImmutableList$Builder;", "createInteraction", "Lcom/android/tools/idea/common/scene/SceneInteraction;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "x", "", "y", "component", "createResizeTarget", "getPlaceholders", "Lcom/android/tools/idea/common/scene/Placeholder;", "draggedComponents", "handlesPainting", "", "onChildRemoved", "newChild", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nGridLayoutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLayoutHandler.kt\ncom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n11335#2:93\n11670#2,3:94\n*S KotlinDebug\n*F\n+ 1 GridLayoutHandler.kt\ncom/android/tools/idea/uibuilder/handlers/grid/GridLayoutHandler\n*L\n73#1:93\n73#1:94,3\n*E\n"})
public class GridLayoutHandler
extends ViewGroupHandler {
    @NotNull
    private final String namespace;

    public GridLayoutHandler() {
        this.namespace = "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    protected String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout2, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new GridDragHandler(editor, this, layout2, components, type);
    }

    @Override
    public void onChildRemoved(@NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)newChild, (String)"newChild");
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        newChild.removeAttribute(this.getNamespace(), "layout_row");
        newChild.removeAttribute(this.getNamespace(), "layout_column");
        newChild.removeAttribute(this.getNamespace(), "layout_rowSpan");
        newChild.removeAttribute(this.getNamespace(), "layout_columnSpan");
    }

    @Override
    @NotNull
    public SceneInteraction createInteraction(@NotNull ScreenView screenView, int x, int y, @NotNull NlComponent component2) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return new SceneInteraction(screenView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)childComponent, (String)"childComponent");
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        Intrinsics.checkNotNullExpressionValue((Object)listBuilder, (String)"listBuilder");
        this.createDragTarget((ImmutableList.Builder<Target>)listBuilder);
        this.createResizeTarget((ImmutableList.Builder<Target>)listBuilder);
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"listBuilder.build()");
        return (List)immutableList;
    }

    protected void createDragTarget(@NotNull ImmutableList.Builder<Target> listBuilder) {
        Intrinsics.checkNotNullParameter(listBuilder, (String)"listBuilder");
        listBuilder.add((Object)new GridDragTarget(false));
    }

    /*
     * WARNING - void declaration
     */
    private final void createResizeTarget(ImmutableList.Builder<Target> listBuilder) {
        void $this$mapTo$iv$iv;
        ResizeBaseTarget.Type[] $this$map$iv = ResizeBaseTarget.Type.values();
        boolean $i$f$map = false;
        ResizeBaseTarget.Type[] typeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(listBuilder.add((Object)new GridResizeTarget((ResizeBaseTarget.Type)it)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @NotNull
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component2, @NotNull List<? extends SceneComponent> draggedComponents) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(draggedComponents, (String)"draggedComponents");
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        GridBarriers barrier = GridUtilsKt.getGridBarriers(component2);
        Iterator<Integer> iterator = barrier.getRowIndices().iterator();
        while (iterator.hasNext()) {
            int row = ((Number)iterator.next()).intValue();
            Iterator<Integer> iterator2 = barrier.getColumnIndices().iterator();
            while (iterator2.hasNext()) {
                Rectangle bounds2;
                int column = ((Number)iterator2.next()).intValue();
                if (barrier.getBounds(row, column) == null || bounds2.width <= 0 || bounds2.height <= 0) continue;
                Region r = new Region(bounds2.x, bounds2.y, bounds2.x + bounds2.width, bounds2.y + bounds2.height, component2.getDepth());
                listBuilder.add((Object)new GridPlaceholder(r, row, column, this.getNamespace(), component2));
            }
        }
        ImmutableList immutableList = listBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"listBuilder.build()");
        return (List)immutableList;
    }
}

