/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.grid.CellInfo;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.InsetsAttributes;
import com.android.tools.idea.uibuilder.model.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001b\u0010\u0016\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u0017*\u00020\n2\u0006\u0010\u0018\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"MARGIN_ATTRIBUTES", "Lcom/android/tools/idea/uibuilder/handlers/grid/InsetsAttributes;", "PADDING_ATTRIBUTES", "getGridBarriers", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "gridComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "getPxValue", "", "nlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "value", "", "retrieveCellData", "Lcom/android/tools/idea/uibuilder/handlers/grid/CellInfo;", "isSupportLibrary", "", "retrieveInsets", "Lcom/android/tools/idea/uibuilder/model/Insets;", "attrs", "retrieveMargins", "retrievePaddings", "getLiveAndroidAttribute", "Lorg/jetbrains/annotations/Nullable;", "androidAttribute", "intellij.android.designer"})
public final class GridUtilsKt {
    @NotNull
    private static final InsetsAttributes PADDING_ATTRIBUTES = new InsetsAttributes("padding", (Pair<String, String>)new Pair((Object)"paddingStart", (Object)"paddingLeft"), "paddingTop", (Pair<String, String>)new Pair((Object)"paddingEnd", (Object)"paddingRight"), "paddingBottom");
    @NotNull
    private static final InsetsAttributes MARGIN_ATTRIBUTES = new InsetsAttributes("layout_margin", (Pair<String, String>)new Pair((Object)"layout_marginStart", (Object)"layout_marginLeft"), "layout_marginTop", (Pair<String, String>)new Pair((Object)"layout_marginEnd", (Object)"layout_marginRight"), "layout_marginBottom");

    @NotNull
    public static final GridBarriers getGridBarriers(@NotNull SceneComponent gridComponent) {
        Intrinsics.checkNotNullParameter((Object)gridComponent, (String)"gridComponent");
        boolean isSupportLibrary = AndroidXConstants.GRID_LAYOUT_V7.isEquals(gridComponent.getNlComponent().getTagName());
        NlComponent nlComponent = gridComponent.getAuthoritativeNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"gridComponent.authoritativeNlComponent");
        Insets padding = GridUtilsKt.retrievePaddings(nlComponent);
        int left = gridComponent.getDrawX() + GridUtilsKt.getGridBarriers$toDp(padding.left, gridComponent);
        int top = gridComponent.getDrawY() + GridUtilsKt.getGridBarriers$toDp(padding.top, gridComponent);
        int right2 = gridComponent.getDrawX() + gridComponent.getDrawWidth() - GridUtilsKt.getGridBarriers$toDp(padding.right, gridComponent);
        int bottom2 = gridComponent.getDrawY() + gridComponent.getDrawHeight() - GridUtilsKt.getGridBarriers$toDp(padding.bottom, gridComponent);
        List<SceneComponent> children = gridComponent.getChildren();
        HashMap rowMap = new HashMap();
        HashMap columnMap = new HashMap();
        int previousRow = 0;
        int previousColumn = -1;
        for (SceneComponent child : children) {
            Integer n;
            Integer n2;
            Object object;
            Map map2;
            if (child instanceof TemporarySceneComponent) continue;
            NlComponent nlComponent2 = child.getAuthoritativeNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"child.authoritativeNlComponent");
            CellInfo cellData = GridUtilsKt.retrieveCellData(nlComponent2, isSupportLibrary);
            if (cellData.getColumn() == -1) {
                cellData.setColumn(previousColumn + 1);
            }
            if (cellData.getRow() == -1) {
                cellData.setRow(previousRow);
            }
            NlComponent nlComponent3 = child.getAuthoritativeNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent3, (String)"child.authoritativeNlComponent");
            Insets marginInsets = GridUtilsKt.retrieveMargins(nlComponent3);
            int cellLeft = child.getDrawX() - GridUtilsKt.getGridBarriers$toDp(marginInsets.left, gridComponent);
            int cellTop = child.getDrawY() - GridUtilsKt.getGridBarriers$toDp(marginInsets.top, gridComponent);
            int cellRight = child.getDrawX() + child.getDrawWidth() + GridUtilsKt.getGridBarriers$toDp(marginInsets.right, gridComponent);
            int cellBottom = child.getDrawY() + child.getDrawHeight() + GridUtilsKt.getGridBarriers$toDp(marginInsets.bottom, gridComponent);
            if (cellData.getColumn() != 0) {
                map2 = columnMap;
                object = cellData.getColumn();
                Integer n3 = (Integer)columnMap.get(cellData.getColumn());
                if (n3 == null) {
                    n3 = Integer.MAX_VALUE;
                }
                int n4 = ((Number)n3).intValue();
                n2 = Math.min(cellLeft, n4);
                map2.put(object, n2);
            }
            if (cellData.getRow() != 0) {
                map2 = rowMap;
                object = cellData.getRow();
                Integer n5 = (Integer)rowMap.get(cellData.getRow());
                if (n5 == null) {
                    n5 = Integer.MAX_VALUE;
                }
                int n6 = ((Number)n5).intValue();
                n2 = Math.min(cellTop, n6);
                map2.put(object, n2);
            }
            if (cellData.getColumn() != -1 && cellData.getColumnSpan() != 0) {
                int rightIndex = cellData.getColumn() + cellData.getColumnSpan();
                object = columnMap;
                n2 = rightIndex;
                Integer n7 = (Integer)columnMap.get(rightIndex);
                if (n7 == null) {
                    n7 = Integer.MIN_VALUE;
                }
                int n8 = ((Number)n7).intValue();
                n = Math.max(cellRight, n8);
                object.put(n2, n);
            }
            if (cellData.getRow() != -1 && cellData.getRowSpan() != 0) {
                int bottomIndex = cellData.getRow() + cellData.getRowSpan();
                object = rowMap;
                n2 = bottomIndex;
                Integer n9 = (Integer)rowMap.get(bottomIndex);
                if (n9 == null) {
                    n9 = Integer.MIN_VALUE;
                }
                int n10 = ((Number)n9).intValue();
                n = Math.max(cellBottom, n10);
                object.put(n2, n);
            }
            previousRow = cellData.getRow();
            previousColumn = cellData.getColumn();
        }
        Set set = columnMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"columnMap.keys");
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)set);
        int columnCount = n != null ? n + 1 : 1;
        Set set2 = rowMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"rowMap.keys");
        Integer n11 = (Integer)CollectionsKt.maxOrNull((Iterable)set2);
        int rowCount = n11 != null ? n11 + 1 : 1;
        Integer n12 = left;
        ((Map)columnMap).put(0, n12);
        Integer n13 = columnCount;
        n12 = right2;
        ((Map)columnMap).put(n13, n12);
        n12 = top;
        ((Map)rowMap).put(0, n12);
        n13 = rowCount;
        n12 = bottom2;
        ((Map)rowMap).put(n13, n12);
        return new GridBarriers(rowMap, columnMap);
    }

    private static final CellInfo retrieveCellData(NlComponent nlComponent, boolean isSupportLibrary) {
        String namespace = isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        Function2 getAttribute2 = (Function2)new Function2<String, Integer, Integer>(nlComponent, namespace){
            final /* synthetic */ NlComponent $nlComponent;
            final /* synthetic */ String $namespace;
            {
                this.$nlComponent = $nlComponent;
                this.$namespace = $namespace;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull String name, int defaultValue) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Object object = this.$nlComponent.getLiveAttribute(this.$namespace, name);
                return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
            }
        };
        return new CellInfo(((Number)getAttribute2.invoke((Object)"layout_row", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_column", (Object)-1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_rowSpan", (Object)1)).intValue(), ((Number)getAttribute2.invoke((Object)"layout_columnSpan", (Object)1)).intValue());
    }

    private static final String getLiveAndroidAttribute(NlComponent $this$getLiveAndroidAttribute, String androidAttribute) {
        return $this$getLiveAndroidAttribute.getLiveAttribute("http://schemas.android.com/apk/res/android", androidAttribute);
    }

    private static final Insets retrieveMargins(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, MARGIN_ATTRIBUTES);
    }

    private static final Insets retrievePaddings(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, PADDING_ATTRIBUTES);
    }

    private static final Insets retrieveInsets(NlComponent nlComponent, InsetsAttributes attrs) {
        int left = 0;
        int top = 0;
        int right2 = 0;
        int bottom2 = 0;
        String valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getAll());
        if (valueString != null) {
            int padding;
            left = padding = GridUtilsKt.getPxValue(nlComponent, valueString);
            top = padding;
            right2 = padding;
            bottom2 = padding;
        } else {
            String string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getFirst());
            if (string2 == null) {
                string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getSecond());
            }
            valueString = string2;
            left = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getTop());
            top = GridUtilsKt.getPxValue(nlComponent, valueString);
            String string3 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getFirst());
            if (string3 == null) {
                string3 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getSecond());
            }
            valueString = string3;
            right2 = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getBottom());
            bottom2 = GridUtilsKt.getPxValue(nlComponent, valueString);
        }
        return new Insets(left, top, right2, bottom2);
    }

    private static final int getPxValue(NlComponent nlComponent, String value2) {
        if (value2 != null) {
            Configuration configuration = nlComponent.getModel().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"nlComponent.model.configuration");
            Configuration configuration2 = configuration;
            ResourceResolver resourceResolver = configuration2.getResourceResolver();
            Intrinsics.checkNotNullExpressionValue((Object)resourceResolver, (String)"configuration.resourceResolver");
            ResourceResolver resourceResolver2 = resourceResolver;
            Integer n = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver2, value2, configuration2);
            return n == null ? 0 : n;
        }
        return 0;
    }

    private static final int getGridBarriers$toDp(int $this$getGridBarriers_u24toDp, SceneComponent $gridComponent) {
        return Coordinates.pxToDp($gridComponent.getScene().getSceneManager(), $this$getGridBarriers_u24toDp);
    }
}

