/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.api.actions.ViewActionUtils;
import com.android.tools.idea.uibuilder.handlers.common.ViewGroupPlaceholder;
import com.android.tools.idea.uibuilder.handlers.linear.LinearDragHandler;
import com.android.tools.idea.uibuilder.handlers.linear.LinearPlaceholderFactory;
import com.android.tools.idea.uibuilder.handlers.linear.actions.BaselineAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ClearWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.DistributeWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ToggleOrientationAction;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearResizeTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.model.FillPolicy;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutHandler
extends ViewGroupHandler {
    final HashMap<SceneComponent, SceneComponent> myDraggingComponents = new HashMap();

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(0);
        }
        if (!component2.getTagName().equals("LinearLayout")) {
            String string2 = super.getTitleAttributes(component2);
            if (string2 == null) {
                LinearLayoutHandler.$$$reportNull$$$0(1);
            }
            return string2;
        }
        return this.isVertical(component2) ? "(vertical)" : "(horizontal)";
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(2);
        }
        if (!component2.getTagName().equals("LinearLayout")) {
            Icon icon2 = super.getIcon(component2);
            if (icon2 == null) {
                LinearLayoutHandler.$$$reportNull$$$0(3);
            }
            return icon2;
        }
        Icon icon3 = this.isVertical(component2) ? StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_VERT : StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ;
        if (icon3 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"orientation", (Object)"gravity");
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<String> getLayoutInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"layout_weight");
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    public boolean isVertical(@NotNull NlComponent component2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(7);
        }
        return "vertical".equals(component2.resolveAttribute("http://schemas.android.com/apk/res/android", "orientation"));
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            LinearLayoutHandler.$$$reportNull$$$0(8);
        }
        if (layout2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(9);
        }
        if (components == null) {
            LinearLayoutHandler.$$$reportNull$$$0(10);
        }
        if (type == null) {
            LinearLayoutHandler.$$$reportNull$$$0(11);
        }
        if (layout2.getDrawWidth() == 0 || layout2.getDrawHeight() == 0) {
            return null;
        }
        return new LinearDragHandler(editor, this, layout2, components, type);
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (layout2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(12);
        }
        if (newChild == null) {
            LinearLayoutHandler.$$$reportNull$$$0(13);
        }
        if (insertType == null) {
            LinearLayoutHandler.$$$reportNull$$$0(14);
        }
        if (insertType == InsertType.MOVE) {
            return;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(newChild);
        if (viewHandler != null) {
            boolean vertical = this.isVertical(layout2);
            FillPolicy fill2 = viewHandler.getFillPolicy();
            String fillParent = "match_parent";
            if (fill2.fillHorizontally(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill2 == FillPolicy.WIDTH_IN_VERTICAL) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill2.fillVertically(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(layout2) ? "layout_height" : "layout_width";
        for (NlComponent target : layout2.getChildren()) {
            String size;
            if (target == newChild) continue;
            String weight = target.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
            if (weight == null || weight.isEmpty()) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute)) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    static float getWeight(@NotNull NlComponent linearLayoutChild) {
        String weight;
        if (linearLayoutChild == null) {
            LinearLayoutHandler.$$$reportNull$$$0(15);
        }
        if ((weight = linearLayoutChild.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight")) != null && !weight.isEmpty()) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    static float getWeightSum(@NotNull NlComponent linearLayout) {
        String weightSum;
        if (linearLayout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(16);
        }
        if ((weightSum = linearLayout.getAttribute("http://schemas.android.com/apk/res/android", "weightSum")) != null) {
            try {
                float sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutHandler.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(@NotNull NlComponent linearLayout) {
        if (linearLayout == null) {
            LinearLayoutHandler.$$$reportNull$$$0(17);
        }
        float sum = 0.0f;
        for (NlComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutHandler.getWeight(child);
        }
        return sum;
    }

    public void clearWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(18);
        }
        if (selectedChildren == null) {
            LinearLayoutHandler.$$$reportNull$$$0(19);
        }
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    public void distributeWeights(@NotNull NlComponent component2, @NotNull List<NlComponent> selectedChildren) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(20);
        }
        if (selectedChildren == null) {
            LinearLayoutHandler.$$$reportNull$$$0(21);
        }
        if (selectedChildren.isEmpty()) {
            return;
        }
        String weightSum = component2.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = selectedChildren.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value2 = XmlUtils.formatFloatValue((double)((float)share));
        String sizeAttribute = this.isVertical(component2) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value2);
            if (!"wrap_content".equals(selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        if (actions2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(22);
        }
        actions2.add(ViewActionUtils.getViewOptionsAction());
        actions2.add(new ToggleOrientationAction());
        actions2.add(new BaselineAction());
        actions2.add(new DistributeWeightsAction());
        actions2.add(new ClearWeightsAction());
        actions2.add(new ViewActionSeparator());
        actions2.addAll(ViewActionUtils.getToggleSizeActions());
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component2, @NotNull List<ViewAction> actions2) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(23);
        }
        if (actions2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(24);
        }
        this.addToolbarActionsToMenu("LinearLayout", actions2);
        return true;
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView sceneView, int x, int y, @NotNull NlComponent component2) {
        if (sceneView == null) {
            LinearLayoutHandler.$$$reportNull$$$0(25);
        }
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(26);
        }
        return new SceneInteraction(sceneView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        if (parentComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(27);
        }
        if (childComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(28);
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)new LinearDragTarget(this));
        LinearLayoutHandler.createResizeTarget(parentComponent, childComponent, (ImmutableList.Builder<Target>)listBuilder);
        this.createSeparatorTargets(parentComponent, childComponent, (ImmutableList.Builder<Target>)listBuilder);
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            LinearLayoutHandler.$$$reportNull$$$0(29);
        }
        return immutableList;
    }

    private void createSeparatorTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        SceneComponent draggingComponent;
        if (parentComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(30);
        }
        if (childComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(31);
        }
        if (listBuilder == null) {
            LinearLayoutHandler.$$$reportNull$$$0(32);
        }
        if ((draggingComponent = this.myDraggingComponents.get(parentComponent)) != null && draggingComponent != childComponent) {
            boolean isLayoutOrientationVertical = this.isVertical(parentComponent.getNlComponent());
            if (LinearLayoutHandler.canReceiveBefore(parentComponent, childComponent, draggingComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, false));
            }
            if (LinearLayoutHandler.isLastChild(parentComponent, childComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, true));
            }
        }
    }

    private static void createResizeTarget(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        if (parentComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(33);
        }
        if (childComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(34);
        }
        if (listBuilder == null) {
            LinearLayoutHandler.$$$reportNull$$$0(35);
        }
        String orientation2 = parentComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        boolean showLeft = true;
        boolean showTop = true;
        boolean showBottom = true;
        boolean showRight = true;
        String gravityAttribute = childComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "layout_gravity");
        if (gravityAttribute == null || gravityAttribute.contains("fill")) {
            showLeft = false;
            showTop = false;
        } else {
            String[] gravities;
            String[] stringArray = gravities = gravityAttribute.split("\\|");
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String gravity;
                switch (gravity = stringArray[i]) {
                    case "left": 
                    case "start": {
                        showLeft = false;
                        continue block18;
                    }
                    case "top": {
                        showTop = false;
                        continue block18;
                    }
                    case "bottom": {
                        showBottom = false;
                        continue block18;
                    }
                    case "right": 
                    case "end": {
                        showRight = false;
                        continue block18;
                    }
                    case "center_horizontal": {
                        if (!"vertical".equals(orientation2)) continue block18;
                        showTop = false;
                        continue block18;
                    }
                    case "center_vertical": {
                        if (!"horizontal".equals(orientation2)) continue block18;
                        showLeft = false;
                    }
                }
            }
        }
        if (showLeft) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT));
        }
        if (showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.TOP));
        }
        if (showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.BOTTOM));
        }
        if (showRight) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT));
        }
        if (showLeft && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_TOP));
        }
        if (showLeft && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM));
        }
        if (showRight && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP));
        }
        if (showRight && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM));
        }
    }

    private static boolean canReceiveBefore(@NotNull SceneComponent parent, @NotNull SceneComponent nextSibling, @NotNull SceneComponent draggingComponent) {
        List<NlComponent> children;
        int i;
        if (parent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(36);
        }
        if (nextSibling == null) {
            LinearLayoutHandler.$$$reportNull$$$0(37);
        }
        if (draggingComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(38);
        }
        return (i = (children = parent.getNlComponent().getChildren()).indexOf(nextSibling.getNlComponent())) > -1 && (i == 0 || children.get(i - 1) != draggingComponent.getNlComponent());
    }

    private static boolean isLastChild(@NotNull SceneComponent linearLayoutComponent, @NotNull SceneComponent child) {
        NlComponent nlComponent;
        if (linearLayoutComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(39);
        }
        if (child == null) {
            LinearLayoutHandler.$$$reportNull$$$0(40);
        }
        return (nlComponent = linearLayoutComponent.getNlComponent()).getChild(nlComponent.getChildCount() - 1) == child.getNlComponent();
    }

    public static boolean insertComponentAtTarget(@NotNull SceneComponent component2, @NotNull LinearSeparatorTarget separatorTarget) {
        SceneComponent sceneParent;
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(41);
        }
        if (separatorTarget == null) {
            LinearLayoutHandler.$$$reportNull$$$0(42);
        }
        if ((sceneParent = component2.getParent()) == null) {
            return false;
        }
        NlComponent parent = sceneParent.getNlComponent();
        NlComponent before = !separatorTarget.isAtEnd() ? separatorTarget.getComponent().getNlComponent() : null;
        NlModel model2 = parent.getModel();
        model2.addComponents((List<NlComponent>)ImmutableList.of((Object)component2.getNlComponent()), parent, before, InsertType.MOVE, null);
        return true;
    }

    public void setDragging(@NotNull SceneComponent draggedComponent, boolean isDragging) {
        if (draggedComponent == null) {
            LinearLayoutHandler.$$$reportNull$$$0(43);
        }
        if (isDragging && !this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.put(draggedComponent.getParent(), draggedComponent);
        } else if (!isDragging && this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.remove(draggedComponent.getParent());
        }
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component2, @NotNull List<SceneComponent> draggedComponents) {
        if (component2 == null) {
            LinearLayoutHandler.$$$reportNull$$$0(44);
        }
        if (draggedComponents == null) {
            LinearLayoutHandler.$$$reportNull$$$0(45);
        }
        boolean vertical = this.isVertical(component2.getNlComponent());
        ArrayList<Placeholder> list = new ArrayList<Placeholder>();
        if (vertical) {
            int bottomOfChildren = component2.getDrawY();
            int left = component2.getDrawX();
            int right2 = component2.getDrawX() + component2.getDrawWidth();
            for (SceneComponent child : component2.getChildren()) {
                list.add(LinearPlaceholderFactory.createVerticalPlaceholder(component2, child, child.getDrawY(), left, right2));
                bottomOfChildren = Math.max(bottomOfChildren, child.getDrawY() + child.getDrawHeight());
            }
            list.add(LinearPlaceholderFactory.createVerticalPlaceholder(component2, null, bottomOfChildren, left, right2));
        } else {
            int rightOfChildren = component2.getDrawX();
            int top = component2.getDrawY();
            int bottom2 = component2.getDrawY() + component2.getDrawHeight();
            for (SceneComponent child : component2.getChildren()) {
                list.add(LinearPlaceholderFactory.createHorizontalPlaceholder(component2, child, child.getDrawX(), top, bottom2));
                rightOfChildren = Math.max(rightOfChildren, child.getDrawX() + child.getDrawWidth());
            }
            list.add(LinearPlaceholderFactory.createHorizontalPlaceholder(component2, null, rightOfChildren, top, bottom2));
        }
        list.add(new ViewGroupPlaceholder(component2));
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/linear/LinearLayoutHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayoutChild";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayout";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChildren";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childComponent";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listBuilder";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextSibling";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggingComponent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearLayoutComponent";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorTarget";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedComponent";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/LinearLayoutHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutInspectorProperties";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTitleAttributes";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVertical";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDragHandler";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onChildInserted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getWeightSum";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSumOfWeights";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearWeights";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "distributeWeights";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createChildTargets";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorTargets";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createResizeTarget";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canReceiveBefore";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isLastChild";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "insertComponentAtTarget";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setDragging";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4, 5, 6, 29 -> new IllegalStateException(string2);
        };
    }
}

