/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Graphics2D;

public class DrawLinearPlaceholder
extends DrawRegion {
    public DrawLinearPlaceholder(int x, int y, int width2, int height2) {
        this.setBounds(x, y, width2, height2);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        Color defColor = g.getColor();
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getDragReceiverBackground());
        g.fill(this);
        g.setColor(colorSet.getDragReceiverFrames());
        g.draw(this);
        g.setColor(defColor);
    }

    @Override
    public int getLevel() {
        return super.getLevel();
    }

    public static void add(DisplayList list, SceneContext context, boolean isLayoutVertical, boolean atEnd, int highLightSize, float left, float top, float right2, float bottom2) {
        int x = context.getSwingXDip(left);
        int y = context.getSwingYDip(top);
        int width2 = context.getSwingDimensionDip(right2 - left);
        int height2 = context.getSwingDimensionDip(bottom2 - top);
        highLightSize = context.getSwingDimensionDip(highLightSize);
        if (isLayoutVertical) {
            if (!atEnd) {
                y -= highLightSize / 2;
            }
            height2 = highLightSize;
        } else {
            if (!atEnd) {
                x -= highLightSize / 2;
            }
            width2 = highLightSize;
        }
        list.add(new DrawLinearPlaceholder(x, y, JBUIScale.scale((int)width2), JBUIScale.scale((int)height2)));
    }
}

