/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnimatedFrame;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnection;
import com.android.tools.idea.uibuilder.handlers.motion.DrawMotionPath;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MotionLayoutDecorator
extends SceneDecorator {
    public static final String CONSTRAINT_HOVER = "CONSTRAINT_HOVER";
    private static final boolean ourBlockSelection = false;
    private static final String[] LEFT_DIR = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[] TOP_DIR = new String[]{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf"};
    private static final String[] BOTTOM_DIR = new String[]{"layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf"};
    private static final String[] LEFT_DIR_RTL = new String[]{"layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"};
    private static final String[] RIGHT_DIR_RTL = new String[]{"layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", "layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf"};
    private static final String[][] ourConnections = new String[][]{LEFT_DIR, RIGHT_DIR, TOP_DIR, BOTTOM_DIR};
    private static final String[][] ourConnections_rtl = new String[][]{LEFT_DIR_RTL, RIGHT_DIR_RTL, TOP_DIR, BOTTOM_DIR};
    private static final String BASELINE = "BASELINE";
    private static final String[] BASELINE_DIR = new String[]{"layout_constraintBaseline_toBaselineOf"};
    private static final String BASELINE_TYPE = "BASELINE_TYPE";
    private static final String[][] MARGIN_ATTR_LTR = new String[][]{{"layout_marginStart", "layout_marginLeft"}, {"layout_marginEnd", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[][] MARGIN_ATTR_RTL = new String[][]{{"layout_marginEnd", "layout_marginLeft"}, {"layout_marginStart", "layout_marginRight"}, {"layout_marginTop"}, {"layout_marginBottom"}};
    private static final String[] BIAS_ATTR = new String[]{"layout_constraintHorizontal_bias", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintVertical_bias"};
    private static final boolean[] FLIP_BIAS = new boolean[]{true, false, false, true};
    private static final ConnectionType[] DIR_TABLE = new ConnectionType[]{ConnectionType.SAME, ConnectionType.BACKWARD, ConnectionType.SAME, ConnectionType.BACKWARD};
    private static final String[] ourDirections = new String[]{"LEFT", "RIGHT", "TOP", "BOTTOM"};
    private static final String[] ourChainDirections = new String[]{"CHAIN_LEFT", "CHAIN_RIGHT", "CHAIN_TOP", "CHAIN_BOTTOM"};
    private static final String[] ourDirectionsType = new String[]{"LEFT_TYPE", "RIGHT_TYPE", "TOP_TYPE", "BOTTOM_TYPE"};
    private static final AnchorTarget.Type[] ourAnchorTypes = new AnchorTarget.Type[]{AnchorTarget.Type.LEFT, AnchorTarget.Type.RIGHT, AnchorTarget.Type.TOP, AnchorTarget.Type.BOTTOM};
    private static final boolean[] isLeftRight = new boolean[]{true, true, false, false};
    private static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};
    private static final int DRAWPATH_SIZE = 200;
    private static final int MAX_KEY_POSITIONS = 101;
    private float[] mPathBuffer = new float[200];
    private int[] keyFrameTypes = new int[101];
    private float[] keyFramePos = new float[202];

    private static void convert(@NotNull SceneContext sceneContext, Rectangle rect) {
        if (sceneContext == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(0);
        }
        rect.x = sceneContext.getSwingXDip(rect.x);
        rect.y = sceneContext.getSwingYDip(rect.y);
        rect.width = sceneContext.getSwingDimensionDip(rect.width);
        rect.height = sceneContext.getSwingDimensionDip(rect.height);
    }

    private static void gatherProperties(@NotNull SceneComponent component2, @NotNull SceneComponent child) {
        boolean rtl;
        if (component2 == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(1);
        }
        if (child == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(2);
        }
        String[][] connections = (rtl = component2.getScene().isInRTL()) ? ourConnections_rtl : ourConnections;
        for (int i = 0; i < ourDirections.length; ++i) {
            MotionLayoutDecorator.getConnection(component2, child, connections[i], ourDirections[i], ourDirectionsType[i]);
        }
        MotionLayoutDecorator.getConnection(component2, child, BASELINE_DIR, BASELINE, BASELINE_TYPE);
    }

    private static void getMargins(SceneComponent component2, SceneComponent child, String[][] marginNames, String[] marginValues) {
        block5: {
            block4: {
                MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(component2.getNlComponent());
                if (motionLayout.isInTransition()) {
                    return;
                }
                Object id2 = null;
                ConnectionType type = ConnectionType.SAME;
                if (MotionUtils.isInBaseState(motionLayout)) break block4;
                Object properties2 = child.getNlComponent().getClientProperty("motionLayoutProperties");
                if (!(properties2 instanceof MotionAttributes)) break block5;
                MotionAttributes attrs = (MotionAttributes)properties2;
                HashMap<String, MotionAttributes.DefinedAttribute> a = attrs.getAttrMap();
                for (int i = 0; i < marginNames.length; ++i) {
                    Object name = null;
                    MotionAttributes.DefinedAttribute attribute = a.get(marginNames[i][0]);
                    if (attribute == null && marginNames[i].length == 2) {
                        attribute = a.get(marginNames[i][1]);
                    }
                    marginValues[i] = attribute != null ? attribute.getValue() : null;
                }
                break block5;
            }
            for (int i = 0; i < marginNames.length; ++i) {
                marginValues[i] = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", marginNames[i][0]);
                if (marginValues[i] != null || marginNames[i].length != 2) continue;
                marginValues[i] = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", marginNames[i][1]);
            }
        }
    }

    private static void getConnection(SceneComponent component2, SceneComponent child, String[] attributes, String dir, String dirType) {
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(component2.getNlComponent());
        if (motionLayout.isInTransition()) {
            child.myCache.clear();
            return;
        }
        String id2 = null;
        ConnectionType type = ConnectionType.SAME;
        if (!MotionUtils.isInBaseState(motionLayout)) {
            Object properties2 = child.getNlComponent().getClientProperty("motionLayoutProperties");
            if (properties2 != null && properties2 instanceof MotionAttributes) {
                MotionAttributes attrs = (MotionAttributes)properties2;
                HashMap<String, MotionAttributes.DefinedAttribute> a = attrs.getAttrMap();
                for (int i = 0; i < attributes.length; ++i) {
                    MotionAttributes.DefinedAttribute attribute = a.get(attributes[i]);
                    id2 = attribute != null ? attribute.getValue() : null;
                    type = DIR_TABLE[i];
                    if (id2 == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (int i = 0; i < attributes.length; ++i) {
                id2 = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", attributes[i]);
                type = DIR_TABLE[i];
                if (id2 == null) {
                    continue;
                }
                break;
            }
        }
        if (id2 == null) {
            child.myCache.put(dir, id2);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (id2.equalsIgnoreCase("parent")) {
            child.myCache.put(dir, component2);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        String cleanId = NlComponent.extractId(id2);
        if (cleanId == null) {
            child.myCache.put(dir, id2);
            child.myCache.put(dirType, (Object)ConnectionType.SAME);
            return;
        }
        if (cleanId.equals(component2.getId())) {
            child.myCache.put(dir, component2);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        for (SceneComponent con : component2.getChildren()) {
            if (!cleanId.equals(con.getId())) continue;
            child.myCache.put(dir, con);
            child.myCache.put(dirType, (Object)type);
            return;
        }
        child.myCache.put(dirType, (Object)ConnectionType.SAME);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component2;
        if (list == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(4);
        }
        if (sceneComponent == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(5);
        }
        List<SceneComponent> children = component2.getChildren();
        this.buildListPaths(sceneContext, (SceneComponent)component2, list);
        if (!children.isEmpty()) {
            for (SceneComponent child : component2.getChildren()) {
                MotionLayoutDecorator.gatherProperties((SceneComponent)component2, child);
            }
            Rectangle rect = new Rectangle();
            component2.fillRect(rect);
            list.pushClip(sceneContext, rect);
            Scene scene = component2.getScene();
            boolean showAllConstraints = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowAllConstraints");
            List<NlComponent> selection = scene.getSelection();
            for (SceneComponent child : children) {
                child.buildDisplayList(time, list, sceneContext);
                if (sceneContext.showOnlySelection() && !child.isSelected() || (!showAllConstraints || scene.getRoot() != component2) && !selection.contains(child.getNlComponent())) continue;
                MotionLayoutDecorator.buildListConnections(list, time, sceneContext, (SceneComponent)component2, child);
            }
            list.popClip();
        }
    }

    private void buildListPaths(SceneContext sceneContext, @NotNull SceneComponent component2, @NotNull DisplayList list) {
        MotionLayoutComponentHelper helper;
        if (component2 == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(6);
        }
        if (list == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(7);
        }
        if ((helper = MotionLayoutComponentHelper.create(component2.getNlComponent())).isInTransition() && helper.getShowPaths()) {
            List<SceneComponent> children = component2.getChildren();
            int size = this.mPathBuffer.length / 2;
            float x = component2.getDrawX();
            float y = component2.getDrawY();
            float w = component2.getDrawWidth();
            float h = component2.getDrawHeight();
            float factor = (float)sceneContext.getSwingDimensionDip(10000.0f) / (float)sceneContext.getSwingDimension(10000);
            h *= factor;
            w *= factor;
            for (SceneComponent child : children) {
                int len = helper.getPath(child.getNlComponent(), this.mPathBuffer, size);
                if (len <= 0) continue;
                float cbx = x + (float)child.getDrawWidth() * factor / 2.0f;
                float cby = y + (float)child.getDrawHeight() * factor / 2.0f;
                float cbw = w - (float)child.getDrawWidth() * factor;
                float cbh = h - (float)child.getDrawHeight() * factor;
                NlComponent childComponent = child.getNlComponent();
                Integer pos = (Integer)childComponent.getClientProperty("MotionDragKeyFrame");
                Integer key_pos_type = (Integer)childComponent.getClientProperty("MotionDragKeyPosType");
                float[] key_pos_percent = (float[])childComponent.getClientProperty("MotionDragKeyPosPercent");
                float percentX = key_pos_percent == null ? Float.NaN : key_pos_percent[0];
                float percentY = key_pos_percent == null ? Float.NaN : key_pos_percent[1];
                int selected_key = -1;
                if (pos != null) {
                    selected_key = pos;
                }
                int keyFrameCount = helper.getKeyframePos(childComponent, this.keyFrameTypes, this.keyFramePos);
                DrawMotionPath.buildDisplayList(child.isSelected(), list, selected_key, key_pos_type == null ? -1 : key_pos_type, this.mPathBuffer, size * 2, this.keyFrameTypes, this.keyFramePos, keyFrameCount, x, y, w, h, cbx, cby, cbw, cbh, percentX, percentY);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void buildListConnections(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent constraintComponent, @NotNull SceneComponent sceneComponent) {
        long changeStart;
        int i;
        void child;
        if (list == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(8);
        }
        if (sceneContext == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(9);
        }
        if (constraintComponent == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(10);
        }
        if (sceneComponent == null) {
            MotionLayoutDecorator.$$$reportNull$$$0(11);
        }
        Rectangle dest_rect = new Rectangle();
        Rectangle source_rect = new Rectangle();
        child.fillDrawRect(time, source_rect);
        MotionLayoutDecorator.convert(sceneContext, source_rect);
        ConnectionStatus connectStatus = new ConnectionStatus();
        List<NlComponent> selection = constraintComponent.getScene().getSelection();
        NlComponent component2 = child.getNlComponent();
        int hover = -1;
        Object hover_obj = component2.getClientProperty(CONSTRAINT_HOVER);
        if (hover_obj != null && hover_obj instanceof SecondarySelector.Constraint) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)hover_obj);
            hover = constraint.ordinal();
        }
        Object ss = constraintComponent.getScene().getSecondarySelection();
        int selectedDirection = -1;
        if (ss != null && ss instanceof SecondarySelector.Constraint) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)ss);
            selectedDirection = constraint.ordinal();
        }
        boolean constraintSelected = selectedDirection != -1;
        boolean anyViewSelected = selection != null && !selection.isEmpty();
        boolean fade = ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceFadeUnselected");
        if (fade && selection.isEmpty()) {
            fade = false;
        }
        if (fade && selection.contains(component2) && selection.size() == 1) {
            fade = false;
        }
        boolean viewSelected = selection.contains(child.getNlComponent());
        connectStatus.getConnectionInfo(child.getNlComponent(), viewSelected);
        ConnectionType[] connectionTypes = new ConnectionType[ourDirections.length];
        SceneComponent[] connectionTo = new SceneComponent[ourDirections.length];
        String[][] marginNames = constraintComponent.getScene().isInRTL() ? MARGIN_ATTR_RTL : MARGIN_ATTR_LTR;
        String[] marginValues = new String[marginNames.length];
        MotionLayoutDecorator.getMargins(constraintComponent, (SceneComponent)child, marginNames, marginValues);
        for (i = 0; i < ourDirections.length; ++i) {
            connectionTypes[i] = (ConnectionType)((Object)child.myCache.get(ourDirectionsType[i]));
            Object obj = child.myCache.get(ourDirections[i]);
            connectionTo[i] = obj instanceof SceneComponent ? (SceneComponent)obj : null;
        }
        for (i = 0; i < ourDirections.length; ++i) {
            boolean overlap;
            AnchorTarget anchorTarget;
            boolean shift;
            String biasString;
            int connect;
            boolean selectedConnection = selectedDirection == i && viewSelected;
            boolean hoverConnection = hover == i;
            ConnectionType type = connectionTypes[i];
            SceneComponent sc = connectionTo[i];
            int destType = 0;
            if (sc == null) continue;
            sc.fillDrawRect(time, dest_rect);
            MotionLayoutDecorator.convert(sceneContext, dest_rect);
            int n = connect = type == ConnectionType.SAME ? i : ourOppositeDirection[i];
            if (child.getParent().equals(sc)) {
                destType = 1;
            } else if (AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent())) || AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER.isEqualsIgnoreCase(NlComponentHelperKt.getComponentClassName(sc.getNlComponent()))) {
                destType = 2;
            }
            int connectType = 1;
            if (connectionTo[ourOppositeDirection[i]] != null) {
                connectType = 2;
                if (connectionTo[ourOppositeDirection[i]] == sc && destType != 1) {
                    connectType = connectionTypes[ourOppositeDirection[i]] != type ? 4 : 6;
                }
            }
            SceneComponent toComponentsTo = (SceneComponent)sc.myCache.get(ourDirections[connect]);
            if (type == ConnectionType.BACKWARD && toComponentsTo == child && sc.myCache.get(ourDirectionsType[connect]) == ConnectionType.BACKWARD) {
                connectType = 3;
                if (sc.myCache.containsKey(ourChainDirections[ourOppositeDirection[i]])) continue;
            }
            int margin = 0;
            int marginDistance = 0;
            boolean isMarginReference = false;
            float bias = 0.5f;
            String marginString = marginValues[i];
            if (marginString != null) {
                if (marginString.startsWith("@")) {
                    isMarginReference = true;
                }
                margin = ConstraintUtilities.getDpValue(child.getAuthoritativeNlComponent(), marginString);
                marginDistance = sceneContext.getSwingDimensionDip(margin);
            }
            if ((biasString = child.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", BIAS_ATTR[i])) != null) {
                try {
                    bias = Float.parseFloat(biasString);
                    if (FLIP_BIAS[i]) {
                        bias = 1.0f - bias;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = shift = toComponentsTo != null;
            if (destType == 2) {
                connect = ourOppositeDirection[i];
            }
            boolean onDelete = (anchorTarget = AnchorTarget.findAnchorTarget((SceneComponent)child, ourAnchorTypes[i])) != null && anchorTarget.canDisconnect() && anchorTarget.isMouseHovered();
            changeStart = connectStatus.getTime(i);
            int previousMode = connectStatus.getPreviousMode(i);
            int currentMode = connectStatus.getCurrentMode(i, selectedConnection, fade, constraintSelected, anyViewSelected, hoverConnection, onDelete);
            int x1 = MotionLayoutDecorator.getX(source_rect, i);
            int x2 = MotionLayoutDecorator.getX(dest_rect, connect);
            int y1 = MotionLayoutDecorator.getY(source_rect, i);
            int y2 = MotionLayoutDecorator.getY(dest_rect, connect);
            boolean bl2 = overlap = i != connect && (isLeftRight[i] && Math.abs(x1 - x2) < 4 && Math.abs(y1 - y2) < dest_rect.height / 2 || !isLeftRight[i] && Math.abs(y1 - y2) < 4 && Math.abs(x1 - x2) < dest_rect.width / 2);
            if (overlap) {
                connectType = 7;
            }
            if (!ConstraintLayoutHandler.getVisualProperty("ConstraintLayoutPreferenceShowMargins")) {
                margin = 0;
                marginDistance = 0;
            }
            DrawConnection.buildDisplayList(list, SecondarySelector.get(child.getNlComponent(), SecondarySelector.Constraint.values()[i]), connectType, source_rect, i, dest_rect, connect, destType, shift, margin, marginDistance, isMarginReference, Float.valueOf(bias), previousMode, currentMode, changeStart);
            if ((anchorTarget == null || !anchorTarget.isMouseHovered()) && !hoverConnection || !viewSelected) continue;
            if (destType == 2) {
                int over_size_line = 3000;
                dest_rect.grow(connect < 2 ? 1 : over_size_line, connect < 2 ? over_size_line : 1);
            }
            boolean drawFrameAsDelete = (currentMode & 0xFFFFFEFF) == 6;
            DrawAnimatedFrame.add(list, dest_rect, connect, drawFrameAsDelete);
        }
        SceneComponent baseLineConnection = (SceneComponent)child.myCache.get(BASELINE);
        if (baseLineConnection != null) {
            baseLineConnection.fillDrawRect(time, dest_rect);
            MotionLayoutDecorator.convert(sceneContext, dest_rect);
            int dest_offset = sceneContext.getSwingDimensionDip(baseLineConnection.getBaseline());
            int source_offset = sceneContext.getSwingDimensionDip(child.getBaseline());
            source_rect.y += source_offset;
            source_rect.height = 0;
            dest_rect.y += dest_offset;
            dest_rect.height = 0;
            changeStart = connectStatus.getTime(4);
            AnchorTarget anchorTarget = AnchorTarget.findAnchorTarget((SceneComponent)child, AnchorTarget.Type.BASELINE);
            boolean onDelete = anchorTarget != null && anchorTarget.canDisconnect() && anchorTarget.isMouseHovered();
            int previousMode = connectStatus.getPreviousMode(4);
            boolean selectedConnection = selectedDirection == SecondarySelector.Constraint.BASELINE.ordinal() && viewSelected;
            boolean hoverConnection = hover == SecondarySelector.Constraint.BASELINE.ordinal();
            int currentMode = connectStatus.getCurrentMode(4, selectedConnection, fade, constraintSelected, anyViewSelected, hoverConnection, onDelete);
            DrawConnection.buildDisplayList(list, SecondarySelector.get(child.getNlComponent(), SecondarySelector.Constraint.BASELINE), 5, source_rect, 5, dest_rect, 5, 0, false, 0, 0, false, Float.valueOf(0.0f), previousMode, currentMode, changeStart);
        }
    }

    private static int getX(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.x;
            }
            case 1: {
                return rectangle.x + rectangle.width + 1;
            }
            case 2: {
                return rectangle.x + rectangle.width / 2;
            }
            case 3: {
                return rectangle.x + rectangle.width / 2;
            }
        }
        return 0;
    }

    private static int getY(Rectangle rectangle, int direction) {
        switch (direction) {
            case 0: {
                return rectangle.y + rectangle.height / 2;
            }
            case 1: {
                return rectangle.y + rectangle.height / 2;
            }
            case 2: {
                return rectangle.y;
            }
            case 3: {
                return rectangle.y + rectangle.height + 1;
            }
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintComponent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "gatherProperties";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildListChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "buildListPaths";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "buildListConnections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum ConnectionType {
        SAME,
        BACKWARD;

    }

    static class ConnectionStatus {
        static String[] connectTypes = new String[]{"left", "right", "north", "bottom", "baseline"};
        public static final int DIRECTION_BASELINE = 4;
        int[] mPrevious = new int[connectTypes.length];
        int[] mCurrent = new int[connectTypes.length];
        long[] mStartTime = new long[connectTypes.length];
        DecoratorUtilities.ViewStates componentPrevState;
        DecoratorUtilities.ViewStates componentCurrentState;
        Long componentChangeStateTime;
        boolean mMyViewSelected = true;

        ConnectionStatus() {
        }

        void getConnectionInfo(NlComponent c, boolean isSelected) {
            this.componentPrevState = DecoratorUtilities.getTimedChange_prev(c, "view");
            this.componentCurrentState = DecoratorUtilities.getTimedChange_value(c, "view");
            this.componentChangeStateTime = DecoratorUtilities.getTimedChange_time(c, "drawState");
            this.mMyViewSelected = isSelected;
            for (int i = 0; i < connectTypes.length; ++i) {
                DecoratorUtilities.ViewStates current;
                String type = connectTypes[i];
                if (this.componentCurrentState != DecoratorUtilities.ViewStates.SELECTED && (current = DecoratorUtilities.getTimedChange_value(c, type)) == DecoratorUtilities.ViewStates.SELECTED) {
                    long t = this.componentChangeStateTime != null ? this.componentChangeStateTime : System.nanoTime();
                    DecoratorUtilities.setTimeChange(c, type, t, current, DecoratorUtilities.ViewStates.NORMAL);
                }
                DecoratorUtilities.ViewStates prev = DecoratorUtilities.getTimedChange_prev(c, type);
                current = DecoratorUtilities.getTimedChange_value(c, type);
                Long event = DecoratorUtilities.getTimedChange_time(c, type);
                if (event != null) {
                    this.mStartTime[i] = event;
                    this.mPrevious[i] = prev.getVal();
                    this.mCurrent[i] = current.getVal();
                    continue;
                }
                this.mStartTime[i] = -1L;
            }
        }

        int getPreviousMode(int direction) {
            if (this.mStartTime[direction] == -1L) {
                if (this.componentPrevState == DecoratorUtilities.ViewStates.NORMAL) {
                    return 0;
                }
                return this.mCurrent[direction];
            }
            return this.mPrevious[direction];
        }

        int getCurrentMode(int direction, boolean thisConstraintSelected, boolean fade, boolean anyConstraintSelected, boolean anyViewSelected, boolean hoverConnection, boolean onDelete) {
            int hoverFlag;
            int ret = 0;
            int n = hoverFlag = hoverConnection ? 256 : 0;
            if (onDelete) {
                return hoverFlag | 6;
            }
            if (thisConstraintSelected) {
                return hoverFlag | 5;
            }
            if (anyConstraintSelected) {
                return hoverFlag | 1;
            }
            if (anyViewSelected && !this.mMyViewSelected) {
                return hoverFlag | 1;
            }
            ret = this.mStartTime[direction] == -1L ? this.mCurrent[direction] : this.mCurrent[direction];
            if (ret == 0 && fade) {
                ret = 1;
            }
            return hoverFlag | ret;
        }

        long getTime(int direction) {
            if (this.mStartTime[direction] == -1L) {
                return this.componentChangeStateTime == null ? 0L : this.componentChangeStateTime;
            }
            return this.mStartTime[direction];
        }
    }
}

