/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.MotionConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.handlers.motion.CommonActions;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentModificationDelegate;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutPlaceholder;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionAccessoryPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutDragTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutResizeTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutHandler
extends ViewGroupHandler {
    private static final boolean DEBUG = false;
    private static HashSet<String> ourHorizontalBarriers = new HashSet<String>(Arrays.asList("top", "bottom"));
    private static String MOTION_ACCESSORY = "MotionLayoutHandler.MotionAccessory";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"showPaths");
        if (immutableList == null) {
            MotionLayoutHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            MotionLayoutHandler.$$$reportNull$$$0(1);
        }
        sceneComponent.setNotchProvider(new ConstraintLayoutNotchProvider());
        ImmutableList immutableList = ImmutableList.of((Object)new LassoTarget(), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.LEFT, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.TOP, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.RIGHT, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.BOTTOM, true));
        if (immutableList == null) {
            MotionLayoutHandler.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        if (parentComponent == null) {
            MotionLayoutHandler.$$$reportNull$$$0(3);
        }
        if (childComponent == null) {
            MotionLayoutHandler.$$$reportNull$$$0(4);
        }
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        NlComponent nlComponent = childComponent.getAuthoritativeNlComponent();
        nlComponent.setComponentModificationDelegate(new MotionLayoutComponentModificationDelegate());
        ViewInfo vi = NlComponentHelperKt.getViewInfo(nlComponent);
        if (vi != null) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
                String orientation2 = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                boolean isHorizontal = true;
                if (orientation2 != null && orientation2.equalsIgnoreCase("vertical")) {
                    isHorizontal = false;
                }
                listBuilder.add((Object)new GuidelineTarget(isHorizontal)).add((Object)(isHorizontal ? new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true) : new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false))).add((Object)new GuidelineCycleTarget(isHorizontal));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    MotionLayoutHandler.$$$reportNull$$$0(5);
                }
                return immutableList;
            }
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                @NonNls String side = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
                boolean isHorizontal = side == null || ourHorizontalBarriers.contains(side.toLowerCase(Locale.ROOT));
                listBuilder.add((Object)new BarrierAnchorTarget(isHorizontal ? AnchorTarget.Type.TOP : AnchorTarget.Type.RIGHT, BarrierTarget.parseDirection(side))).add((Object)new BarrierTarget(BarrierTarget.parseDirection(side)));
                ImmutableList immutableList = listBuilder.build();
                if (immutableList == null) {
                    MotionLayoutHandler.$$$reportNull$$$0(6);
                }
                return immutableList;
            }
        }
        childComponent.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        listBuilder.add((Object[])new Target[]{new MotionLayoutDragTarget(), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.LEFT_TOP), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM), new MotionLayoutAnchorTarget(AnchorTarget.Type.LEFT, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.TOP, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.RIGHT, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.BOTTOM, false)});
        int baseline = NlComponentHelperKt.getBaseline(childComponent.getNlComponent());
        ViewInfo info = NlComponentHelperKt.getViewInfo(childComponent.getNlComponent());
        if (baseline <= 0 && info != null) {
            baseline = info.getBaseLine();
        }
        if (baseline > 0) {
            listBuilder.add((Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.BASELINE, false));
        }
        ImmutableList immutableList = listBuilder.build();
        if (immutableList == null) {
            MotionLayoutHandler.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component2, @NotNull List<SceneComponent> draggedComponents) {
        if (component2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(8);
        }
        if (draggedComponents == null) {
            MotionLayoutHandler.$$$reportNull$$$0(9);
        }
        return ImmutableList.of((Object)new MotionLayoutPlaceholder(component2));
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component2, @NotNull List<ViewAction> actions2) {
        if (component2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(10);
        }
        if (actions2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(11);
        }
        CommonActions.getPopupMenuActions(component2, actions2);
        return false;
    }

    @Override
    public boolean needsAccessoryPanel(@NotNull AccessoryPanel.Type type) {
        if (type == null) {
            MotionLayoutHandler.$$$reportNull$$$0(12);
        }
        switch (type) {
            case SOUTH_PANEL: 
            case EAST_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public AccessoryPanelInterface createAccessoryPanel(@NotNull DesignSurface<?> surface2, @NotNull AccessoryPanel.Type type, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility panelVisibility) {
        if (surface2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(13);
        }
        if (type == null) {
            MotionLayoutHandler.$$$reportNull$$$0(14);
        }
        if (parent == null) {
            MotionLayoutHandler.$$$reportNull$$$0(15);
        }
        if (panelVisibility == null) {
            MotionLayoutHandler.$$$reportNull$$$0(16);
        }
        assert (surface2 instanceof NlDesignSurface) : "MotionLayoutHandler needs an NlDesignSurface";
        switch (type) {
            case SOUTH_PANEL: {
                MotionAccessoryPanel accessoryPanel = new MotionAccessoryPanel((NlDesignSurface)surface2, parent, panelVisibility);
                parent.putClientProperty(MOTION_ACCESSORY, accessoryPanel);
                MotionAccessoryPanel motionAccessoryPanel = accessoryPanel;
                if (motionAccessoryPanel == null) {
                    MotionLayoutHandler.$$$reportNull$$$0(17);
                }
                return motionAccessoryPanel;
            }
            case EAST_PANEL: {
                return new MotionAttributePanel(parent, panelVisibility);
            }
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView screenView, int x, int y, @NotNull NlComponent component2) {
        MotionLayoutComponentHelper helper;
        if (screenView == null) {
            MotionLayoutHandler.$$$reportNull$$$0(18);
        }
        if (component2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(19);
        }
        if ((helper = MotionLayoutComponentHelper.create(component2)).isInTransition() && MotionLayoutSceneInteraction.hitKeyFrame(screenView, x, y, helper, component2)) {
            return new MotionLayoutSceneInteraction(screenView, component2);
        }
        return null;
    }

    @Override
    public void cleanUpAttributes(@NotNull NlComponent component2, @NotNull NlAttributesHolder attributes) {
        if (component2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(20);
        }
        if (attributes == null) {
            MotionLayoutHandler.$$$reportNull$$$0(21);
        }
        ConstraintComponentUtilities.cleanup(attributes, component2);
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (layout2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(22);
        }
        if (newChild == null) {
            MotionLayoutHandler.$$$reportNull$$$0(23);
        }
        if (insertType == null) {
            MotionLayoutHandler.$$$reportNull$$$0(24);
        }
        newChild.ensureId();
        super.onChildInserted(layout2, newChild, insertType);
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        if (actions2 == null) {
            MotionLayoutHandler.$$$reportNull$$$0(25);
        }
        CommonActions.getToolbarActions(actions2);
    }

    @Override
    @NotNull
    public CustomPanel getLayoutCustomPanel() {
        return new MotionConstraintPanel((List<NlComponent>)ImmutableList.of());
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull Collection<NlComponent> deleted) {
        if (parent == null) {
            MotionLayoutHandler.$$$reportNull$$$0(26);
        }
        if (deleted == null) {
            MotionLayoutHandler.$$$reportNull$$$0(27);
        }
        MotionAccessoryPanel accessoryPanel = (MotionAccessoryPanel)parent.getClientProperty(MOTION_ACCESSORY);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            NlComponent component2 = parent.getChild(i);
            if (deleted.contains(component2)) {
                String id2 = component2.getId();
                if (id2 == null || accessoryPanel == null) continue;
                MotionSceneUtils.deleteRelatedConstraintSets(accessoryPanel.getMotionScene(), id2);
                continue;
            }
            ConstraintLayoutHandler.willDelete(component2, deleted);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childComponent";
                break;
            }
            case 8: 
            case 10: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedComponents";
                break;
            }
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panelVisibility";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/MotionLayoutHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargets";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildTargets";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessoryPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTargets";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildTargets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPopupMenuActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "needsAccessoryPanel";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAccessoryPanel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInteraction";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpAttributes";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onChildInserted";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildren";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 4, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 -> new IllegalArgumentException(string2);
        };
    }
}

