/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.AndroidXConstants;
import com.android.ide.common.gradle.Version;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionDesignSurfaceEdits;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionLayoutInterface;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MESaveGif;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditor;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.io.PsiFileUtil;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionAccessoryPanel
implements AccessoryPanelInterface,
MotionLayoutInterface,
MotionDesignSurfaceEdits {
    private static final boolean DEBUG = false;
    private static final boolean TEMP_HACK_FORCE_APPLY = false;
    private final Project myProject;
    private final NlDesignSurface myDesignSurface;
    private final ResourceNotificationManager.ResourceChangeListener myResourceListener;
    private final NlComponentTag myMotionLayoutTag;
    private final NlComponent myMotionLayoutNlComponent;
    MotionSceneTag myMotionScene;
    VirtualFile myMotionSceneFile;
    ViewGroupHandler.AccessoryPanelVisibility mVisibility;
    MotionEditor mMotionEditor;
    public static final String TIMELINE = "Timeline";
    MotionLayoutComponentHelper myMotionHelper;
    private String mSelectedStartConstraintId;
    private String mSelectedEndConstraintId;
    private float mLastProgress;
    private final List<AccessorySelectionListener> myListeners;
    private NlComponent mySelection;
    private NlComponent myMotionLayout;
    private MotionEditorSelector.Type mLastSelection;
    private MTag[] myLastSelectedTags;
    private boolean mShowPath;
    private boolean myUpdatingSelectionInLayoutEditor;
    private boolean myUpdatingSelectionFromLayoutEditor;
    private float myStartDegree;
    private float myEndDegree;
    private static final int NUM_SAVED_IMAGES = 60;
    private static final int WAIF_FOR_TIME = 100;
    private static final int GIF_PLAY_DELAY = 80;
    private MESaveGif mySaveGif;

    private void applyMotionSceneValue(boolean apply) {
    }

    public MotionAccessoryPanel(final @NotNull NlDesignSurface surface2, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        if (surface2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(2);
        }
        this.mMotionEditor = new MotionEditor();
        this.mLastProgress = 0.0f;
        this.mLastSelection = MotionEditorSelector.Type.LAYOUT;
        this.mShowPath = true;
        this.myUpdatingSelectionInLayoutEditor = false;
        this.myUpdatingSelectionFromLayoutEditor = false;
        this.myStartDegree = Float.NaN;
        this.myEndDegree = Float.NaN;
        this.myDesignSurface = surface2;
        this.myProject = surface2.getProject();
        this.myMotionLayoutNlComponent = parent;
        this.myMotionLayoutTag = new NlComponentTag(parent, null);
        this.mVisibility = visibility;
        MotionLayoutComponentHelper.clearCache();
        this.myMotionHelper = MotionLayoutComponentHelper.create(this.myMotionLayoutNlComponent);
        this.myListeners = new ArrayList<AccessorySelectionListener>();
        this.myResourceListener = this.createResourceChangeListener();
        this.mMotionEditor.myTrack.init(this.myDesignSurface);
        SelectionModel designSurfaceSelection = this.myDesignSurface.getSelectionModel();
        List<NlComponent> dsSelection = designSurfaceSelection.getSelection();
        designSurfaceSelection.addListener((SelectionModel model2, List<NlComponent> selection) -> this.handleSelectionChanged(model2, selection));
        this.mMotionEditor.addCommandListener(new MotionEditor.Command(){

            @Override
            public void perform(MotionEditor.Command.Action action2, MTag[] tag2) {
                switch (action2) {
                    case DELETE: {
                        for (int i = 0; i < tag2.length; ++i) {
                            tag2[i].getTagWriter().deleteTag().commit("delete " + tag2[i].getTagName());
                        }
                        break;
                    }
                    case COPY: {
                        CharSequence[] buff = new CharSequence[tag2.length];
                        for (int i = 0; i < tag2.length; ++i) {
                            buff[i] = MTag.serializeTag(tag2[i]);
                        }
                        break;
                    }
                }
            }
        });
        this.mMotionEditor.addSelectionListener(new MotionEditorSelector.Listener(){

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag2, int flags) {
                MotionAccessoryPanel.this.mLastSelection = selection;
                MotionAccessoryPanel.this.myLastSelectedTags = tag2;
                switch (selection) {
                    case CONSTRAINT_SET: {
                        String id2 = tag2[0].getAttributeValue("id");
                        if (id2 == null) break;
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = Utils.stripID(id2);
                        MotionAccessoryPanel.this.mSelectedEndConstraintId = null;
                        MotionAccessoryPanel.this.myMotionHelper.setState(MotionAccessoryPanel.this.mSelectedStartConstraintId);
                        break;
                    }
                    case TRANSITION: {
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = Utils.stripID(tag2[0].getAttributeValue("constraintSetStart"));
                        MotionAccessoryPanel.this.mSelectedEndConstraintId = Utils.stripID(tag2[0].getAttributeValue("constraintSetEnd"));
                        MotionAccessoryPanel.this.myMotionHelper.setTransition(MotionAccessoryPanel.this.mSelectedStartConstraintId, MotionAccessoryPanel.this.mSelectedEndConstraintId);
                        MotionAccessoryPanel.this.myMotionHelper.setProgress(MotionAccessoryPanel.this.mLastProgress);
                        if (flags == 1) {
                            MotionAccessoryPanel.this.mShowPath = !MotionAccessoryPanel.this.mShowPath;
                        }
                        MotionAccessoryPanel.this.myMotionHelper.setShowPaths(MotionAccessoryPanel.this.mShowPath);
                        break;
                    }
                    case LAYOUT: {
                        MotionAccessoryPanel.this.selectOnDesignSurface(tag2);
                        MotionAccessoryPanel.this.myMotionHelper.setState(null);
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = null;
                        break;
                    }
                    case CONSTRAINT: {
                        MotionAccessoryPanel.this.selectOnDesignSurface(tag2);
                        if (tag2[0] instanceof MotionSceneTag) {
                            MotionSceneTag msTag = (MotionSceneTag)tag2[0];
                            String id3 = Utils.stripID(msTag.getAttributeValue("id"));
                            MTag[] layoutViews = MotionAccessoryPanel.this.myMotionLayoutTag.getChildTags();
                            for (int i = 0; i < layoutViews.length; ++i) {
                                MTag view2 = layoutViews[i];
                                String vid = Utils.stripID(view2.getAttributeValue("id"));
                                if (!vid.equals(id3)) continue;
                                MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)view2);
                            }
                            break;
                        }
                        if (!(tag2[0] instanceof NlComponentTag)) break;
                        MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)tag2[0]);
                        break;
                    }
                    case LAYOUT_VIEW: {
                        if (tag2.length <= 0 || !(tag2[0] instanceof NlComponentTag)) break;
                        MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)tag2[0]);
                        break;
                    }
                }
                if (!MotionAccessoryPanel.this.mMotionEditor.isUpdatingModel()) {
                    MotionAccessoryPanel.this.fireSelectionChanged(Collections.singletonList(MotionAccessoryPanel.this.mySelection));
                }
            }
        });
        this.mMotionEditor.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                switch (cmd) {
                    case MOTION_PROGRESS: {
                        MotionAccessoryPanel.this.myMotionHelper.setProgress(pos);
                        MotionAccessoryPanel.this.mLastProgress = pos;
                        MotionAccessoryPanel.this.applyRotation();
                        break;
                    }
                    case MOTION_SCRUB: {
                        surface2.setAnimationScrubbing(true);
                        MotionAccessoryPanel.this.startScreenRotating();
                    }
                    case MOTION_PLAY: {
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.updateSceneView();
                        manager.requestLayoutAndRenderAsync(false);
                        surface2.setRenderSynchronously(true);
                        break;
                    }
                    case MOTION_STOP: {
                        surface2.setRenderSynchronously(false);
                        surface2.setAnimationScrubbing(false);
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.requestLayoutAndRenderAsync(false);
                        MotionAccessoryPanel.this.stopScreenRotating();
                        break;
                    }
                    case MOTION_CAPTURE: {
                        int playMode = MotionAccessoryPanel.this.mMotionEditor.getPlayMode();
                        int numImages = playMode == 2 ? 60 : 30;
                        float speed = MotionAccessoryPanel.this.mMotionEditor.getTimeLineSpeed();
                        int playDelay = (int)(80.0f / speed);
                        String filename = MotionAccessoryPanel.this.mSelectedStartConstraintId + "->" + MotionAccessoryPanel.this.mSelectedEndConstraintId + ".gif";
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.updateSceneView();
                        manager.requestLayoutAndRenderAsync(false);
                        surface2.setRenderSynchronously(true);
                        FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Transition as GIF", "Save the selected transition as GIF", new String[]{"gif"});
                        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Project)null);
                        VirtualFileWrapper fileWrapper = saveFileDialog.save(filename);
                        if (fileWrapper == null) break;
                        File file2 = fileWrapper.getFile();
                        MotionAccessoryPanel.this.mySaveGif = new MESaveGif(file2, playDelay, true, "Written by Android Studio");
                        MotionAccessoryPanel.this.mySaveGif.saveGif(MotionAccessoryPanel.this.myDesignSurface, numImages, playMode, MotionAccessoryPanel.this.myMotionHelper, MotionAccessoryPanel.this.myProject, 100);
                    }
                }
            }
        });
        MotionSceneTag.Root motionScene = this.getMotionScene(this.myMotionLayoutNlComponent);
        this.myMotionScene = motionScene;
        VirtualFile sceneFile = this.myMotionSceneFile = motionScene == null ? null : motionScene.mVirtualFile;
        String sceneFileName = sceneFile == null ? "" : sceneFile.getName();
        String layoutFileName = MotionAccessoryPanel.getLayoutFileName(surface2);
        this.mMotionEditor.setMTag(this.myMotionScene, this.myMotionLayoutTag, layoutFileName, sceneFileName, this.getSetupError());
        if (this.myMotionScene == null) {
            return;
        }
        MTag[] cSet = this.myMotionScene.getChildTags("ConstraintSet");
        if (cSet != null && cSet.length > 0) {
            this.mMotionEditor.selectTag(cSet[0], 0);
        }
        parent.putClientProperty(TIMELINE, this);
        AndroidFacet facet = parent.getModel().getFacet();
        ResourceNotificationManager.getInstance((Project)this.myProject).addListener(this.myResourceListener, facet, null, null);
        this.handleSelectionChanged(designSurfaceSelection, dsSelection);
    }

    @NotNull
    private static String getLayoutFileName(@NotNull NlDesignSurface surface2) {
        NlModel model2;
        if (surface2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(3);
        }
        if ((model2 = surface2.getModel()) == null) {
            return "";
        }
        String string2 = model2.getVirtualFile().getName().replace(".xml", "");
        if (string2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    private ResourceNotificationManager.ResourceChangeListener createResourceChangeListener() {
        return new ResourceNotificationManager.ResourceChangeListener(){

            public void resourcesChanged(@NotNull ImmutableSet<ResourceNotificationManager.Reason> reason) {
                boolean forLayout;
                if (reason == null) {
                    4.$$$reportNull$$$0(0);
                }
                boolean bl = forLayout = MotionAccessoryPanel.this.mLastSelection == MotionEditorSelector.Type.LAYOUT || MotionAccessoryPanel.this.mLastSelection == MotionEditorSelector.Type.LAYOUT_VIEW;
                if (forLayout) {
                    return;
                }
                MotionAccessoryPanel.this.mLastSelection = null;
                MotionAccessoryPanel.this.myLastSelectedTags = null;
                MotionSceneTag.Root motionScene = MotionAccessoryPanel.this.getMotionScene(MotionAccessoryPanel.this.myMotionLayoutNlComponent);
                if (motionScene != null) {
                    MotionAccessoryPanel.this.myMotionScene = motionScene;
                    MotionAccessoryPanel.this.myMotionSceneFile = motionScene.mVirtualFile;
                    MotionAccessoryPanel.this.mMotionEditor.setMTag(MotionAccessoryPanel.this.myMotionScene, MotionAccessoryPanel.this.myMotionLayoutTag, "", "", MotionAccessoryPanel.this.getSetupError());
                    if (MotionAccessoryPanel.this.myLastSelectedTags == null) {
                        MotionAccessoryPanel.this.selectSomething(motionScene);
                    }
                }
                MotionAccessoryPanel.this.fireSelectionChanged(Collections.singletonList(MotionAccessoryPanel.this.mySelection));
                if (motionScene != null) {
                    PsiFileUtil.saveFileIfNecessary((PsiFile)motionScene.mXmlFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/android/tools/idea/uibuilder/handlers/motion/editor/MotionAccessoryPanel$4", "resourcesChanged"));
            }
        };
    }

    private void updateSelectionInLayoutEditor(@NotNull NlComponentTag tag2) {
        if (tag2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(5);
        }
        this.updateSelectionInLayoutEditor(Collections.singletonList(tag2.mComponent));
    }

    private void updateSelectionInLayoutEditor(@NotNull List<NlComponent> selected) {
        if (selected == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(6);
        }
        if (this.myUpdatingSelectionInLayoutEditor || this.myUpdatingSelectionFromLayoutEditor) {
            return;
        }
        this.myUpdatingSelectionInLayoutEditor = true;
        try {
            this.myDesignSurface.getSelectionModel().setSelection(selected);
            this.myDesignSurface.repaint();
        }
        finally {
            this.myUpdatingSelectionInLayoutEditor = false;
        }
    }

    private void selectSomething(@NotNull MotionSceneTag motionScene) {
        MTag[] sets;
        if (motionScene == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(7);
        }
        if ((sets = motionScene.getChildTags("ConstraintSet")).length == 0) {
            return;
        }
        this.mLastSelection = MotionEditorSelector.Type.CONSTRAINT_SET;
        this.myLastSelectedTags = new MTag[]{sets[0]};
    }

    private String getSetupError() {
        GoogleMavenArtifactId artifact = GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT;
        NlDependencyManager dep = NlDependencyManager.getInstance();
        if (dep == null) {
            return null;
        }
        if (this.myMotionLayout == null) {
            return null;
        }
        if (this.myMotionLayout.getModel() == null) {
            return null;
        }
        Version v = dep.getModuleDependencyVersion(artifact, this.myMotionLayout.getModel().getFacet());
        NlDependencyManager.getInstance().getModuleDependencyVersion(artifact, this.myMotionLayout.getModel().getFacet());
        String error = "Version ConstraintLayout library must be version 2.0.0 beta3 or later";
        if (v == null) {
            return null;
        }
        if (v.compareTo(Version.Companion.parse("2.0.0-beta03")) < 0) {
            return error;
        }
        return null;
    }

    private void selectOnDesignSurface(MTag[] tag2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (model2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(9);
        }
        if (this.myUpdatingSelectionInLayoutEditor || this.myUpdatingSelectionFromLayoutEditor) {
            return;
        }
        String[] ids = new String[selection.size()];
        int count = 0;
        for (NlComponent component2 : selection) {
            ids[count++] = Utils.stripID(component2.getId());
        }
        this.myUpdatingSelectionFromLayoutEditor = true;
        try {
            this.mMotionEditor.selectById(ids);
            this.fireSelectionChanged(selection);
        }
        finally {
            this.myUpdatingSelectionFromLayoutEditor = false;
        }
    }

    @Nullable
    MotionSceneTag.Root getMotionScene(NlComponent motionLayout) {
        VirtualFile dir;
        String ref = motionLayout.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (ref == null) {
            System.err.println("getAttribute(layoutDescription ) returned null");
            return null;
        }
        int index = ref.lastIndexOf("@xml/");
        if (index < 0) {
            System.err.println("layoutDescription  did not have \"@xml/\"");
            return null;
        }
        String fileName = ref.substring(index + 5);
        if (fileName.isEmpty()) {
            System.err.println("layoutDescription \"" + ref + "\"");
            return null;
        }
        AndroidFacet facet = motionLayout.getModel().getFacet();
        List resourcesXML = IdeResourcesUtil.getResourceSubdirs((ResourceFolderType)ResourceFolderType.XML, (Iterable)StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).getResourceDirs());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile2 = null;
        Iterator iterator = resourcesXML.iterator();
        while (iterator.hasNext() && (virtualFile2 = (dir = (VirtualFile)iterator.next()).findFileByRelativePath(fileName + ".xml")) == null) {
        }
        if (virtualFile2 == null) {
            System.err.println("virtualFile == null");
            return null;
        }
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, virtualFile2);
        return MotionSceneTag.parse(motionLayout, this.myProject, virtualFile2, xmlFile, this.mMotionEditor.myTrack);
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        MotionEditor motionEditor = this.mMotionEditor;
        if (motionEditor == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(10);
        }
        return motionEditor;
    }

    @Override
    @NotNull
    public JPanel createPanel(AccessoryPanel.Type type) {
        return new JPanel(){
            {
                this.setBackground(Color.RED);
            }
        };
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        if (type == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(12);
        }
        if (selection.isEmpty()) {
            this.mySelection = null;
            return;
        }
        this.mySelection = selection.get(0);
        this.myMotionLayout = MotionUtils.getMotionLayoutAncestor(this.mySelection);
        this.fireSelectionChanged(selection);
    }

    @Override
    public void deactivate() {
        this.mMotionEditor.stopAnimation();
        this.myMotionLayout = null;
        MotionLayoutComponentHelper.clearCache();
        AndroidFacet facet = this.myMotionLayoutNlComponent.getModel().getFacet();
        ResourceNotificationManager.getInstance((Project)this.myProject).removeListener(this.myResourceListener, facet, null, null);
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
        MotionLayoutComponentHelper.clearCache();
        this.myMotionHelper = MotionLayoutComponentHelper.create(this.myMotionLayoutNlComponent);
        if (this.mLastSelection == MotionEditorSelector.Type.LAYOUT) {
            this.myMotionHelper.setState(null);
            this.mSelectedStartConstraintId = null;
        } else if (this.mLastSelection == MotionEditorSelector.Type.CONSTRAINT_SET) {
            this.myMotionHelper.setState(this.mSelectedStartConstraintId);
        } else if (this.mSelectedStartConstraintId != null && this.mSelectedEndConstraintId == null) {
            this.myMotionHelper.setState(this.mSelectedStartConstraintId);
        } else if (this.mSelectedStartConstraintId != null && this.mSelectedEndConstraintId != null) {
            this.myMotionHelper.setTransition(this.mSelectedStartConstraintId, this.mSelectedEndConstraintId);
            this.mMotionEditor.stopAnimation();
        } else {
            this.myMotionHelper.setState(null);
            this.mSelectedStartConstraintId = null;
        }
    }

    @Override
    public void addListener(@NotNull AccessorySelectionListener listener2) {
        if (listener2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(13);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull AccessorySelectionListener listener2) {
        if (listener2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(14);
        }
        this.myListeners.remove(listener2);
    }

    @Override
    public void requestSelection() {
        this.fireSelectionChanged(Collections.singletonList(this.mySelection));
    }

    private void fireSelectionChanged(@NotNull List<NlComponent> components) {
        if (components == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(15);
        }
        boolean forLayout = this.mLastSelection == MotionEditorSelector.Type.LAYOUT || this.mLastSelection == MotionEditorSelector.Type.LAYOUT_VIEW;
        MotionEditorSelector.Type type = forLayout ? null : this.mLastSelection;
        MTag[] tags = forLayout ? null : this.myLastSelectedTags;
        List<NlComponent> selectedComponents = forLayout ? this.convertToLayoutSelection() : components;
        ArrayList<AccessorySelectionListener> copy = new ArrayList<AccessorySelectionListener>(this.myListeners);
        copy.forEach(listener2 -> listener2.selectionChanged(this, (Object)type, tags, selectedComponents));
    }

    private List<NlComponent> convertToLayoutSelection() {
        ArrayList<NlComponent> views = new ArrayList<NlComponent>();
        if (this.myLastSelectedTags != null) {
            for (MTag tag2 : this.myLastSelectedTags) {
                NlComponent component2;
                if (!(tag2 instanceof NlComponentTag) || (component2 = ((NlComponentTag)tag2).getComponent()) == null) continue;
                views.add(component2);
            }
        }
        if (views.isEmpty() && this.myMotionLayoutNlComponent != null) {
            views.add(this.myMotionLayoutNlComponent);
        }
        return views;
    }

    @Override
    public boolean showPopupMenuActions() {
        return false;
    }

    @Override
    public boolean handlesWriteForComponent(String id2) {
        boolean handlesWrite = this.getSelectedConstraintSet() != null;
        return handlesWrite;
    }

    @Override
    public String getSelectedConstraintSet() {
        return this.mSelectedStartConstraintId;
    }

    @Override
    @Nullable
    public XmlFile getTransitionFile(@NotNull NlComponent component2) {
        if (component2 == null) {
            MotionAccessoryPanel.$$$reportNull$$$0(16);
        }
        if (!(NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.MOTION_LAYOUT) || (component2 = component2.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.MOTION_LAYOUT))) {
            return null;
        }
        String file2 = component2.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (file2 == null) {
            return null;
        }
        int index = file2.lastIndexOf("@xml/");
        String fileName = file2.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        AndroidFacet facet = component2.getModel().getFacet();
        List resourcesXML = IdeResourcesUtil.getResourceSubdirs((ResourceFolderType)ResourceFolderType.XML, (Iterable)StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).getResourceDirs());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile directory = (VirtualFile)resourcesXML.get(0);
        VirtualFile virtualFile2 = directory.findFileByRelativePath(fileName + ".xml");
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)virtualFile2);
    }

    @Override
    @Nullable
    public XmlTag getConstraintSet(XmlFile file2, String constraintSetId) {
        XmlTag[] children = file2.getRootTag().findSubTags("ConstraintSet");
        for (int i = 0; i < children.length; ++i) {
            String childId;
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null || !(childId = Utils.stripID(attribute.getValue())).equalsIgnoreCase(constraintSetId)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    @Nullable
    public XmlTag getConstrainView(XmlTag constraintSet, String id2) {
        XmlTag[] children = constraintSet.getSubTags();
        for (int i = 0; i < children.length; ++i) {
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null) continue;
            String value2 = attribute.getValue();
            int index = value2.lastIndexOf("id/");
            if ((value2 = value2.substring(index + 3)) == null || !value2.equalsIgnoreCase(id2)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    @Nullable
    public List<XmlTag> getKeyframes(XmlFile file2, String componentId) {
        XmlTag[] children = file2.getRootTag().findSubTags("KeyFrames");
        ArrayList<XmlTag> found = new ArrayList<XmlTag>();
        for (int i = 0; i < children.length; ++i) {
            XmlTag[] keyframes = children[i].getSubTags();
            for (int j = 0; j < keyframes.length; ++j) {
                XmlTag keyframe = keyframes[j];
                XmlAttribute attribute = keyframe.getAttribute("motion:target");
                if (attribute == null) continue;
                String keyframeTarget = attribute.getValue();
                int index = keyframeTarget.indexOf(47);
                if (index != -1) {
                    keyframeTarget = keyframeTarget.substring(index + 1);
                }
                if (!componentId.equalsIgnoreCase(keyframeTarget)) continue;
                found.add(keyframe);
            }
        }
        return found;
    }

    public MotionSceneTag getMotionScene() {
        return this.myMotionScene;
    }

    private void startScreenRotating() {
        this.myStartDegree = Float.NaN;
        this.myEndDegree = Float.NaN;
        if (this.mLastSelection != MotionEditorSelector.Type.TRANSITION) {
            this.applyRotation();
            return;
        }
        MTag startConstraintSet = null;
        MTag endConstraintSet = null;
        if (this.myLastSelectedTags != null && this.myLastSelectedTags.length > 0) {
            startConstraintSet = this.mMotionEditor.getMeModel().findStartConstraintSet(this.myLastSelectedTags[0]);
            endConstraintSet = this.mMotionEditor.getMeModel().findEndConstraintSet(this.myLastSelectedTags[0]);
        }
        if (startConstraintSet != null && endConstraintSet != null) {
            String startScreenRotation = startConstraintSet.getAttributeValue("screenRotation");
            String endScreenRotation = endConstraintSet.getAttributeValue("screenRotation");
            if (startScreenRotation != null && NumberUtils.isParsable((String)startScreenRotation)) {
                this.myStartDegree = Float.parseFloat(startScreenRotation);
            }
            if (endScreenRotation != null && NumberUtils.isParsable((String)endScreenRotation)) {
                this.myEndDegree = Float.parseFloat(endScreenRotation);
            }
        }
        this.applyRotation();
    }

    private void applyRotation() {
        float rotationDegree = this.myStartDegree + this.mLastProgress * (this.myEndDegree - this.myStartDegree);
        this.myDesignSurface.setRotateSufaceDegree(rotationDegree);
    }

    private void stopScreenRotating() {
        this.myStartDegree = Float.NaN;
        this.myEndDegree = Float.NaN;
        this.myDesignSurface.setRotateSufaceDegree(Float.NaN);
    }

    private /* synthetic */ void lambda$applyMotionSceneValue$1() {
        this.myMotionLayoutTag.mComponent.setAttribute("http://schemas.android.com/tools", "applyMotionScene", "false");
    }

    private /* synthetic */ void lambda$applyMotionSceneValue$0() {
        this.myMotionLayoutTag.mComponent.setAttribute("http://schemas.android.com/tools", "applyMotionScene", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/editor/MotionAccessoryPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "motionScene";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/editor/MotionAccessoryPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutFileName";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectionInLayoutEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectSomething";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleSelectionChanged";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateAccessoryPanelWithSelection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireSelectionChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTransitionFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 10 -> new IllegalStateException(string2);
        };
    }
}

