/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;

public class MotionSceneUtils {
    private static boolean DEBUG = false;
    public static final String MOTION_LAYOUT_PROPERTIES = "motionLayoutProperties";
    public static final String MTAG_ACCESS = "MotionTagForMotionScene";

    public static MTag getMTag(NlComponent nlComponent) {
        return (MTag)nlComponent.getClientProperty(MTAG_ACCESS);
    }

    public static void setMTag(NlComponent nlComponent, MTag tag2) {
        nlComponent.putClientProperty(MTAG_ACCESS, tag2);
    }

    public static void putConstraintTag(NlComponent nl, MTag tag2) {
        nl.putClientProperty(MTAG_ACCESS, tag2);
    }

    public static MotionAttributes getAttributes(NlComponent nlComponent) {
        return (MotionAttributes)nlComponent.getClientProperty(MOTION_LAYOUT_PROPERTIES);
    }

    public static MTag.TagWriter getTagWriter(NlComponent nlComponent) {
        MotionAttributes m = (MotionAttributes)nlComponent.getClientProperty(MOTION_LAYOUT_PROPERTIES);
        MTag tag2 = MotionSceneUtils.getMTag(nlComponent);
        if (tag2 instanceof MTag.TagWriter) {
            return (MTag.TagWriter)tag2;
        }
        if (tag2 == null) {
            MTag parent = m.getConstraintSet();
            MTag.TagWriter writer = parent.getChildTagWriter("Constraint");
            m.fillTagWriter(writer);
            writer.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + nlComponent.getId());
            MotionSceneUtils.setMTag(nlComponent, writer);
            return writer;
        }
        if ("Constraint".equals(tag2.getTagName())) {
            MTag.TagWriter tw = tag2.getTagWriter();
            MotionSceneUtils.setMTag(nlComponent, tw);
            tw.addCommitListener(newTag -> MotionSceneUtils.setMTag(nlComponent, newTag));
            return tw;
        }
        if ("ConstraintSet".equals(tag2.getTagName())) {
            // empty if block
        }
        return null;
    }

    public static MTag.TagWriter getTagWriter(MTag tag2) {
        return tag2.getTagWriter();
    }

    public static MTag.TagWriter getChildTagWriter(MTag tag2, String newChildTag) {
        return tag2.getChildTagWriter(newChildTag);
    }

    public static boolean isUnderConstraintSet(NlComponent nlComponent) {
        MotionAttributes attributes = MotionSceneUtils.getAttributes(nlComponent);
        return attributes != null;
    }

    public static void deleteRelatedConstraintSets(MTag motionScene, String toRemove) {
        MTag[] sceneTags;
        if (toRemove == null) {
            return;
        }
        toRemove = Utils.stripID(toRemove);
        block8: for (MTag tag2 : sceneTags = motionScene.getChildTags()) {
            String tagName;
            switch (tagName = tag2.getTagName()) {
                case "ConstraintSet": {
                    MTag[] constraint;
                    MTag[] mTagArray = constraint = tag2.getChildTags();
                    int n = mTagArray.length;
                    for (int i = 0; i < n; ++i) {
                        MTag mTag = mTagArray[i];
                        String id2 = Utils.stripID(mTag.getAttributeValue("id"));
                        if (!toRemove.equals(id2)) continue;
                        mTag.getTagWriter().deleteTag().commit("delete");
                    }
                    continue block8;
                }
                case "Transition": {
                    for (MTag keySetTags : tag2.getChildTags("KeyFrameSet")) {
                        for (MTag keyTags : keySetTags.getChildTags()) {
                            String id3 = keyTags.getAttributeValue("motionTarget");
                            if (!id3.startsWith("@") || !toRemove.equals(Utils.stripID(id3))) continue;
                            keyTags.getTagWriter().deleteTag().commit("delete");
                        }
                    }
                    continue block8;
                }
            }
        }
    }
}

