/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.adapters;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;

public class MEActionButton
extends JButton {
    private boolean myMouseDown;
    private boolean myRollover;
    private boolean myPopupIsShowing;
    private JBDimension myMinimumButtonSize;

    public MEActionButton(Icon icon2, Icon disable_icon, String tooltip) {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                MEActionButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent event) {
                MEActionButton.this.repaint();
            }
        });
        this.setIcon(icon2);
        this.setDisabledIcon(disable_icon);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setToolTipText(tooltip);
        this.setBorder((Border)JBUI.Borders.empty());
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicButtonUI());
        this.myMinimumButtonSize = JBDimension.create((Dimension)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myMinimumButtonSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isEnabled()) {
            super.paintComponent(g);
            return;
        }
        if (!StartupUiUtil.isUnderDarcula()) {
            this.paintBackground(g);
        }
        super.paintComponent(g);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        IdeMouseEventDispatcher.requestFocusInNonFocusedWindow((MouseEvent)event);
        super.processMouseEvent(event);
        if (event.isConsumed()) {
            return;
        }
        switch (event.getID()) {
            case 501: {
                this.myMouseDown = true;
                break;
            }
            case 502: {
                this.myMouseDown = false;
                break;
            }
            case 504: {
                this.myRollover = true;
                break;
            }
            case 505: {
                this.myRollover = false;
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    public void setPopupIsShowing(boolean isPopupShowing) {
        this.myPopupIsShowing = isPopupShowing;
        this.repaint();
    }

    private void paintBackground(Graphics g) {
        int state = this.computeState();
        if (state == 0 && !this.isBackgroundSet()) {
            return;
        }
        Rectangle rect = new Rectangle(this.getSize());
        JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
        ActionButtonLook.SYSTEM_LOOK.paintLookBackground(g, rect, this.getBackgroundColor(state));
    }

    private int computeState() {
        if (this.myPopupIsShowing) {
            return 2;
        }
        if (this.myMouseDown) {
            return -1;
        }
        if (this.myRollover && this.isEnabled()) {
            return 1;
        }
        if (this.isFocusOwner()) {
            return 2;
        }
        return 0;
    }

    private Color getBackgroundColor(int state) {
        switch (state) {
            case 0: {
                return this.getBackground();
            }
            case -1: {
                return JBUI.CurrentTheme.ActionButton.pressedBackground();
            }
        }
        return JBUI.CurrentTheme.ActionButton.hoverBackground();
    }
}

