/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class CreateOnClick
extends BaseCreatePanel {
    static String TITLE = "Create OnClick";
    JComboBox<String> mTransitions = MEUI.makeComboBox(new String[0]);
    MTag[] mTransitionTags;
    JComboBox<String> viewIds = MEUI.makeComboBox(new String[]{"layout"});

    public CreateOnClick() {
        this.icon = MEIcons.CREATE_ON_CLICK;
        this.viewIds.setEditable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        CreateOnClick.grid(gbc, 0, y++, 1, 1);
        gbc.weighty = 0.0;
        gbc.ipadx = MEUI.scale(60);
        gbc.insets = MEUI.dialogTitleInsets();
        gbc.fill = 2;
        this.add((Component)new JLabel("CREATE ONCLICK"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("In Transition"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.mTransitions, gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("View To Click"), gbc);
        CreateOnClick.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.viewIds, gbc);
        gbc.fill = 2;
        gbc.weighty = 1.0;
        CreateOnClick.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateOnClick.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        this.mTransitionTags = model2.motionScene.getChildTags("Transition");
        this.mTransitions.removeAllItems();
        for (int i = 0; i < this.mTransitionTags.length; ++i) {
            String id2 = Utils.stripID(this.mTransitionTags[i].getAttributeValue("id"));
            String start = Utils.stripID(this.mTransitionTags[i].getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(this.mTransitionTags[i].getAttributeValue("constraintSetEnd"));
            this.mTransitions.addItem(Utils.formatTransition(id2, start, end));
        }
        MTag tag2 = this.mMotionEditor.getSelectedTag();
        if (tag2 != null && tag2.getTagName().equals("Transition")) {
            for (int i = 0; i < this.mTransitionTags.length; ++i) {
                if (this.mTransitionTags[i] != tag2) continue;
                this.mTransitions.setSelectedIndex(i);
            }
        }
        this.viewIds.removeAllItems();
        this.viewIds.addItem("(Base Layout)");
        if (model2.layout != null) {
            ArrayList<MTag> children = model2.layout.getChildren();
            for (MTag child : children) {
                String id3 = child.getAttributeValue("id");
                if (id3 == null) continue;
                this.viewIds.addItem(Utils.stripID(id3));
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "Click Handler";
    }

    @Override
    public MTag create() {
        MTag transition2 = this.mTransitionTags[this.mTransitions.getSelectedIndex()];
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag.TagWriter writer = transition2.getChildTagWriter("OnClick");
        if (this.viewIds.getSelectedIndex() != 0) {
            String str = (String)this.viewIds.getSelectedItem();
            writer.setAttribute("motion", "targetId", this.addIdPrefix(str));
        }
        MTag ret = writer.commit("Create OnClick");
        Track.createOnClick(this.mMotionEditor.myTrack);
        this.mMotionEditor.setMTag(model2);
        super.create();
        return ret;
    }
}

