/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRow;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRowData;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimelineStructure;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.MonotoneSpline;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.graph.Oscillator;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class GraphRender {
    private static final boolean DEBUG = false;
    private Cycle mCycle = null;
    private Attribute[] mAttribute = null;
    private String[] mStartEndString = new String[2];
    private boolean mShowNewGraph = (Boolean)StudioFlags.NELE_MOTION_AREA_GRAPH.get();
    static String[] ourWaveTypes = new String[]{"sin", "square", "triangle", "sawtooth", "reverseSawtooth", "cos", "bounce"};
    static HashMap<String, Integer> ourWaveTypeMap = new HashMap();

    public boolean setUp(MeModel model2, TimeLineRowData row) {
        this.mAttribute = null;
        this.mCycle = null;
        switch (row.mType) {
            case "Att": {
                return this.buildAttributeGraph(model2, row);
            }
            case "Cyc": {
                return this.buildCycleGraph(row);
            }
            case "Pos": {
                break;
            }
            case "TCyc": {
                break;
            }
        }
        return false;
    }

    public String getValue(MTag kf, String keyProp) {
        MTag[] tag2 = kf.getChildTags();
        if (tag2 != null && tag2.length > 0) {
            String value2 = tag2[0].getAttributeValue("customFloatValue");
            return value2;
        }
        return kf.getAttributeValue(keyProp);
    }

    private boolean buildCycleGraph(TimeLineRowData row) {
        MTag[] keyFrames = row.mKeyFrames.toArray(new MTag[0]);
        if (row.mKeyProp.contains(",")) {
            return false;
        }
        Arrays.sort(keyFrames, new Comparator<MTag>(){

            @Override
            public int compare(MTag t1, MTag t2) {
                int p1 = Integer.parseInt(t1.getAttributeValue("framePosition"));
                int p2 = Integer.parseInt(t2.getAttributeValue("framePosition"));
                return Integer.compare(p1, p2);
            }
        });
        double[] pos = new double[keyFrames.length];
        double[] period = new double[keyFrames.length];
        double[] amp = new double[keyFrames.length];
        double[] offset2 = new double[keyFrames.length];
        int curveType = 0;
        for (int i = 0; i < pos.length; ++i) {
            MTag kf = keyFrames[i];
            pos[i] = (double)Integer.parseInt(kf.getAttributeValue("framePosition")) / 100.0;
            offset2[i] = GraphRender.parse(0.0, kf.getAttributeValue("waveOffset"));
            period[i] = GraphRender.parse(0.0, kf.getAttributeValue("wavePeriod"));
            amp[i] = GraphRender.parse(0.0, this.getValue(kf, row.mKeyProp));
            String str = kf.getAttributeValue("waveShape");
            if (str == null) {
                str = "sin";
            }
            if (!ourWaveTypeMap.containsKey(str)) continue;
            curveType = Math.max(curveType, ourWaveTypeMap.get(str));
        }
        this.mCycle = new Cycle();
        this.mCycle.setCycle(pos, period, amp, offset2, curveType, row);
        this.mCycle.fixRange(row.mKeyProp);
        return true;
    }

    static double parse(double def, String str) {
        if (str == null) {
            return def;
        }
        if (str.endsWith("dp")) {
            str = str.substring(0, str.length() - 2);
        }
        return Double.parseDouble(str);
    }

    private boolean buildAttributeGraph(MeModel model2, TimeLineRowData row) {
        String[] attrs = new String[]{row.mKeyProp};
        if (row.mKeyProp.contains(",")) {
            attrs = attrs[0].split(",");
        }
        this.mAttribute = new Attribute[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            String attr2 = attrs[i];
            model2.findStartAndEndValues(model2.layout, attr2, row.mKeyFrames.get(0), this.mStartEndString);
            if (this.mStartEndString[0] == null || this.mStartEndString[1] == null) {
                return false;
            }
            double startValue = GraphRender.parse(this.mStartEndString[0]);
            double endValue = GraphRender.parse(this.mStartEndString[0]);
            this.mAttribute[i] = new Attribute(row, attr2, startValue, endValue);
        }
        return true;
    }

    static double parse(String str) {
        if (str.endsWith("dp")) {
            str = str.substring(0, str.length() - 2);
        }
        return Double.parseDouble(str);
    }

    public void draw(Graphics g, TimelineStructure mTimelineStructure, int x, int y, int w, int h) {
        if (this.mAttribute == null && this.mCycle == null) {
            return;
        }
        int gx = x + mTimelineStructure.mTimeLineInsetLeft;
        int gw = w - mTimelineStructure.mTimeLineInsetLeft - mTimelineStructure.mTimeLineInsetRight;
        Color c = g.getColor();
        g.setColor(MEUI.Graph.ourG_Background);
        g.fillRect(x + 1, y, w - 1, h);
        g.setColor(MEUI.ourBorder);
        g.drawRect(x, y, w, h - 1);
        g.setColor(MEUI.Graph.ourG_line);
        if (this.mShowNewGraph) {
            g.setColor(MEUI.myGridColor);
            TimeLineRow.drawTicks(g, mTimelineStructure, h, y);
        }
        if (this.mCycle != null) {
            if (this.mShowNewGraph) {
                this.mCycle.plotAreaGraph(g, gx, y, gw, h);
            } else {
                this.mCycle.plot(g, gx, y, gw, h);
            }
        }
        if (this.mAttribute != null) {
            for (int i = 0; i < this.mAttribute.length; ++i) {
                Attribute attribute = this.mAttribute[i];
                if (this.mShowNewGraph) {
                    attribute.plotAreaGraph(g, gx, y, gw, h);
                    continue;
                }
                attribute.plot(g, gx, y, gw, h);
            }
        }
        g.setColor(c);
    }

    static double lockAttributeMin(String attr2, double current) {
        switch (attr2) {
            case "alpha": {
                return 0.0;
            }
            case "scaleX": {
                return 0.0;
            }
            case "scaleY": {
                return 0.0;
            }
            case "elevation": {
                return 0.0;
            }
        }
        return current;
    }

    static double lockAttributeMax(String attr2, double current) {
        switch (attr2) {
            case "alpha": {
                return 1.0;
            }
        }
        return current;
    }

    static float lockAttributeMax(String attr2, float current) {
        switch (attr2) {
            case "alpha": {
                return 1.0f;
            }
        }
        return current;
    }

    static float lockAttributeMin(String attr2, float current) {
        switch (attr2) {
            case "alpha": {
                return 0.0f;
            }
            case "scaleX": {
                return 0.0f;
            }
            case "scaleY": {
                return 0.0f;
            }
            case "elevation": {
                return 0.0f;
            }
        }
        return current;
    }

    static {
        for (int i = 0; i < ourWaveTypes.length; ++i) {
            ourWaveTypeMap.put(ourWaveTypes[i], i);
        }
    }

    static class Cycle {
        MonotoneSpline mMonotoneSpline;
        Oscillator mOscillator;
        float[] xpos = new float[400];
        double[] ypos = new double[this.xpos.length];
        float[] yMax = new float[this.xpos.length];
        float[] yMin = new float[this.xpos.length];
        float mMaxY;
        float mMinY;
        int numPoints = (Boolean)StudioFlags.NELE_MOTION_AREA_GRAPH.get() != false ? this.xpos.length + 2 : this.xpos.length;
        int[] xPoints = new int[this.numPoints];
        int[] yPoints = new int[this.numPoints];
        int colorIndex = 0;
        String attr = "";
        double[] offsetY = new double[this.xpos.length];
        int[] offsetYPoints = new int[this.xpos.length];

        Cycle() {
        }

        void setCycle(double[] pos, double[] period, double[] amplitude, double[] offset2, int curveType, TimeLineRowData row) {
            int i;
            if (pos.length == 1) {
                pos = new double[]{0.0, pos[0], 1.0};
                period = new double[]{period[0], period[0], period[0]};
                amplitude = new double[]{amplitude[0], amplitude[0], amplitude[0]};
                offset2 = new double[]{offset2[0], offset2[0], offset2[0]};
            }
            double[] t = new double[pos.length];
            double[][] v = new double[pos.length][2];
            for (int i2 = 0; i2 < pos.length; ++i2) {
                t[i2] = pos[i2];
                v[i2][0] = amplitude[i2];
                v[i2][1] = offset2[i2];
            }
            MonotoneSpline ms = new MonotoneSpline(t, v);
            Oscillator osc = new Oscillator();
            osc.setType(curveType);
            for (i = 0; i < pos.length; ++i) {
                osc.addPoint(pos[i], (float)period[i]);
            }
            osc.normalize();
            this.mMonotoneSpline = ms;
            this.mOscillator = osc;
            this.mMaxY = -3.4028235E38f;
            this.mMinY = Float.MAX_VALUE;
            this.colorIndex = row.mKeyPropIndex;
            this.attr = row.mKeyProp;
            for (i = 0; i < this.xpos.length; ++i) {
                this.xpos[i] = (float)i / ((float)this.xpos.length - 1.0f);
                double amp = this.mMonotoneSpline.getPos((double)this.xpos[i], 0);
                double off = this.mMonotoneSpline.getPos((double)this.xpos[i], 1);
                try {
                    this.ypos[i] = this.mOscillator.getValue(this.xpos[i]) * amp + off;
                    this.offsetY[i] = off;
                }
                catch (Exception e) {
                    this.ypos[i] = Math.random();
                }
                this.yMax[i] = (float)(amp + off);
                this.yMin[i] = (float)(-amp + off);
                this.mMaxY = Math.max(this.mMaxY, (float)this.ypos[i]);
                this.mMaxY = Math.max(this.mMaxY, this.yMax[i]);
                this.mMinY = Math.min(this.mMinY, this.yMin[i]);
            }
        }

        void fixRange(String attr2) {
            this.mMinY = GraphRender.lockAttributeMin(attr2, this.mMinY);
            this.mMaxY = GraphRender.lockAttributeMax(attr2, this.mMaxY);
            this.mMaxY = (float)((double)this.mMaxY + 0.06 * (double)(this.mMaxY - this.mMinY));
            this.mMinY = (float)((double)this.mMinY - 0.06 * (double)(this.mMaxY - this.mMinY));
        }

        void plot(Graphics g, int x, int y, int w, int h) {
            g.setColor(MEUI.Graph.ourG_line);
            for (int i = 0; i < this.xpos.length; ++i) {
                int xp = (int)((float)w * this.xpos[i] + (float)x);
                int yp = y + (int)((double)h - (double)h * (this.ypos[i] - (double)this.mMinY) / (double)(this.mMaxY - this.mMinY));
                this.xPoints[i] = xp;
                this.yPoints[i] = yp;
            }
            g.drawPolyline(this.xPoints, this.yPoints, this.xPoints.length);
        }

        void plotAreaGraph(Graphics g, int x, int y, int w, int h) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.xPoints[0] = x;
            this.yPoints[0] = y + (int)((float)h - (float)h * (0.0f - this.mMinY) / (this.mMaxY - this.mMinY));
            int count = 1;
            for (int i = 0; i < this.xpos.length; ++i) {
                int offsetYP;
                int xp = (int)((float)w * this.xpos[i] + (float)x);
                int yp = y + (int)((double)h - (double)h * (this.ypos[i] - (double)this.mMinY) / (double)(this.mMaxY - this.mMinY));
                this.xPoints[count] = xp;
                this.yPoints[count] = yp;
                ++count;
                this.offsetYPoints[i] = offsetYP = y + (int)((double)h - (double)h * (this.offsetY[i] - (double)this.mMinY) / (double)(this.mMaxY - this.mMinY));
            }
            this.xPoints[count] = x + w;
            this.yPoints[count] = this.yPoints[0];
            g.setColor(MEUI.myGridColor);
            g.drawPolyline(Arrays.copyOfRange(this.xPoints, 1, this.xPoints.length - 1), Arrays.copyOfRange(this.yPoints, 1, this.yPoints.length - 1), count - 1);
            if (this.attr.equals("scaleX") || this.attr.equals("scaleY")) {
                int yTop = y + (int)((float)h - (float)h * (1.0f - this.mMinY) / (this.mMaxY - this.mMinY));
                g.drawLine(x, yTop, x + w, yTop);
            }
            g.setColor((Color)MEUI.graphColors[this.colorIndex % MEUI.graphColors.length]);
            g.fillPolygon(this.xPoints, this.yPoints, count + 1);
            BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            ((Graphics2D)g).setStroke(dashed);
            g.setColor(MEUI.ourDashedLineColor);
            g.drawPolyline(Arrays.copyOfRange(this.xPoints, 1, this.xPoints.length - 1), this.offsetYPoints, count - 1);
        }

        float getComputedValue(float v) {
            if (this.mMonotoneSpline == null) {
                return 0.0f;
            }
            double amp = this.mMonotoneSpline.getPos((double)v, 0);
            double off = this.mMonotoneSpline.getPos((double)v, 1);
            return (float)(this.mOscillator.getValue(v) * amp + off);
        }
    }

    static class Attribute {
        String mType;
        MonotoneSpline spline;
        int[] xPoints = new int[1000];
        int[] yPoints = new int[1000];
        double mMin;
        double mMax;
        int colorIndex = 0;

        public Attribute(TimeLineRowData row, String attr2, double startValue, double endValue) {
            this.mType = attr2;
            this.colorIndex = row.mKeyPropIndex;
            this.setup(row, attr2, startValue, endValue);
        }

        public boolean setup(TimeLineRowData row, String attr2, double startValue, double endValue) {
            MTag[] keyFrames = row.mKeyFrames.toArray(new MTag[0]);
            Arrays.sort(keyFrames, new Comparator<MTag>(){

                @Override
                public int compare(MTag t1, MTag t2) {
                    int p1 = Integer.parseInt(t1.getAttributeValue("framePosition"));
                    int p2 = Integer.parseInt(t2.getAttributeValue("framePosition"));
                    return Integer.compare(p1, p2);
                }
            });
            if (attr2.contains(",")) {
                return false;
            }
            double[] pos = new double[keyFrames.length + 2];
            int[] int_pos = new int[pos.length];
            double[][] values2 = new double[pos.length][1];
            double min = Math.min(startValue, endValue);
            double max = Math.max(startValue, endValue);
            pos[0] = 0.0;
            pos[pos.length - 1] = 1.0;
            values2[0][0] = startValue;
            values2[pos.length - 1][0] = endValue;
            for (int i = 0; i < keyFrames.length; ++i) {
                MTag kf = row.mKeyFrames.get(i);
                int x = Integer.parseInt(kf.getAttributeValue("framePosition"));
                double y = GraphRender.parse(kf.getAttributeValue(attr2));
                int_pos[i + 1] = x;
                pos[i + 1] = (double)x / 100.0;
                values2[i + 1][0] = y;
                if (y > max) {
                    max = y;
                }
                if (!(y < min)) continue;
                min = y;
            }
            this.mMin = min;
            this.mMax = max;
            this.mMin = GraphRender.lockAttributeMin(attr2, this.mMin);
            this.mMax = GraphRender.lockAttributeMax(attr2, this.mMax);
            this.mMin -= 0.06 * (this.mMax - this.mMin);
            this.mMax += 0.06 * (this.mMax - this.mMin);
            this.spline = new MonotoneSpline(pos, values2);
            return true;
        }

        public void plot(Graphics g, int x, int y, int w, int h) {
            if (this.spline != null) {
                double steps = 1.0 / (double)w;
                int count = 0;
                for (double i = 0.0; i <= 1.0; i += steps) {
                    double yp = this.spline.getPos(i, 0);
                    this.xPoints[count] = (int)((double)x + i * (double)w);
                    this.yPoints[count] = (int)((double)(y + h) - (yp - this.mMin) * (double)h / (this.mMax - this.mMin));
                    ++count;
                }
                g.drawPolyline(this.xPoints, this.yPoints, count);
            }
        }

        public void plotAreaGraph(Graphics g, int x, int y, int w, int h) {
            if (this.spline != null) {
                double steps = 1.0 / (double)w;
                this.xPoints[0] = x;
                this.yPoints[0] = y + h;
                int count = 1;
                for (double i = steps; i <= 1.0; i += steps) {
                    double yp = this.spline.getPos(i, 0);
                    this.xPoints[count] = (int)((double)x + i * (double)w);
                    this.yPoints[count] = (int)((double)(y + h) - (yp - this.mMin) * (double)h / (this.mMax - this.mMin));
                    ++count;
                }
                this.xPoints[count] = x + w;
                this.yPoints[count] = this.yPoints[0];
                g.setColor((Color)MEUI.graphColors[this.colorIndex % MEUI.graphColors.length]);
                g.fillPolygon(this.xPoints, this.yPoints, count + 1);
            }
        }
    }
}

