/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionLayoutAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.StringMTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRow;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineRowData;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineTopLeft;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimeLineTopPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimelineStructure;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LayerUI;

public class TimeLinePanel
extends JPanel {
    private static int PLAY_TIMEOUT = 3600000;
    private static int MS_PER_FRAME = 15;
    private static float TIMELINE_MIN = 0.0f;
    private static float TIMELINE_MAX = 100.0f;
    private static float[] ourSpeedsMultipliers = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 4.0f};
    MotionEditorSelector mMotionEditorSelector;
    private TimelineStructure mTimelineStructure = new TimelineStructure();
    private TimeLineTopPanel myTimeLineTopPanel = new TimeLineTopPanel(this.mTimelineStructure);
    private MTag mSelectedKeyFrame;
    private boolean mMouseDown = false;
    private METimeLine mTimeLine = new METimeLine();
    private JScrollPane myScrollPane = new MEScrollPane(this.mTimeLine);
    private TimeLineTopLeft mTimeLineTopLeft = new TimeLineTopLeft();
    private MeModel mMeModel;
    private MTag mTransitionTag;
    private float mMotionProgress;
    private Timer myTimer;
    private Timer myPlayLimiter;
    private int myYoyo = 0;
    private int mDuration = 1000;
    private float myProgressPerMillisecond = 1.0f / (float)this.mDuration;
    private long last_time;
    private int mCurrentSpeed = 2;
    private boolean mIsPlaying = false;
    private ArrayList<MotionEditorSelector.TimeLineListener> mTimeLineListeners = new ArrayList();
    private int mDirection = 1;
    int[] myXPoints = new int[5];
    int[] myYPoints = new int[5];
    private MTagActionListener mListener;
    Timer myMouseDownTimer;
    JPopupMenu myPlaybackSpeedPopupMenu = new JPopupMenu();

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mTimeLineTopLeft != null) {
            this.mTimeLineTopLeft.updateUI();
        }
        if (this.mTimeLine != null) {
            this.mTimeLine.updateUI();
        }
    }

    public TimeLinePanel() {
        super(new BorderLayout());
        for (int i = 0; i < ourSpeedsMultipliers.length; ++i) {
            this.myPlaybackSpeedPopupMenu.add(ourSpeedsMultipliers[i] + "x").addActionListener(this.createPlaybackSpeedPopupMenuActionListener(i));
        }
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.myTimeLineTopPanel, "Center");
        top.add((Component)this.mTimeLineTopLeft, "West");
        this.myScrollPane.setColumnHeaderView(top);
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        final int flags = 0;
        this.mTimeLine.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getExtendedKeyCode();
                switch (code) {
                    case 86: {
                        if (!e.isControlDown()) break;
                    }
                    case 65487: {
                        TimeLinePanel.this.paste();
                        break;
                    }
                    case 67: {
                        if (!e.isControlDown()) break;
                    }
                    case 65485: {
                        if (!e.isControlDown() || TimeLinePanel.this.mSelectedKeyFrame == null) break;
                        MEUI.copy(TimeLinePanel.this.mSelectedKeyFrame);
                        break;
                    }
                    case 88: {
                        if (!e.isControlDown()) break;
                    }
                    case 65489: {
                        if (!e.isControlDown() || TimeLinePanel.this.mSelectedKeyFrame == null) break;
                        MEUI.cut(TimeLinePanel.this.mSelectedKeyFrame);
                        break;
                    }
                    case 38: {
                        int index = TimeLinePanel.this.mTimeLine.getSelectedIndex() - 1;
                        if (index < 0) {
                            index = TimeLinePanel.this.mTimeLine.getComponentCount() - 2;
                        }
                        TimeLinePanel.this.mSelectedKeyFrame = null;
                        TimeLinePanel.this.mTimeLine.setSelectedIndex(index);
                        TimeLinePanel.this.groupSelected();
                        break;
                    }
                    case 40: {
                        int index = TimeLinePanel.this.mTimeLine.getSelectedIndex() + 1;
                        if (index > TimeLinePanel.this.mTimeLine.getComponentCount() - 2) {
                            index = 0;
                        }
                        TimeLinePanel.this.mSelectedKeyFrame = null;
                        TimeLinePanel.this.mTimeLine.setSelectedIndex(index);
                        TimeLinePanel.this.groupSelected();
                        break;
                    }
                    case 8: 
                    case 127: {
                        if (TimeLinePanel.this.mListener == null || TimeLinePanel.this.mSelectedKeyFrame == null) break;
                        TimeLinePanel.this.mListener.delete(new MTag[]{TimeLinePanel.this.mSelectedKeyFrame}, 0);
                        break;
                    }
                    case 37: {
                        TimeLineRowData rowData = TimeLinePanel.this.mTimeLine.getSelectedValue();
                        int numOfKeyFrames = rowData.mKeyFrames.size();
                        int indexInRow = -1;
                        for (int i = 0; i < numOfKeyFrames; ++i) {
                            if (!rowData.mKeyFrames.get(i).equals(TimeLinePanel.this.mSelectedKeyFrame)) continue;
                            indexInRow = i;
                            break;
                        }
                        int selIndex = (indexInRow - 1 + numOfKeyFrames) % numOfKeyFrames;
                        TimeLinePanel.this.mSelectedKeyFrame = rowData.mKeyFrames.get(selIndex);
                        TimeLinePanel.this.mTimeLine.getTimeLineRow(TimeLinePanel.this.mTimeLine.getSelectedIndex()).setSelectedKeyFrame(TimeLinePanel.this.mSelectedKeyFrame);
                        Track.timelineTableSelect(TimeLinePanel.this.mMeModel.myTrack);
                        TimeLinePanel.this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.KEY_FRAME, new MTag[]{TimeLinePanel.this.mSelectedKeyFrame}, flags);
                        if (TimeLinePanel.this.mListener == null || TimeLinePanel.this.mSelectedKeyFrame == null) break;
                        TimeLinePanel.this.mListener.select(TimeLinePanel.this.mSelectedKeyFrame, 0);
                        break;
                    }
                    case 39: {
                        TimeLineRowData rowData = TimeLinePanel.this.mTimeLine.getSelectedValue();
                        int numOfKeyFrames = rowData.mKeyFrames.size();
                        int indexInRow = -1;
                        for (int i = 0; i < numOfKeyFrames; ++i) {
                            if (!rowData.mKeyFrames.get(i).equals(TimeLinePanel.this.mSelectedKeyFrame)) continue;
                            indexInRow = i;
                            break;
                        }
                        int selIndex = (indexInRow + 1) % numOfKeyFrames;
                        TimeLinePanel.this.mSelectedKeyFrame = rowData.mKeyFrames.get(selIndex);
                        TimeLinePanel.this.mTimeLine.getTimeLineRow(TimeLinePanel.this.mTimeLine.getSelectedIndex()).setSelectedKeyFrame(TimeLinePanel.this.mSelectedKeyFrame);
                        Track.timelineTableSelect(TimeLinePanel.this.mMeModel.myTrack);
                        TimeLinePanel.this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.KEY_FRAME, new MTag[]{TimeLinePanel.this.mSelectedKeyFrame}, flags);
                        if (TimeLinePanel.this.mListener == null || TimeLinePanel.this.mSelectedKeyFrame == null) break;
                        TimeLinePanel.this.mListener.select(TimeLinePanel.this.mSelectedKeyFrame, 0);
                    }
                }
            }
        });
        this.mTimeLine.setFocusable(true);
        this.mTimeLine.setRequestFocusEnabled(true);
        this.mTimeLineTopLeft.addControlsListener((e, mode) -> this.performCommand(e, mode));
        JLayer<JComponent> jlayer = new JLayer<JComponent>(this.myScrollPane, new LayerUI<JComponent>(){

            @Override
            public void paint(Graphics g, JComponent c) {
                super.paint(g, c);
                TimeLinePanel.this.paintCursor(g, c);
            }

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                JLayer jlayer = (JLayer)c;
                jlayer.setLayerEventMask(48L);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e, JLayer l) {
                TimeLinePanel.this.processMouseDrag(e);
            }

            @Override
            protected void processMouseEvent(MouseEvent e, JLayer l) {
                TimeLinePanel.this.processMouseDrag(e);
            }
        });
        this.add(jlayer);
        this.mTimelineStructure.addWidthChangedListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimeLinePanel.this.mTimeLine.repaint();
            }
        });
        this.mTimeLine.setBackground(MEUI.ourAvgBackground);
        this.myTimeLineTopPanel.setRange(TIMELINE_MIN, TIMELINE_MAX);
        this.mTimeLine.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.groupSelected();
            }
        });
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String buff = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringMTag pastedTag = StringMTag.parse(buff);
            HashMap<String, MTag.Attribute> attr2 = pastedTag.getAttrList();
            if (this.mSelectedKeyFrame == null) {
                TimeLineRowData rowData = this.mTimeLine.getSelectedValue();
                if (rowData.mKeyFrames.isEmpty()) {
                    return;
                }
                this.mSelectedKeyFrame = rowData.mKeyFrames.get(0);
            }
            MTag keyFrameSet = this.mSelectedKeyFrame.getParent();
            MTag.TagWriter writer = keyFrameSet.getChildTagWriter(pastedTag.getTagName());
            for (String s : attr2.keySet()) {
                MTag.Attribute a = attr2.get(s);
                if (a == null || a.mAttribute.equals("framePosition")) {
                    writer.setAttribute(a.mNamespace, a.mAttribute, Integer.toString((int)((double)(this.mMotionProgress * 100.0f) + 0.5)));
                    continue;
                }
                writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
            }
            StringMTag[] children = pastedTag.getChildTags();
            for (int i = 0; i < children.length; ++i) {
                StringMTag child = children[i];
                MTag.TagWriter cw = writer.getChildTagWriter(child.getTagName());
                HashMap<String, MTag.Attribute> cwAttrMap = child.getAttrList();
                for (String cwAttrStr : cwAttrMap.keySet()) {
                    MTag.Attribute cwAttr = cwAttrMap.get(cwAttrStr);
                    cw.setAttribute(cwAttr.mNamespace, cwAttr.mAttribute, cwAttr.mValue);
                }
            }
            this.mSelectedKeyFrame = writer.commit("paste");
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setActionListener(MTagActionListener l) {
        this.mListener = l;
    }

    public void stopAnimation() {
        this.performCommand(TimeLineTopLeft.TimelineCommands.PAUSE, 0);
        this.resetMotionProgress();
    }

    private static String buildKey(MTag keyFrame) {
        String target = keyFrame.getAttributeValue("motionTarget");
        Object targetKey = target;
        targetKey = target != null && target.startsWith("@") ? "Id:" + Utils.stripID(target) : "Tag:" + target;
        String[] name = keyFrame.getTagName();
        targetKey = (String)targetKey + (String)name;
        String[] keys = new String[]{};
        switch (name) {
            case "KeyPosition": {
                keys = MotionLayoutAttrs.KeyPositionKey;
                break;
            }
            case "KeyAttribute": {
                keys = MotionLayoutAttrs.KeyAttributesKey;
                break;
            }
            case "KeyCycle": {
                keys = MotionLayoutAttrs.KeyCycleKey;
                break;
            }
            case "KeyTimeCycle": {
                keys = MotionLayoutAttrs.KeyTimeCycleKey;
                break;
            }
            case "KeyTrigger": {
                keys = MotionLayoutAttrs.KeyTriggerKey;
            }
        }
        for (String key : keys) {
            targetKey = (String)targetKey + TimeLinePanel.get(keyFrame, key);
        }
        return targetKey;
    }

    private static String get(MTag tag2, String attr2) {
        String s = tag2.getAttributeValue(attr2);
        return s == null ? "" : attr2;
    }

    public void clearSelection() {
        this.mSelectedKeyFrame = null;
        int n = this.mTimeLine.getComponentCount();
        if (n == 0 || this.mTimeLine.mSelectedIndex >= n) {
            return;
        }
        Component component2 = this.mTimeLine.getComponent(this.mTimeLine.mSelectedIndex);
        if (component2 instanceof TimeLineRow) {
            TimeLineRow child = (TimeLineRow)component2;
            child.setSelected(true);
            this.repaint();
        }
    }

    public void addTimeLineListener(MotionEditorSelector.TimeLineListener timeLineListener) {
        this.mTimeLineListeners.add(timeLineListener);
    }

    public void notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd cmd, Float value2) {
        for (MotionEditorSelector.TimeLineListener listener2 : this.mTimeLineListeners) {
            listener2.command(cmd, value2.floatValue());
        }
    }

    private void refreshCycling(boolean cycle) {
        MTag[] kef = this.mTransitionTag.getChildTags("KeyFrameSet");
        if (kef == null || kef.length == 0) {
            cycle = false;
        } else {
            MTag[] timeCycle = kef[0].getChildTags("KeyTimeCycle");
            if (timeCycle == null || timeCycle.length == 0) {
                cycle = false;
            }
        }
        if (cycle) {
            if (this.myMouseDownTimer != null) {
                this.myMouseDownTimer.stop();
                this.myMouseDownTimer = null;
            }
            this.myMouseDownTimer = new Timer(MS_PER_FRAME, e -> this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(this.mMotionProgress)));
            this.myMouseDownTimer.start();
        } else if (this.myMouseDownTimer != null) {
            this.myMouseDownTimer.stop();
            this.myMouseDownTimer = null;
        }
    }

    private void createTimer() {
        if (this.myTimer == null) {
            this.myTimer = new Timer(MS_PER_FRAME, e -> this.progress());
            this.myTimer.setRepeats(true);
            this.myTimer.start();
        }
        if (this.myPlayLimiter == null) {
            this.myPlayLimiter = new Timer(PLAY_TIMEOUT, e -> this.destroyTimer());
            this.myPlayLimiter.setRepeats(false);
            this.myPlayLimiter.start();
        }
    }

    private void watchdog() {
        if (this.myPlayLimiter != null) {
            this.myPlayLimiter.restart();
        }
    }

    private void destroyTimer() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
        if (this.myPlayLimiter != null) {
            this.myPlayLimiter.stop();
            this.myPlayLimiter = null;
        }
    }

    private ActionListener createPlaybackSpeedPopupMenuActionListener(final int playbackSpeedIndex) {
        return new ActionListener(){
            int speedIndex;
            {
                this.speedIndex = playbackSpeedIndex;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Track.animationSpeed(TimeLinePanel.this.mMeModel.myTrack);
                TimeLinePanel.this.mCurrentSpeed = this.speedIndex;
                TimeLinePanel.this.myProgressPerMillisecond = ourSpeedsMultipliers[TimeLinePanel.this.mCurrentSpeed] / (float)TimeLinePanel.this.mDuration;
                TimeLinePanel.this.mTimeLineTopLeft.mSlow.setToolTipText(TimeLinePanel.this.mDuration + " x " + ourSpeedsMultipliers[TimeLinePanel.this.mCurrentSpeed]);
                TimeLinePanel.this.mTimeLineTopLeft.mSlow.setText(ourSpeedsMultipliers[TimeLinePanel.this.mCurrentSpeed] + "x");
            }
        };
    }

    private void showPlaybackSpeedPopup() {
        this.myPlaybackSpeedPopupMenu.show(this.mTimeLineTopLeft.mSlow, 0, 20);
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public void resetMotionProgress() {
        this.mMotionProgress = 0.0f;
        this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(this.mMotionProgress));
        this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_STOP, Float.valueOf(this.mMotionProgress));
        this.repaint();
    }

    private void performCommand(TimeLineTopLeft.TimelineCommands e, int mode) {
        this.watchdog();
        switch (e) {
            case PLAY: {
                this.last_time = System.nanoTime();
                Track.playAnimation(this.mMeModel.myTrack);
                this.createTimer();
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PLAY, Float.valueOf(this.mMotionProgress));
                this.mIsPlaying = true;
                break;
            }
            case SPEED: {
                this.showPlaybackSpeedPopup();
                break;
            }
            case LOOP: {
                Track.animationDirectionToggle(this.mMeModel.myTrack);
                this.myYoyo = mode;
                break;
            }
            case PAUSE: {
                this.mIsPlaying = false;
                this.destroyTimer();
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_STOP, Float.valueOf(this.mMotionProgress));
                this.mTimeLineTopLeft.displayPlay();
                break;
            }
            case END: {
                Track.animationEnd(this.mMeModel.myTrack);
                this.mIsPlaying = false;
                this.destroyTimer();
                this.mMotionProgress = 1.0f;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(this.mMotionProgress));
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_STOP, Float.valueOf(this.mMotionProgress));
                break;
            }
            case START: {
                Track.animationStart(this.mMeModel.myTrack);
                this.mIsPlaying = false;
                this.destroyTimer();
                this.mMotionProgress = 0.0f;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(this.mMotionProgress));
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_STOP, Float.valueOf(this.mMotionProgress));
            }
        }
    }

    private void progress() {
        if (!this.mIsPlaying || this.mMouseDown) {
            return;
        }
        long time = System.nanoTime();
        switch (this.myYoyo) {
            case 0: {
                this.mMotionProgress += this.myProgressPerMillisecond * ((float)(time - this.last_time) * 1.0E-6f);
                if (!(this.mMotionProgress > 1.0f)) break;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(1.0f));
                this.mMotionProgress -= 1.0f;
                break;
            }
            case 1: {
                this.mMotionProgress -= this.myProgressPerMillisecond * ((float)(time - this.last_time) * 1.0E-6f);
                if (!(this.mMotionProgress < 0.0f)) break;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(0.0f));
                this.mMotionProgress = 1.0f + this.mMotionProgress;
                break;
            }
            case 2: {
                this.mMotionProgress += (float)this.mDirection * this.myProgressPerMillisecond * ((float)(time - this.last_time) * 1.0E-6f);
                if (this.mMotionProgress < 0.0f) {
                    this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(0.0f));
                    this.mDirection = 1;
                    this.mMotionProgress = -this.mMotionProgress;
                    break;
                }
                if (!(this.mMotionProgress > 1.0f)) break;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(1.0f));
                this.mDirection = -1;
                this.mMotionProgress = 1.0f - (this.mMotionProgress - 1.0f);
            }
        }
        this.last_time = time;
        this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(this.mMotionProgress));
        this.repaint();
    }

    private void groupSelected() {
        if (this.mTimeLine == null || this.mTimeLine.getSelectedValue() == null || this.mTimeLine.getSelectedValue().mKeyFrames == null) {
            if (this.mTransitionTag != null) {
                this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.TRANSITION, new MTag[]{this.mTransitionTag}, 0);
            }
            return;
        }
        this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.KEY_FRAME_GROUP, this.mTimeLine.getSelectedValue().mKeyFrames.toArray(new MTag[0]), 0);
    }

    public void setMTag(MTag transitionTag, MeModel model2) {
        int index;
        MTag newSelection = this.findSelectedKeyFrameInNewModel(model2);
        this.mTransitionTag = transitionTag;
        if (this.mTransitionTag != null) {
            String duration = this.mTransitionTag.getAttributeValue("duration");
            if (duration != null) {
                try {
                    int durationInt;
                    this.mDuration = durationInt = Integer.parseInt(duration);
                    if (this.mDuration == 0) {
                        this.mDuration = 1000;
                    }
                    this.myProgressPerMillisecond = ourSpeedsMultipliers[this.mCurrentSpeed] / (float)this.mDuration;
                }
                catch (NumberFormatException durationInt) {}
            }
        } else {
            this.mDuration = 1000;
            this.mCurrentSpeed = 2;
            this.myProgressPerMillisecond = 1.0f / (float)this.mDuration;
        }
        if (this.mTimeLineTopLeft != null && this.mTimeLineTopLeft.mSlow != null) {
            this.mTimeLineTopLeft.mSlow.setToolTipText(this.mDuration + " x " + ourSpeedsMultipliers[this.mCurrentSpeed]);
        }
        this.mSelectedKeyFrame = null;
        this.mMeModel = model2;
        List<TimeLineRowData> list = transitionTag != null ? this.buildTransitionList() : Collections.emptyList();
        this.mTimeLine.setListData(list, model2);
        if (transitionTag != null) {
            this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.TRANSITION, new MTag[]{transitionTag}, 0);
        }
        if (newSelection != null && (index = this.findKeyFrameInRows(list, newSelection)) >= 0) {
            this.mTimeLine.setSelectedIndex(index);
            this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.KEY_FRAME, new MTag[]{newSelection}, 0);
            this.mSelectedKeyFrame = newSelection;
        }
    }

    private MTag findSelectedKeyFrameInNewModel(MeModel newModel) {
        if (this.mSelectedKeyFrame == null) {
            return null;
        }
        MTag oldKeyFrameSet = this.mSelectedKeyFrame.getParent();
        if (oldKeyFrameSet == null) {
            return null;
        }
        MTag oldTransition = oldKeyFrameSet.getParent();
        if (oldTransition == null) {
            return null;
        }
        MTag transition2 = newModel.motionScene.getChildTagWithTreeId("Transition", oldTransition.getTreeId());
        if (transition2 == null) {
            return null;
        }
        for (MTag kfSet : transition2.getChildTags("KeyFrameSet")) {
            MTag keyFrame = kfSet.getChildTagWithTreeId(this.mSelectedKeyFrame.getTagName(), this.mSelectedKeyFrame.getTreeId());
            if (keyFrame == null) continue;
            return keyFrame;
        }
        return null;
    }

    private int findKeyFrameInRows(List<TimeLineRowData> rows, MTag keyFrame) {
        for (int index = 0; index < rows.size(); ++index) {
            if (!rows.get((int)index).mKeyFrames.contains(keyFrame)) continue;
            return index;
        }
        return -1;
    }

    private List<TimeLineRowData> buildTransitionList() {
        ArrayList<TimeLineRowData> views = new ArrayList<TimeLineRowData>();
        TreeMap keyMap = new TreeMap();
        MTag[] keyFrameSets = this.mTransitionTag.getChildTags("KeyFrameSet");
        for (int i = 0; i < keyFrameSets.length; ++i) {
            MTag keyFrameSet = keyFrameSets[i];
            MTag[] keyFrames = keyFrameSet.getChildTags();
            for (int j = 0; j < keyFrames.length; ++j) {
                MTag keyFrame = keyFrames[j];
                String targetKey = TimeLinePanel.buildKey(keyFrame);
                if (!keyMap.containsKey(targetKey)) {
                    ArrayList list = new ArrayList();
                    keyMap.put(targetKey, list);
                }
                ((ArrayList)keyMap.get(targetKey)).add(keyFrame);
            }
        }
        for (String id2 : keyMap.keySet()) {
            TimeLineRowData row = new TimeLineRowData();
            row.mKeyFrames = (ArrayList)keyMap.get(id2);
            row.buildKey(row.mKeyFrames.get(0));
            row.buildTargetStrings(row.mKeyFrames.get(0));
            views.add(row);
        }
        return views;
    }

    private void paintCursor(Graphics g, JComponent c) {
        if (this.mTimelineStructure.myXTicksPixels == null || this.mTimelineStructure.myXTicksPixels.length == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = c.getWidth();
        int h = c.getHeight();
        int timeStart = MEUI.ourLeftColumnWidth + this.mTimelineStructure.myXTicksPixels[0];
        int timeWidth = this.mTimelineStructure.myXTicksPixels[this.mTimelineStructure.myXTicksPixels.length - 1] - this.mTimelineStructure.myXTicksPixels[0];
        boolean y = false;
        int x = timeStart + (int)(this.mMotionProgress * (float)timeWidth);
        Color lineColor = MEUI.myTimeCursorColor;
        int inset = 2;
        int d = (int)(this.mMotionProgress * 100.0f);
        Object digits = Integer.toString(d);
        switch (((String)digits).length()) {
            case 1: {
                digits = ".0" + (String)digits;
                break;
            }
            case 2: {
                digits = "." + (String)digits;
                break;
            }
            case 3: {
                digits = "1.0";
            }
        }
        FontMetrics fm = g2.getFontMetrics();
        Color orig = g.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(lineColor);
        Rectangle2D bounds2 = fm.getStringBounds((String)digits, g2);
        int xStart = (int)((double)x - bounds2.getWidth() / 2.0 - (double)inset);
        int halfWidth = (2 * inset + (int)bounds2.getWidth()) / 2;
        int yHeight = 2 * inset + (int)bounds2.getHeight() + 2;
        if (this.mMouseDown) {
            this.myXPoints[0] = xStart;
            this.myYPoints[0] = 0;
            this.myXPoints[1] = xStart;
            this.myYPoints[1] = yHeight;
            this.myXPoints[2] = xStart + halfWidth;
            this.myYPoints[2] = yHeight + 10;
            this.myXPoints[3] = xStart + halfWidth * 2;
            this.myYPoints[3] = yHeight;
            this.myXPoints[4] = xStart + halfWidth * 2;
            this.myYPoints[4] = 0;
            g2.fillPolygon(this.myXPoints, this.myYPoints, 5);
            g.setColor(MEUI.Graph.ourCursorTextColor);
            g2.drawString((String)digits, (int)((double)x - bounds2.getWidth() / 2.0), fm.getAscent() + inset);
        } else {
            this.myXPoints[0] = xStart;
            this.myYPoints[0] = yHeight;
            this.myXPoints[1] = xStart + halfWidth;
            this.myYPoints[1] = yHeight + 10;
            this.myXPoints[2] = xStart + halfWidth * 2;
            this.myYPoints[2] = yHeight;
            g2.fillPolygon(this.myXPoints, this.myYPoints, 3);
        }
        g2.setColor(lineColor);
        g2.drawLine(xStart + halfWidth, yHeight, xStart + halfWidth, h);
    }

    private void processMouseDrag(MouseEvent e) {
        float error;
        if (this.mTimelineStructure == null) {
            return;
        }
        int timeStart = MEUI.ourLeftColumnWidth + this.mTimelineStructure.myXTicksPixels[0];
        int timeWidth = this.mTimelineStructure.myXTicksPixels[this.mTimelineStructure.myXTicksPixels.length - 1] - this.mTimelineStructure.myXTicksPixels[0];
        float progress = (float)(e.getX() - timeStart) / (float)timeWidth;
        boolean inRange = progress > -(error = (float)(2 / timeWidth)) && progress < 1.0f + error;
        switch (e.getID()) {
            case 500: {
                int index;
                TimeLineRow row;
                this.mTimeLine.requestFocus();
                if (inRange) {
                    MTag oldSelection = this.mSelectedKeyFrame;
                    this.selectKeyFrame(progress);
                    int index2 = this.mTimeLine.getSelectedIndex();
                    this.mTimeLine.setSelectedIndex(index2);
                    TimeLineRow row2 = this.mTimeLine.getTimeLineRow(index2);
                    if (row2 == null) {
                        return;
                    }
                    Track.timelineTableSelect(this.mMeModel.myTrack);
                    row2.setSelectedKeyFrame(this.mSelectedKeyFrame);
                    if (this.mSelectedKeyFrame == null || oldSelection != this.mSelectedKeyFrame) {
                        // empty if block
                    }
                }
                if (e.getX() >= this.mTimeLineTopLeft.getWidth() || e.getY() <= this.mTimeLineTopLeft.getHeight() || (row = this.mTimeLine.getTimeLineRow(index = this.mTimeLine.getSelectedIndex())) == null) break;
                row.toggleGraph();
                break;
            }
            case 501: {
                boolean bl = this.mMouseDown = progress >= 0.0f && progress <= 1.0f;
                if (this.mMouseDown) {
                    this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_SCRUB, Float.valueOf(this.mMotionProgress));
                }
                this.repaint();
                break;
            }
            case 502: {
                if (this.mMouseDown) {
                    this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_STOP, Float.valueOf(this.mMotionProgress));
                }
                this.mMouseDown = false;
                this.repaint();
            }
        }
        if (!this.mMouseDown) {
            return;
        }
        if ((e.getModifiersEx() & 0x400) != 0) {
            if (progress >= 0.0f && progress <= 1.0f) {
                this.mMotionProgress = progress;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(progress));
                this.repaint();
            } else if (progress <= 0.0f && this.mMotionProgress != 0.0f) {
                this.mMotionProgress = 0.0f;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(progress));
                this.repaint();
            } else if (progress >= 1.0f && this.mMotionProgress != 1.0f) {
                this.mMotionProgress = 1.0f;
                this.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_PROGRESS, Float.valueOf(progress));
                this.repaint();
            }
        }
    }

    private void selectKeyFrame(float progress) {
        if (this.mTimeLine == null || this.mTimeLine.getSelectedValue() == null) {
            return;
        }
        this.mSelectedKeyFrame = null;
        ArrayList<MTag> f = this.mTimeLine.getSelectedValue().mKeyFrames;
        float minDist = Float.MAX_VALUE;
        MTag minTag = null;
        for (MTag tag2 : f) {
            float dist;
            String posString = tag2.getAttributeValue("framePosition");
            if (posString == null || !((dist = Math.abs(progress - (float)Integer.parseInt(posString) / 100.0f)) < minDist)) continue;
            minTag = tag2;
            minDist = dist;
        }
        if (minDist < 0.1f) {
            this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.KEY_FRAME, new MTag[]{minTag}, 0);
            this.mSelectedKeyFrame = minTag;
            this.repaint();
        }
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mMotionEditorSelector = listeners;
    }

    public int getYoyoMode() {
        return this.myYoyo;
    }

    public float getSpeedMultiplier() {
        return ourSpeedsMultipliers[this.mCurrentSpeed];
    }

    public class METimeLine
    extends JPanel {
        JPanel pad;
        int mSelectedIndex;
        ArrayList<ListSelectionListener> listeners;

        METimeLine() {
            super(new VertLayout());
            this.pad = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(MEUI.ourAvgBackground);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(MEUI.myGridColor);
                    TimeLineRow.drawTicks(g, TimeLinePanel.this.mTimelineStructure, this.getHeight());
                    g.setColor(MEUI.ourBorder);
                    g.fillRect(MEUI.ourLeftColumnWidth, 0, 1, this.getHeight());
                }
            };
            this.mSelectedIndex = 0;
            this.listeners = new ArrayList();
            this.add(this.pad);
            this.pad.setBackground(MEUI.ourAvgBackground);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    TimeLinePanel.this.refreshCycling(true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TimeLinePanel.this.refreshCycling(false);
                    int n = METimeLine.this.getComponentCount() - 1;
                    int y = e.getY();
                    for (int i = 0; i < n; ++i) {
                        Component c = METimeLine.this.getComponent(i);
                        if (y >= c.getY() + c.getHeight()) continue;
                        METimeLine.this.setSelectedIndex(i);
                        break;
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            };
            this.addMouseListener(mouseAdapter);
        }

        void addListSelectionListener(ListSelectionListener l) {
            this.listeners.add(l);
        }

        public TimeLineRow getTimeLineRow(int index) {
            if (this.getComponent(index) instanceof TimeLineRow) {
                return (TimeLineRow)this.getComponent(index);
            }
            return null;
        }

        public TimeLineRowData getSelectedValue() {
            if (this.getComponent(this.mSelectedIndex) instanceof TimeLineRow) {
                return ((TimeLineRow)this.getComponent((int)this.mSelectedIndex)).mRow;
            }
            return null;
        }

        public void setListData(List<TimeLineRowData> list, MeModel model2) {
            boolean showTitle;
            TimeLineRowData data;
            TimeLineRow child;
            int i;
            Component[] children = this.getComponents();
            this.removeAll();
            String lastName = null;
            int n = Math.min(children.length - 1, list.size());
            for (i = 0; i < n; ++i) {
                child = (TimeLineRow)children[i];
                data = list.get(i);
                showTitle = data.mName == null || !data.mName.equals(lastName);
                child.setRowData(model2, data, i, false, false, TimeLinePanel.this.mSelectedKeyFrame, showTitle);
                lastName = data.mName;
                this.add(child);
            }
            if (n >= 0 && list.size() > n) {
                for (i = n; i < list.size(); ++i) {
                    child = new TimeLineRow(TimeLinePanel.this.mTimelineStructure);
                    data = list.get(i);
                    boolean bl = showTitle = data.mName == null || !data.mName.equals(lastName);
                    if (data == null || data.mName == null) {
                        showTitle = false;
                    } else {
                        lastName = data.mName;
                    }
                    child.setRowData(model2, data, i, false, false, TimeLinePanel.this.mSelectedKeyFrame, showTitle);
                    this.add(child);
                }
            }
            this.add(this.pad);
            this.revalidate();
        }

        public int getSelectedIndex() {
            return this.mSelectedIndex;
        }

        public void setSelectedIndex(int index) {
            if (index < 0) {
                return;
            }
            int prev = this.mSelectedIndex;
            this.mSelectedIndex = index;
            if (TimeLinePanel.this.mSelectedKeyFrame == null) {
                this.notifySelectionListener(index);
            }
            if (this.getComponentCount() > prev) {
                Component comp = this.getComponent(prev);
                if (!(comp instanceof TimeLineRow)) {
                    return;
                }
                TimeLineRow child = (TimeLineRow)comp;
                child.setSelected(false);
                child.repaint();
            }
            TimeLineRow child = (TimeLineRow)this.getComponent(this.mSelectedIndex);
            child.setSelected(true);
            child.repaint();
        }

        private void notifySelectionListener(int index) {
            ListSelectionEvent event = new ListSelectionEvent(this, index, index, false);
            for (ListSelectionListener listener2 : this.listeners) {
                listener2.valueChanged(event);
            }
        }
    }

    static class VertLayout
    implements LayoutManager {
        Dimension dimension = new Dimension();

        VertLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = 0;
            int width2 = 0;
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                Dimension size = c.getPreferredSize();
                width2 = Math.max(width2, size.width);
                y += size.height;
            }
            this.dimension.height = y;
            this.dimension.width = width2;
            return this.dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int y = 0;
            int width2 = 0;
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                Dimension size = c.getMinimumSize();
                width2 = Math.max(width2, size.width);
                y += size.height;
            }
            this.dimension.height = y;
            this.dimension.width = width2;
            return this.dimension;
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = 0;
            int n = parent.getComponentCount();
            int parent_height = parent.getHeight();
            int parent_width = parent.getWidth();
            for (int i = 0; i < n; ++i) {
                Component c = parent.getComponent(i);
                Dimension size = c.getPreferredSize();
                if (i < n - 1) {
                    c.setBounds(0, y, parent_width, size.height);
                } else if (parent_height - y <= 0) {
                    c.setBounds(0, y, parent_width, 0);
                    c.setVisible(false);
                } else {
                    c.setBounds(0, y, parent_width, parent_height - y);
                }
                y += size.height;
            }
        }
    }
}

