/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.util.ArrayList;
import java.util.HashMap;

public class TimeLineRowData {
    public static final boolean DEBUG = false;
    String mKey;
    String mRef;
    String mName;
    String mKeyProp;
    String mKeyPropToolTip;
    String mType;
    int mKeyPropIndex = 0;
    private static String[] properties = new String[]{"transitionPathRotate", "alpha", "elevation", "rotation", "rotationX", "rotationY", "scaleX", "scaleY", "translationX", "translationY", "translationZ", "motionProgress"};
    private static String[] compact_properties = new String[]{"PathRot", "alph", "elv", "rot", "rotX", "rotY", "scaleX", "scaleY", "tranX", "tranY", "tranZ", "Prog"};
    private static HashMap<String, String> nameMap = new HashMap();
    public static final String TYPE_KEY_TRIGGER = "Trig";
    public static final String TYPE_KEY_TIME_CYCLE = "TCyc";
    public static final String TYPE_KEY_CYCLE = "Cyc";
    public static final String TYPE_KEY_POSITION = "Pos";
    public static final String TYPE_KEY_ATTRIBUTE = "Att";
    private static HashMap<String, Integer> propertyMap;
    ArrayList<MTag> mKeyFrames = new ArrayList();

    public void buildTargetStrings(MTag keyFrame) {
        int i;
        String target = keyFrame.getAttributeValue("motionTarget");
        this.mType = nameMap.get(keyFrame.getTagName());
        if (this.mType == null) {
            System.err.println(" no name for " + keyFrame.getTagName());
        }
        if (target != null && target.startsWith("@")) {
            this.mRef = "Id";
            this.mName = Utils.stripID(target);
        } else {
            this.mRef = "Tg";
            this.mName = target;
        }
        int mask = 0;
        int count = 0;
        for (i = 0; i < properties.length; ++i) {
            if (keyFrame.getAttributeValue(properties[i]) == null) continue;
            mask |= 1 << i;
            ++count;
            this.mKeyProp = properties[i];
            this.mKeyPropIndex = propertyMap.getOrDefault(this.mKeyProp, properties.length - 1);
        }
        if (count > 1) {
            count = 0;
            this.mKeyProp = "";
            this.mKeyPropToolTip = "";
            this.mKeyPropIndex = properties.length - 1;
            for (i = 0; i < properties.length; ++i) {
                if ((mask & 1 << i) == 0) continue;
                if (count > 0) {
                    this.mKeyProp = this.mKeyProp + ",";
                    this.mKeyPropToolTip = this.mKeyPropToolTip + ",";
                }
                this.mKeyProp = this.mKeyProp + compact_properties[i];
                this.mKeyPropToolTip = this.mKeyPropToolTip + properties[i];
                ++count;
            }
        } else if (count == 0) {
            this.mKeyProp = "";
            this.mKeyPropToolTip = "";
        }
        if (this.mType.equals(TYPE_KEY_POSITION)) {
            this.mKeyProp = keyFrame.getAttributeValue("keyPositionType");
            if (this.mKeyProp == null) {
                this.mKeyProp = "(deltaRelative)";
            }
        }
    }

    public void buildKey(MTag keyFrame) {
        String target = keyFrame.getAttributeValue("motionTarget");
        Object key = target;
        key = target != null && target.startsWith("@") ? "Id:" + Utils.stripID(target) : "Tag:" + target;
        String name = " " + nameMap.get(keyFrame.getTagName());
        this.mKey = key = (String)key + name;
    }

    static {
        nameMap.put("KeyTrigger", TYPE_KEY_TRIGGER);
        nameMap.put("KeyTimeCycle", TYPE_KEY_TIME_CYCLE);
        nameMap.put("KeyCycle", TYPE_KEY_CYCLE);
        nameMap.put("KeyPosition", TYPE_KEY_POSITION);
        nameMap.put("KeyAttribute", TYPE_KEY_ATTRIBUTE);
        propertyMap = new HashMap();
        for (int i = 0; i < properties.length; ++i) {
            propertyMap.put(properties[i], i);
        }
    }
}

