/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TickMarkCalculator;
import com.android.tools.idea.uibuilder.handlers.motion.editor.timeline.TimelineStructure;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;

public class TimeLineTopPanel
extends JPanel {
    TickMarkCalculator mTickMarkCalculator = new TickMarkCalculator();
    int mXTickCount;
    TimelineStructure mTimelineStructure;

    TimeLineTopPanel(TimelineStructure timelineStructure) {
        this.setPreferredSize(new Dimension(MEUI.scale(100), MEUI.ourHeaderHeight));
        this.setBackground(MEUI.ourSecondaryPanelBackground);
        this.mTimelineStructure = timelineStructure;
        this.mTimelineStructure.mTimeLineInsetLeft = this.mTickMarkCalculator.ins_left;
        this.mTimelineStructure.mTimeLineInsetRight = this.mTickMarkCalculator.ins_right;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TimeLineTopPanel.this.resize();
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mTickMarkCalculator != null) {
            this.setPreferredSize(new Dimension(MEUI.scale(100), MEUI.ourHeaderHeight));
            this.resize();
        }
    }

    private void resize() {
        int w = this.getWidth();
        int h = this.getHeight();
        this.mTickMarkCalculator.calcRangeTicks(w);
        int n = this.mTickMarkCalculator.getCount();
        if (this.mTimelineStructure.myXTicksPixels.length != n) {
            this.mTimelineStructure.myXTicksPixels = new int[n];
        }
        this.mTickMarkCalculator.calcTicks(this.mTimelineStructure.myXTicksPixels);
        int old = this.mTimelineStructure.mTimeLineWidth;
        this.mTimelineStructure.mTimeLineWidth = w;
        this.mTimelineStructure.fireWidthChanged(old, this.mTimelineStructure.mTimeLineWidth);
        this.getParent().repaint();
    }

    public void setRange(float min, float max) {
        this.mTickMarkCalculator.setRange(min, max);
        this.mTimelineStructure.mTimeLineMinValue = min;
        this.mTimelineStructure.mTimeLineMaxValue = max;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(MEUI.ourBorder);
        g.fillRect(0, 0, 1, h);
        g.fillRect(0, h - 1, w, 1);
        g.setColor(MEUI.myGridColor);
        int n = this.mTickMarkCalculator.getCount();
        if (this.mTimelineStructure.myXTicksPixels.length > 0) {
            this.mXTickCount = this.mTickMarkCalculator.paint(g2d, w, h, this.mTimelineStructure.myXTicksPixels);
        }
    }
}

