/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.actions.ModifyMenuAction;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEJTable;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.StringMTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ConstraintSetPanelCommands;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.DefaultToolbarImpl;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class ConstraintSetPanel
extends JPanel {
    private MTag mSelectedTag;
    private MTag[] mMultiSelectedTag;
    MotionEditorSelector mListeners;
    private static boolean DEBUG = false;
    ArrayList<MTag> mParent;
    MTag mConstraintSet;
    ArrayList<MTag> mDisplayedRows = new ArrayList();
    DefaultTableModel mConstraintSetModel = new DefaultTableModel(new String[]{"Constraint", "ID", "Source"}, 0){

        public Class getColumnClass(int column) {
            return column == 0 ? Icon.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    JTable mConstraintSetTable = new MEJTable(this.mConstraintSetModel);
    private String mDerived;
    boolean showAll = true;
    private MeModel mMeModel;
    private final JLabel mTitle;
    boolean mBuildingTable;
    AnActionButton createConstraint = new AnActionButton("Create Constraint"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            Track.createConstraint(ConstraintSetPanel.this.mMeModel.myTrack);
            ConstraintSetPanelCommands.createConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$2", "actionPerformed"));
        }
    };
    AnActionButton createAllConstraints = new AnActionButton("Create All Constraints"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                3.$$$reportNull$$$0(0);
            }
            Track.createConstraint(ConstraintSetPanel.this.mMeModel.myTrack);
            ConstraintSetPanelCommands.createAllConstraints(ConstraintSetPanel.this.mDisplayedRows, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$3", "actionPerformed"));
        }
    };
    AnActionButton createSectionedConstraint = new AnActionButton("Create Sectioned Constraint"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                4.$$$reportNull$$$0(0);
            }
            ConstraintSetPanelCommands.createSectionedConstraint(ConstraintSetPanel.this.mMultiSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$4", "actionPerformed"));
        }
    };
    AnActionButton clearConstraint = new AnActionButton("Clear Constraint"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                5.$$$reportNull$$$0(0);
            }
            Track.clearConstraint(ConstraintSetPanel.this.mMeModel.myTrack);
            ConstraintSetPanelCommands.clearConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
            ConstraintSetPanel.this.buildTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$5", "actionPerformed"));
        }
    };
    AnActionButton moveConstraint = new AnActionButton("Move Constraints to layout"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                6.$$$reportNull$$$0(0);
            }
            ConstraintSetPanelCommands.moveConstraint(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$6", "actionPerformed"));
        }
    };
    AnActionButton overrideConstraint = new AnActionButton("Convert from sectioned constraints"){

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                7.$$$reportNull$$$0(0);
            }
            ConstraintSetPanelCommands.convertFromSectioned(ConstraintSetPanel.this.mSelectedTag, ConstraintSetPanel.this.mConstraintSet);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$7", "actionPerformed"));
        }
    };
    ModifyMenuAction mModifyMenu = new ModifyMenuAction(){

        @Override
        @NotNull
        public List<AnAction> getActions() {
            if (DEBUG) {
                List<AnActionButton> list = List.of(ConstraintSetPanel.this.createConstraint, ConstraintSetPanel.this.createAllConstraints, ConstraintSetPanel.this.clearConstraint, ConstraintSetPanel.this.moveConstraint, ConstraintSetPanel.this.createSectionedConstraint, ConstraintSetPanel.this.overrideConstraint);
                if (list == null) {
                    8.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<AnActionButton> list = List.of(ConstraintSetPanel.this.createConstraint, ConstraintSetPanel.this.createAllConstraints, ConstraintSetPanel.this.clearConstraint);
            if (list == null) {
                8.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/motion/editor/ui/ConstraintSetPanel$8", "getActions"));
        }
    };
    private String mConstraintSetId;

    ConstraintSetPanel() {
        super(new BorderLayout());
        JPanel left = new JPanel(new GridBagLayout());
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)left, "West");
        top.add((Component)right2, "East");
        top.setBorder(MEUI.getPanelBottomBorder());
        this.mConstraintSetTable.setShowHorizontalLines(false);
        this.mConstraintSetTable.setAlignmentY(0.0f);
        this.mConstraintSetTable.getColumnModel().getColumn(0).setPreferredWidth(MEUI.scale(32));
        this.mConstraintSetTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                this.setBorder(noFocusBorder);
                return this;
            }
        });
        this.mConstraintSetTable.setDefaultRenderer(Icon.class, new TableCellRenderer(){
            JLabel myLabel = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.setIcon((Icon)value2);
                this.myLabel.setHorizontalAlignment(0);
                this.myLabel.setSize(new Dimension(MEUI.scale(18), MEUI.scale(12)));
                if (isSelected) {
                    if (hasFocus) {
                        if (value2 == MEIcons.LIST_STATE_DERIVED) {
                            this.myLabel.setIcon(MEIcons.LIST_STATE_DERIVED_SELECTED);
                        } else if (value2 == MEIcons.LIST_STATE) {
                            this.myLabel.setIcon(MEIcons.LIST_STATE_SELECTED);
                        }
                    }
                    this.myLabel.setBackground(table.hasFocus() ? MEUI.CSPanel.our_SelectedFocusBackground : MEUI.CSPanel.our_SelectedBackground);
                    this.myLabel.setOpaque(true);
                } else {
                    this.myLabel.setOpaque(false);
                    this.myLabel.setBackground(MEUI.ourPrimaryPanelBackground);
                }
                return this.myLabel;
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel leftLabel = new JLabel("ConstraintSet (", MEIcons.CONSTRAINT_SET, 0);
        this.mTitle = new JLabel("", 0);
        JLabel rightLabel = new JLabel(")", 0);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.ipadx = 16;
        left.add((Component)leftLabel, gbc);
        gbc.fill = 2;
        gbc.gridy = 0;
        ++gbc.gridx;
        gbc.weightx = 0.5;
        gbc.ipadx = 0;
        left.add((Component)this.mTitle, gbc);
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.ipadx = 16;
        left.add((Component)rightLabel, gbc);
        this.makeRightMenu(right2);
        ActionListener copyListener = e -> this.copy();
        ActionListener pasteListener = e -> this.paste();
        MEUI.addCopyPaste(copyListener, pasteListener, this.mConstraintSetTable);
        this.mConstraintSetTable.getSelectionModel().addListSelectionListener(e -> {
            MTag[] mTagArray;
            if (this.mBuildingTable) {
                return;
            }
            int index = this.mConstraintSetTable.getSelectedRow();
            int[] allSelect = this.mConstraintSetTable.getSelectedRows();
            this.mModifyMenu.setEnabled(index != -1);
            this.mSelectedTag = null;
            if (index == -1) {
                this.mSelectedTag = null;
                return;
            }
            this.mMultiSelectedTag = new MTag[allSelect.length];
            for (int i = 0; i < allSelect.length; ++i) {
                int k = allSelect[i];
                this.mMultiSelectedTag[i] = this.mDisplayedRows.get(k);
            }
            if (this.mDisplayedRows.isEmpty()) {
                mTagArray = new MTag[]{};
            } else {
                MTag[] mTagArray2 = new MTag[1];
                mTagArray = mTagArray2;
                mTagArray2[0] = this.mSelectedTag = this.mDisplayedRows.get(index);
            }
            MTag[] tag2 = mTagArray;
            this.mListeners.notifyListeners(MotionEditorSelector.Type.CONSTRAINT, tag2, 0);
            this.enableMenuItems(tag2);
        });
        MEScrollPane transitionProperties = new MEScrollPane(this.mConstraintSetTable);
        ((JComponent)((Object)transitionProperties)).setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)((Object)transitionProperties), "Center");
        this.add((Component)top, "North");
    }

    private void enableMenuItems(MTag[] selected) {
        boolean hasSelection = selected.length > 0;
        this.mModifyMenu.setEnabled(hasSelection);
        if (!hasSelection) {
            return;
        }
        boolean inCurrentSelection = false;
        MTag[] tags = this.mConstraintSet.getChildTags();
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(selected[0])) continue;
            inCurrentSelection = true;
            break;
        }
        if (inCurrentSelection) {
            this.createConstraint.setEnabled(false);
            this.createSectionedConstraint.setEnabled(false);
            this.clearConstraint.setEnabled(true);
            this.moveConstraint.setEnabled(true);
            this.overrideConstraint.setEnabled(true);
        } else {
            this.createConstraint.setEnabled(true);
            this.createSectionedConstraint.setEnabled(true);
            this.clearConstraint.setEnabled(false);
            this.moveConstraint.setEnabled(false);
            this.overrideConstraint.setEnabled(false);
        }
        if (tags.length == this.mDisplayedRows.size()) {
            this.createAllConstraints.setEnabled(false);
        } else {
            this.createAllConstraints.setEnabled(true);
        }
    }

    private void copy() {
        MEUI.copy(this.mSelectedTag);
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String buff = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringMTag pastedTag = StringMTag.parse(buff);
            HashMap<String, MTag.Attribute> attr2 = pastedTag.getAttrList();
            if (this.mSelectedTag != null) {
                String tagName = this.mSelectedTag.getTagName();
                if ("Constraint".equals(tagName)) {
                    MTag.Attribute a;
                    HashMap<String, MTag.Attribute> toDel = new HashMap<String, MTag.Attribute>(this.mSelectedTag.getAttrList());
                    toDel.remove("id");
                    MTag.TagWriter writer = this.mSelectedTag.getTagWriter();
                    if (writer == null) {
                        return;
                    }
                    for (String s : toDel.keySet()) {
                        a = toDel.get(s);
                        writer.setAttribute(a.mNamespace, a.mAttribute, null);
                    }
                    for (String s : attr2.keySet()) {
                        a = attr2.get(s);
                        if (a == null || a.mAttribute.equals("id")) continue;
                        writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                    }
                    StringMTag[] children = pastedTag.getChildTags();
                    for (int i = 0; i < children.length; ++i) {
                        StringMTag child = children[i];
                        MTag.TagWriter cw = writer.getChildTagWriter(child.getTagName());
                        HashMap<String, MTag.Attribute> cwAttrMap = pastedTag.getAttrList();
                        for (String cwAttrStr : cwAttrMap.keySet()) {
                            MTag.Attribute cwAttr = cwAttrMap.get(cwAttrStr);
                            cw.setAttribute(cwAttr.mNamespace, cwAttr.mAttribute, cwAttr.mValue);
                        }
                    }
                    writer.commit("paste");
                } else if (!"Guideline".equals(tagName)) {
                    String id2 = this.mSelectedTag.getAttributeValue("id");
                    MTag.TagWriter writer = this.mConstraintSet.getChildTagWriter("Constraint");
                    for (String s : attr2.keySet()) {
                        MTag.Attribute a = attr2.get(s);
                        if (a == null || a.mAttribute.equals("id")) {
                            writer.setAttribute(a.mNamespace, a.mAttribute, "@+id/" + Utils.stripID(id2));
                            continue;
                        }
                        writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                    }
                    StringMTag[] children = pastedTag.getChildTags();
                    for (int i = 0; i < children.length; ++i) {
                        StringMTag child = children[i];
                        MTag.TagWriter cw = writer.getChildTagWriter(child.getTagName());
                        HashMap<String, MTag.Attribute> cwAttrMap = pastedTag.getAttrList();
                        for (String cwAttrStr : cwAttrMap.keySet()) {
                            MTag.Attribute cwAttr = cwAttrMap.get(cwAttrStr);
                            cw.setAttribute(cwAttr.mNamespace, cwAttr.mAttribute, cwAttr.mValue);
                        }
                    }
                    writer.commit("paste");
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeRightMenu(JPanel right2) {
        DefaultToolbarImpl toolbar = new DefaultToolbarImpl(this, "ModifyMenu", (List<? extends AnAction>)ImmutableList.of((Object)((Object)this.mModifyMenu)));
        right2.add((Component)((Object)toolbar));
        this.mModifyMenu.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTable() {
        this.mBuildingTable = true;
        try {
            Object[] row;
            int i;
            HashSet<String> found = new HashSet<String>();
            this.mConstraintSetModel.setNumRows(0);
            this.mDisplayedRows.clear();
            if (this.mConstraintSet == null) {
                return;
            }
            String cset_id = Utils.stripID(this.mConstraintSet.getAttributeValue("id"));
            MTag[] sets = this.mConstraintSet.getChildTags("Constraint");
            String derived = this.mConstraintSet.getAttributeValue("deriveConstraintsFrom");
            if (DEBUG) {
                for (i = 0; i < sets.length; ++i) {
                    MTag set = sets[i];
                    Debug.log(i + " " + set.getTagName() + " " + set.getTreeId());
                }
            }
            for (i = 0; i < sets.length; ++i) {
                MTag constraint = sets[i];
                row = new Object[4];
                String id2 = Utils.stripID(constraint.getAttributeValue("id"));
                found.add(id2);
                row[1] = id2;
                ArrayList<MTag> children = constraint.getChildren();
                HashMap<String, MTag.Attribute> attrs = constraint.getAttrList();
                row[2] = cset_id;
                row[0] = MEIcons.LIST_STATE;
                this.mDisplayedRows.add(constraint);
                this.mConstraintSetModel.addRow(row);
            }
            if (this.showAll && this.mMeModel.layout != null) {
                MTag[] allViews = this.mMeModel.layout.getChildTags();
                for (int j = 0; j < allViews.length; ++j) {
                    row = new Object[4];
                    MTag view2 = allViews[j];
                    String layoutId = view2.getAttributeValue("id");
                    if (layoutId == null) {
                        row[0] = view2.getTagName().substring(1 + view2.getTagName().lastIndexOf("/"));
                        continue;
                    }
                    if (found.contains(layoutId = Utils.stripID(layoutId))) continue;
                    row[1] = layoutId;
                    row[3] = derived == null ? "layout" : this.findFirstDefOfView(layoutId, this.mConstraintSet);
                    row[2] = row[3];
                    row[0] = "layout".equals(row[3]) ? null : MEIcons.LIST_STATE_DERIVED;
                    this.mDisplayedRows.add(view2);
                    this.mConstraintSetModel.addRow(row);
                }
            }
            this.mConstraintSetModel.fireTableDataChanged();
        }
        finally {
            this.mBuildingTable = false;
        }
    }

    private void updateModelIfNecessary() {
        Set found;
        Set ids = Arrays.stream(this.mConstraintSet.getChildTags("Constraint")).map(view2 -> view2.getAttributeValue("id")).filter(Objects::nonNull).collect(Collectors.toSet());
        if (this.showAll && this.mMeModel.layout != null) {
            Arrays.stream(this.mMeModel.layout.getChildTags()).map(view2 -> Utils.stripID(view2.getAttributeValue("id"))).filter(Objects::nonNull).forEach(ids::add);
        }
        if (!ids.equals(found = this.mConstraintSetModel.getDataVector().stream().map(row -> (String)row.get(1)).collect(Collectors.toSet()))) {
            this.buildTable();
        }
    }

    private String findFirstDefOfView(String viewId, MTag constraintSet) {
        MTag[] sets = constraintSet.getChildTags("Constraint");
        for (int i = 0; i < sets.length; ++i) {
            String cid = Utils.stripID(sets[i].getAttributeValue("id"));
            if (!viewId.equals(cid)) continue;
            return Utils.stripID(constraintSet.getAttributeValue("id"));
        }
        String derive = constraintSet.getAttributeValue("deriveConstraintsFrom");
        if (derive == null) {
            return "layout";
        }
        derive = Utils.stripID(derive);
        for (MTag child : this.mMeModel.motionScene.getChildren()) {
            String cid;
            if (!child.getTagName().equals("ConstraintSet") || !derive.equals(cid = Utils.stripID(child.getAttributeValue("id")))) continue;
            return this.findFirstDefOfView(viewId, child);
        }
        return "???";
    }

    public void setMTag(MTag constraintSet, MeModel meModel) {
        if (DEBUG) {
            if (constraintSet == null) {
                Debug.logStack("setMTag constraintSet = null", 4);
            }
            Debug.log("ConstraintSetPanel.setMTag constraintSet = " + constraintSet);
            Debug.log("ConstraintSetPanel.setMTag motionScene = " + meModel.motionScene);
            Debug.log("ConstraintSetPanel.setMTag layout = " + meModel.layout);
        }
        String[] selected = this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : new String[]{};
        this.mMeModel = meModel;
        this.mConstraintSet = constraintSet;
        this.mDerived = null;
        if (this.mConstraintSet != null) {
            this.mMeModel.setSelected(MotionEditorSelector.Type.CONSTRAINT_SET, new MTag[]{constraintSet});
            String derived = this.mConstraintSet.getAttributeValue("deriveConstraintsFrom");
            if (derived != null) {
                this.mDerived = Utils.stripID(derived);
                MTag[] constraintSets = meModel.motionScene.getChildTags("ConstraintSet");
                this.mParent = this.getDerived(constraintSets, this.mDerived);
            }
            this.mConstraintSetId = Utils.stripID(this.mConstraintSet.getAttributeValue("id"));
            this.mTitle.setText(this.mConstraintSetId);
        } else if (this.mConstraintSetId != null) {
            this.mConstraintSet = this.mMeModel.getConstraintSet(this.mConstraintSetId);
        }
        this.buildTable();
        if (constraintSet != null) {
            HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(selected));
            for (int i = 0; i < this.mConstraintSetModel.getRowCount(); ++i) {
                String id2 = (String)this.mConstraintSetModel.getValueAt(i, 1);
                if (!selectedSet.contains(id2)) continue;
                this.mConstraintSetTable.addRowSelectionInterval(i, i);
            }
        }
    }

    public void clearSelection() {
        this.mConstraintSetTable.clearSelection();
    }

    ArrayList<MTag> getDerived(MTag[] constraintSets, String derived) {
        for (int i = 0; i < constraintSets.length; ++i) {
            String id2 = Utils.stripID(constraintSets[i].getAttributeValue("id"));
            if (!derived.equals(id2)) continue;
            String also = constraintSets[i].getAttributeValue("deriveConstraintsFrom");
            if (also != null) {
                also = Utils.stripID(also);
                ArrayList<MTag> ret = this.getDerived(constraintSets, also);
                ret.add(0, constraintSets[i]);
                return ret;
            }
            ArrayList<MTag> ret = new ArrayList<MTag>();
            ret.add(constraintSets[i]);
            return ret;
        }
        return new ArrayList<MTag>();
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mListeners = listeners;
        this.mListeners.addSelectionListener(new MotionEditorSelector.Listener(){
            boolean in = false;

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag2, int flags) {
                ArrayList<String> selectedIds = new ArrayList<String>();
                if (this.in) {
                    return;
                }
                this.in = true;
                ConstraintSetPanel.this.mBuildingTable = true;
                if (DEBUG) {
                    Debug.log(" selectionChanged " + selection);
                }
                if (selection == MotionEditorSelector.Type.CONSTRAINT) {
                    int i;
                    HashSet<String> selectedSet = new HashSet<String>();
                    for (i = 0; i < tag2.length; ++i) {
                        MTag mTag = tag2[i];
                        String id2 = Utils.stripID(mTag.getAttributeValue("id"));
                        selectedSet.add(id2);
                    }
                    ConstraintSetPanel.this.mConstraintSetTable.clearSelection();
                    for (i = 0; i < ConstraintSetPanel.this.mConstraintSetModel.getRowCount(); ++i) {
                        String id3 = (String)ConstraintSetPanel.this.mConstraintSetModel.getValueAt(i, 1);
                        if (!selectedSet.contains(id3)) continue;
                        selectedIds.add(id3);
                        ConstraintSetPanel.this.mConstraintSetTable.addRowSelectionInterval(i, i);
                    }
                }
                if (ConstraintSetPanel.this.isVisible() && selection.equals((Object)MotionEditorSelector.Type.CONSTRAINT)) {
                    ConstraintSetPanel.this.mMeModel.setSelectedViewIDs(selectedIds);
                }
                this.in = false;
                ConstraintSetPanel.this.mBuildingTable = false;
            }
        });
    }

    public void selectById(String[] ids) {
        if (this.mConstraintSet == null) {
            if (this.mConstraintSetModel != null) {
                int count = this.mConstraintSetModel.getRowCount();
                for (int i = 0; i < count; ++i) {
                    this.mConstraintSetModel.removeRow(0);
                }
            }
            return;
        }
        this.updateModelIfNecessary();
        HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(ids));
        this.mConstraintSetTable.clearSelection();
        for (int i = 0; i < this.mConstraintSetModel.getRowCount(); ++i) {
            String id2 = (String)this.mConstraintSetModel.getValueAt(i, 1);
            if (!selectedSet.contains(id2)) continue;
            this.mConstraintSetTable.addRowSelectionInterval(i, i);
        }
    }
}

