/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ErrorPanel
extends JPanel {
    JLabel myBanner = new JLabel();
    JLabel myLabel = new JLabel();
    JLabel myErrorLabel = new JLabel();
    String error;
    HashSet<String> validTop = new HashSet<String>(Arrays.asList("Transition", "ConstraintSet", "Include", ErrorPanel.upperCaseFirst("Include"), "ViewTransition"));
    HashMap<String, HashSet<String>> containedIn = new HashMap();

    ErrorPanel() {
        super(new GridBagLayout());
        this.put("Constraint", "ConstraintSet");
        this.put("ConstraintOverride", "ConstraintSet");
        this.put("KeyFrameSet", "ViewTransition");
        this.put("ConstraintOverride", "ViewTransition");
        this.put("KeyFrameSet", "Transition");
        this.put("KeyAttribute", "KeyFrameSet");
        this.put("KeyCycle", "KeyFrameSet");
        this.put("KeyPosition", "KeyFrameSet");
        this.put("KeyTrigger", "KeyFrameSet");
        this.put("KeyTimeCycle", "KeyFrameSet");
        this.put("OnClick", "Transition");
        this.put("OnSwipe", "Transition");
        this.put("CustomAttribute", "Constraint");
        this.put("CustomAttribute", "ConstraintOverride");
        this.put("CustomAttribute", "KeyTrigger");
        this.put("CustomAttribute", "KeyAttribute");
        this.put("CustomAttribute", "KeyTimeCycle");
        this.put("CustomAttribute", "KeyCycle");
        this.put("Motion", "Constraint");
        this.put("Layout", "Constraint");
        this.put("PropertySet", "Constraint");
        this.put("Transform", "Constraint");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.myBanner.setText("Motion Editor cannot be used");
        this.myBanner.setOpaque(true);
        this.myBanner.setMinimumSize(new Dimension(1, MEUI.scale(16)));
        this.myBanner.setBackground(MEUI.ourBannerColor);
        this.add((Component)this.myBanner, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.myLabel.setText("Motion Editor");
        this.add((Component)this.myLabel, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.insets(10, 10, 10, 10);
        this.myLabel.setVerticalAlignment(3);
        this.myLabel.setHorizontalAlignment(0);
        Font font = this.myLabel.getFont();
        this.myLabel.setFont(font.deriveFont((float)font.getSize() * 2.0f));
        this.myErrorLabel.setName("MotionEditorErrorLabel");
        this.myErrorLabel.setVerticalAlignment(1);
        this.myErrorLabel.setText(null);
        this.add((Component)this.myErrorLabel, gbc);
        this.myErrorLabel.setForeground(MEUI.ourErrorColor);
    }

    private static String upperCaseFirst(String str) {
        return str.substring(0, 1).toUpperCase(Locale.US) + str.substring(1);
    }

    private void put(String tag2, String canBeIn) {
        HashSet<String> set = this.containedIn.get(tag2);
        if (set == null) {
            set = new HashSet();
            this.containedIn.put(tag2, set);
        }
        set.add(canBeIn);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myBanner != null) {
            this.myBanner.setBackground(MEUI.ourBannerColor);
        }
    }

    public boolean validateMotionScene(MTag scene) {
        Object str = null;
        if (scene == null) {
            this.myErrorLabel.setText("<HTML>MotionScene Syntax error:<ul>No valid LayoutDescription</ul></HTML>");
            return false;
        }
        MTag[] layer0 = scene.getChildTags();
        if (layer0.length == 0) {
            this.myErrorLabel.setText("<HTML>MotionScene Syntax error:<ul>Empty Scene</ul></HTML>");
            return false;
        }
        boolean hasTransitions = false;
        for (int i = 0; i < layer0.length; ++i) {
            String tagName = layer0[i].getTagName();
            hasTransitions |= "Transition".equals(tagName);
            if (!this.validTop.contains(tagName)) {
                str = (String)(str != null ? (String)str + "\n" : "") + "<li> &lt;" + tagName + "&gt; cannot be a top level component </li>";
            }
            str = this.validateChildren(layer0[i], (String)str);
        }
        if (str != null) {
            str = "<HTML>MotionScene Syntax error:<ul>" + str + "</ul></HTML>";
        } else if (!hasTransitions) {
            str = "<HTML>MotionScene Syntax error:<ul>At least one transition required.</ul></HTML>";
        }
        this.error = str;
        this.myErrorLabel.setText(this.error);
        return this.error == null;
    }

    public String validateChildren(MTag tag2, String ret) {
        MTag[] child = tag2.getChildTags();
        String parent = tag2.getTagName();
        for (int i = 0; i < child.length; ++i) {
            String childName = child[i].getTagName();
            if ("CustomAttribute".equals(childName) && (parent.equals("Constraint") || parent.equals("KeyCycle") || parent.equals("KeyAttribute") || parent.equals("KeyTrigger") || parent.equals("KeyTimeCycle"))) continue;
            HashSet<String> shouldBeIn = this.containedIn.get(childName);
            if (shouldBeIn == null) {
                ret = (String)(ret != null ? (String)ret + "\n" : "") + "<li> &lt;" + childName + "&gt; of parent &lt;" + parent + "&gt; unknown</li>";
            }
            if (!shouldBeIn.contains(parent)) {
                String[] in = shouldBeIn.toArray(new String[0]);
                Object tags = in[0];
                for (int j = 1; j < in.length; ++j) {
                    tags = (String)tags + " or " + in[j];
                }
                ret = (String)(ret != null ? (String)ret + "\n" : "") + "<li> &lt;" + childName + "&gt; of parent &lt;" + parent + "&gt; should be in &lt;" + (String)tags + "&gt;</li>";
            }
            ret = this.validateChildren(child[i], (String)ret);
        }
        return ret;
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame("  error panel ");
        frame.setContentPane(new ErrorPanel());
        frame.setBounds(100, 100, 500, 800);
        frame.setTitle("JFrame");
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

