/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MeModel {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public final boolean DEBUG = false;
    public final MTag motionScene;
    public final MTag layout;
    public final String layoutFileName;
    public final String motionSceneFileName;
    MotionEditorSelector.Type mSelectedType;
    public MTag[] mSelected;
    private float mProgress;
    private String[] mSelectedViewIDs = EMPTY_STRING_ARRAY;
    public Track myTrack;

    void clearViewInfo() {
        MTag[] view2 = this.layout.getChildTags();
        for (int i = 0; i < view2.length; ++i) {
            MTag tag2 = view2[i];
            tag2.setClientData("motionLayoutProperties", null);
        }
    }

    public HashMap<String, MotionAttributes> populateViewInfo(MTag constraintSet) {
        ArrayList ids = new ArrayList();
        HashMap<String, MotionAttributes> viewBundles = new HashMap<String, MotionAttributes>();
        HashMap<String, MotionAttributes> filledBundles = new HashMap<String, MotionAttributes>();
        ArrayList<MTag> csetChain = new ArrayList<MTag>();
        MTag set = constraintSet;
        while (set != null) {
            csetChain.add(set);
            set = this.getDerivedFrom(set);
        }
        MTag[] view2 = this.layout.getChildTags();
        HashMap<String, MTag> viewMap = new HashMap<String, MTag>();
        for (int i = 0; i < view2.length; ++i) {
            String id2 = view2[i].getAttributeValue("id");
            if (id2 == null) continue;
            id2 = Utils.stripID(id2);
            viewMap.put(id2, view2[i]);
            viewBundles.put(id2, new MotionAttributes(id2, constraintSet));
        }
        for (MTag cset : csetChain) {
            String constraintSetId = Utils.stripID(cset.getAttributeValue("id"));
            MTag[] constraint = cset.getChildTags();
            for (int i = 0; i < constraint.length; ++i) {
                int j;
                MotionAttributes bundle;
                String id3 = constraint[i].getAttributeValue("id");
                if (id3 == null || (bundle = (MotionAttributes)viewBundles.get(id3 = Utils.stripID(id3))) == null) continue;
                MTag[] subTags = constraint[i].getChildTags();
                HashMap<String, MTag.Attribute> attr2 = constraint[i].getAttrList();
                boolean allCustom = true;
                for (j = 0; j < subTags.length; ++j) {
                    if (subTags[j].getTagName().equals("CustomAttribute")) continue;
                    allCustom = false;
                    break;
                }
                if ((subTags.length == 0 || allCustom) && attr2.size() > 1) {
                    bundle.loadAttrs(MotionAttributes.Section.ALL, constraintSetId, attr2);
                    bundle.consume(true, true, true, true);
                    for (j = 0; j < subTags.length; ++j) {
                        MTag subTag = subTags[j];
                        bundle.addCustomAttrs(constraintSetId, subTag);
                    }
                    viewBundles.remove(id3);
                    filledBundles.put(id3, bundle);
                }
                block20: for (j = 0; j < subTags.length; ++j) {
                    String tagType;
                    switch (tagType = subTags[j].getTagName()) {
                        case "Motion": {
                            bundle.loadAttrs(MotionAttributes.Section.MOTION, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "Transform": {
                            bundle.loadAttrs(MotionAttributes.Section.TRANSFORM, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "PropertySet": {
                            bundle.loadAttrs(MotionAttributes.Section.PROPERTY_SET, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "Layout": {
                            bundle.loadAttrs(MotionAttributes.Section.LAYOUT, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "CustomAttribute": {
                            bundle.addCustomAttrs(constraintSetId, subTags[j]);
                            continue block20;
                        }
                        default: {
                            Debug.log("Unknown TAG! " + tagType);
                        }
                    }
                }
                if (!bundle.allFilled()) continue;
                viewBundles.remove(id3);
                filledBundles.put(id3, bundle);
            }
        }
        for (String id2 : new ArrayList(viewBundles.keySet())) {
            MotionAttributes bundle = (MotionAttributes)viewBundles.get(id2);
            MTag viewTag = (MTag)viewMap.get(id2);
            bundle.loadViewAttrs(viewTag);
            viewBundles.remove(id2);
            filledBundles.put(id2, bundle);
        }
        return filledBundles;
    }

    MTag getConstraint(MTag constraintSet, String stripedId) {
        MTag[] constraint = constraintSet.getChildTags("Constraint");
        for (int i = 0; i < constraint.length; ++i) {
            String str = Utils.stripID(constraint[i].getAttributeValue("id"));
            if (!stripedId.equals(str)) continue;
            return constraint[i];
        }
        return null;
    }

    MTag getDerivedFrom(MTag cset) {
        String s = cset.getAttributeValue("deriveConstraintsFrom");
        if (s == null) {
            return null;
        }
        s = Utils.stripID(s);
        MTag[] constraintSets = this.motionScene.getChildTags("ConstraintSet");
        for (int i = 0; i < constraintSets.length; ++i) {
            String str = Utils.stripID(constraintSets[i].getAttributeValue("id"));
            if (!s.equals(str)) continue;
            return constraintSets[i];
        }
        return null;
    }

    public MeModel(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName, Track track) {
        this.layout = layout2;
        this.motionScene = motionScene;
        this.layoutFileName = layoutFileName;
        this.motionSceneFileName = motionSceneFileName;
        this.myTrack = track;
    }

    public MeModel(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName) {
        this.layout = layout2;
        this.motionScene = motionScene;
        this.layoutFileName = layoutFileName;
        this.motionSceneFileName = motionSceneFileName;
    }

    public MTag getConstraintSet(String id2) {
        MTag[] sets = this.motionScene.getChildTags("ConstraintSet", "id", id2 = Utils.stripID(id2));
        if (sets.length == 1) {
            return sets[0];
        }
        return null;
    }

    public void setSelected(MotionEditorSelector.Type type, MTag[] tags) {
        if (type == MotionEditorSelector.Type.CONSTRAINT_SET) {
            MTag[] views;
            MTag[] constraints = tags[0].getChildTags();
            HashMap<String, MTag> constraintMap = new HashMap<String, MTag>();
            for (int i = 0; i < constraints.length; ++i) {
                MTag constraint = constraints[i];
                String id2 = constraint.getAttributeValue("id");
                if (id2 == null) continue;
                constraintMap.put(Utils.stripID(id2), constraint);
            }
            HashMap<String, MotionAttributes> motionAttributeSet = this.populateViewInfo(tags[0]);
            for (MTag view2 : views = this.layout.getChildTags()) {
                String id3 = view2.getAttributeValue("id");
                if (id3 == null) continue;
                id3 = Utils.stripID(id3);
                view2.setClientData("motionLayoutProperties", motionAttributeSet.get(id3));
                view2.setClientData("MotionTagForMotionScene", constraintMap.get(id3));
            }
        } else if (type == MotionEditorSelector.Type.LAYOUT) {
            this.clearViewInfo();
        }
        this.mSelectedType = type;
        this.mSelected = tags;
    }

    public MotionEditorSelector.Type getSelectedType() {
        return this.mSelectedType;
    }

    public MTag[] getSelected() {
        return this.mSelected;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
    }

    public float getCurrentProgress() {
        return this.mProgress;
    }

    public String[] getLayoutViewNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.layout == null) {
            return EMPTY_STRING_ARRAY;
        }
        MTag[] allViews = this.layout.getChildTags();
        for (int j = 0; j < allViews.length; ++j) {
            String[] row = new String[3];
            MTag view2 = allViews[j];
            String layoutId = Utils.stripID(view2.getAttributeValue("id"));
            ret.add(layoutId);
        }
        return ret.toArray(EMPTY_STRING_ARRAY);
    }

    public MTag findStartConstraintSet(MTag transitionOrChild) {
        MTag transition2 = transitionOrChild;
        while (!"Transition".equals(transition2.getTagName())) {
            if ((transition2 = transition2.getParent()) != null) continue;
            return null;
        }
        String start = transition2.getAttributeValue("constraintSetStart");
        return this.getConstraintSet(start);
    }

    public MTag findEndConstraintSet(MTag transitionOrChild) {
        MTag transition2 = transitionOrChild;
        while (!"Transition".equals(transition2.getTagName())) {
            if ((transition2 = transition2.getParent()) != null) continue;
            return null;
        }
        String end = transition2.getAttributeValue("constraintSetEnd");
        return this.getConstraintSet(end);
    }

    public void findStartAndEndValues(MTag layout2, String attribute, MTag mTag, String[] values2) {
        MTag transition2 = mTag.getParent().getParent();
        String target = mTag.getAttributeValue("motionTarget");
        String start = transition2.getAttributeValue("constraintSetStart");
        String end = transition2.getAttributeValue("constraintSetEnd");
        MTag startSet = this.getConstraintSet(start);
        String startValue = this.findAttribute(layout2, startSet, target, attribute);
        if (startValue == null) {
            values2[0] = this.defaultValueForAttribute(attribute);
        }
        MTag endSet = this.getConstraintSet(end);
        String endValue = this.findAttribute(layout2, startSet, target, attribute);
        if (endValue == null) {
            values2[1] = this.defaultValueForAttribute(attribute);
        }
    }

    private String defaultValueForAttribute(String attribute) {
        switch (attribute) {
            case "elevation": {
                return "0";
            }
            case "rotation": {
                return "0";
            }
            case "rotationX": {
                return "0";
            }
            case "rotationY": {
                return "0";
            }
            case "scaleX": {
                return "1";
            }
            case "scaleY": {
                return "1";
            }
            case "translationX": {
                return "0";
            }
            case "translationY": {
                return "0";
            }
            case "translationZ": {
                return "0";
            }
            case "transitionPathRotate": {
                return "0";
            }
            case "alpha": {
                return "1";
            }
            case "motionProgress": {
                return "0";
            }
        }
        return null;
    }

    String findAttribute(MTag layout2, MTag cSet, String id2, String attribute) {
        if (cSet != null) {
            MTag[] derivedTag;
            String value2;
            MTag[] constraints = cSet.getChildTags("id", id2);
            if (constraints != null && constraints.length > 0 && (value2 = constraints[0].getAttributeValue(attribute)) != null) {
                return value2;
            }
            String derivedStr = cSet.getAttributeValue("deriveConstraintsFrom");
            if (derivedStr != null && (derivedTag = cSet.getParent().getChildTags("ConstraintSet", "id", derivedStr)) != null && derivedTag.length > 0) {
                return this.findAttribute(layout2, derivedTag[0], id2, attribute);
            }
        }
        if (layout2 == null) {
            return null;
        }
        MTag[] view2 = layout2.getChildTags("id", id2);
        if (view2 == null || view2.length == 0) {
            return null;
        }
        return view2[0].getAttributeValue(attribute);
    }

    public MTag[] getViewNotInConstraintSet(MTag constraintSet) {
        HashSet<String> found = new HashSet<String>();
        MTag[] sets = constraintSet.getChildTags("Constraint");
        String derived = constraintSet.getAttributeValue("deriveConstraintsFrom");
        for (int i = 0; i < sets.length; ++i) {
            MTag constraint = sets[i];
            String id2 = Utils.stripID(constraint.getAttributeValue("id"));
            found.add(id2);
        }
        ArrayList<MTag> tags = new ArrayList<MTag>();
        MTag[] allViews = this.layout.getChildTags();
        for (int j = 0; j < allViews.length; ++j) {
            Object[] row = new Object[4];
            MTag view2 = allViews[j];
            String layoutId = view2.getAttributeValue("id");
            if (layoutId == null) {
                row[0] = view2.getTagName().substring(1 + view2.getTagName().lastIndexOf("/"));
                continue;
            }
            if (found.contains(layoutId = Utils.stripID(layoutId))) continue;
            tags.add(view2);
        }
        return tags.toArray(new MTag[0]);
    }

    public MTag findTag(String type, String id2) {
        if (this.mSelectedType == null || id2 == null) {
            return null;
        }
        if (this.mSelected == null || this.mSelected.length == 0) {
            return null;
        }
        MTag tag2 = this.mSelected[0];
        switch (this.mSelectedType) {
            case TRANSITION: 
            case KEY_FRAME_GROUP: {
                break;
            }
            case CONSTRAINT: {
                tag2 = tag2.getParent();
            }
            case CONSTRAINT_SET: {
                MTag[] look = tag2.getChildTags("id", id2);
                if (look != null && look.length > 0) {
                    return look[0];
                }
                MTag[] layoutView = this.layout.getChildTags();
                for (int i = 0; i < layoutView.length; ++i) {
                    MTag mTag = layoutView[i];
                    String viewId = Utils.stripID(mTag.getAttributeValue("id"));
                    if (viewId == null || !id2.equals(viewId)) continue;
                    return mTag;
                }
                break;
            }
        }
        return null;
    }

    public void setSelectedViewIDs(List<String> ids) {
        this.mSelectedViewIDs = ids.toArray(EMPTY_STRING_ARRAY);
    }

    public void setSelectedViewIDs(String[] ids) {
        this.mSelectedViewIDs = ids;
    }

    public String[] getSelectedViewIDs() {
        return this.mSelectedViewIDs;
    }
}

