/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.AndroidXConstants;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionSelection {
    private final MotionEditorSelector.Type myType;
    private final MTag[] myTags;
    private final MTag[] myConstraintSetTags;
    private final List<? extends NlComponent> myComponents;

    public MotionSelection(@NotNull MotionEditorSelector.Type type, @NotNull MTag[] tags, @NotNull List<? extends NlComponent> components) {
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(0);
        }
        if (components == null) {
            MotionSelection.$$$reportNull$$$0(1);
        }
        if (tags == null) {
            MotionSelection.$$$reportNull$$$0(2);
        }
        this.myType = type;
        this.myTags = tags;
        this.myConstraintSetTags = MotionSelection.computeConstraintSetTags(type, tags);
        this.myComponents = components;
    }

    @Nullable
    private static MTag[] computeConstraintSetTags(@NotNull MotionEditorSelector.Type type, @NotNull MTag[] tags) {
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(3);
        }
        if (tags == null) {
            MotionSelection.$$$reportNull$$$0(4);
        }
        if (type != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MTag[] constraintSets = new MTag[tags.length];
        for (int index = 0; index < tags.length; ++index) {
            MTag tag2 = tags[index];
            MTag constraintSet = null;
            if (tag2 instanceof NlComponentTag) {
                MotionAttributes attributes = MotionSceneUtils.getAttributes(((NlComponentTag)tag2).getComponent());
                if (attributes != null) {
                    constraintSet = attributes.getConstraintSet();
                }
            } else {
                constraintSet = tag2.getParent();
            }
            constraintSets[index] = constraintSet;
        }
        return constraintSets;
    }

    public boolean sameSelection(@NotNull MotionSelection other) {
        if (other == null) {
            MotionSelection.$$$reportNull$$$0(5);
        }
        return this.myType == other.myType && this.myComponents.equals(other.myComponents) && MotionSelection.isSameTreeIdHierarchy(this.myTags, other.myTags) && MotionSelection.isSameTreeIdHierarchy(this.myConstraintSetTags, other.myConstraintSetTags);
    }

    private static boolean isSameTreeIdHierarchy(@Nullable MTag[] tags, @Nullable MTag[] otherTags) {
        if (tags == null || otherTags == null) {
            return tags == null && otherTags == null;
        }
        if (tags.length != otherTags.length) {
            return false;
        }
        if (Arrays.equals(tags, otherTags)) {
            return true;
        }
        for (int index = 0; index < tags.length; ++index) {
            if (MotionSelection.isSameTreeIdHierarchy(tags[index], otherTags[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameTreeIdHierarchy(@Nullable MTag tag2, @Nullable MTag other) {
        if (tag2 == null || other == null) {
            return tag2 == null && other == null;
        }
        if (tag2 == other) {
            return true;
        }
        return tag2.isSameTreeIdHierarchy(other);
    }

    public void update(@NotNull MotionSelection newSelection) {
        if (newSelection == null) {
            MotionSelection.$$$reportNull$$$0(6);
        }
        System.arraycopy(newSelection.myTags, 0, this.myTags, 0, this.myTags.length);
    }

    @NotNull
    public MotionEditorSelector.Type getType() {
        MotionEditorSelector.Type type = this.myType;
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(7);
        }
        return type;
    }

    @NotNull
    public MTag[] getTags() {
        if (this.myTags == null) {
            MotionSelection.$$$reportNull$$$0(8);
        }
        return this.myTags;
    }

    @NotNull
    public List<? extends NlComponent> getComponents() {
        List<? extends NlComponent> list = this.myComponents;
        if (list == null) {
            MotionSelection.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public MotionSceneTag getMotionSceneTag() {
        if (this.myTags.length == 0) {
            return null;
        }
        MTag firstTag = this.myTags[0];
        if (!(firstTag instanceof MotionSceneTag)) {
            return null;
        }
        return (MotionSceneTag)firstTag;
    }

    @Nullable
    private NlComponentTag getNlComponentTag() {
        if (this.myTags.length == 0) {
            return null;
        }
        MTag firstTag = this.myTags[0];
        if (!(firstTag instanceof NlComponentTag)) {
            return null;
        }
        return (NlComponentTag)firstTag;
    }

    @Nullable
    public String getMotionSceneTagName() {
        MotionSceneTag tag2 = this.getMotionSceneTag();
        return tag2 != null ? tag2.getTagName() : null;
    }

    @Nullable
    public XmlTag getXmlTag(@Nullable MotionSceneTag tag2) {
        return tag2 != null ? tag2.getXmlTag() : null;
    }

    @Nullable
    public PsiFile getSceneFile() {
        MotionSceneTag tag2 = this.getMotionSceneTag();
        XmlTag xml2 = this.getXmlTag(tag2);
        if (xml2 != null) {
            return xml2.getContainingFile();
        }
        return null;
    }

    @Nullable
    public MotionAttributes getMotionAttributes() {
        NlComponent component2 = this.getComponent();
        return component2 != null ? MotionSceneUtils.getAttributes(component2) : null;
    }

    @Nullable
    public Icon getComponentIcon() {
        NlComponent component2 = this.getComponent();
        if (component2 == null) {
            return null;
        }
        NlComponent.XmlModelComponentMixin mixin = component2.getMixin();
        return mixin != null ? mixin.getIcon() : null;
    }

    @Nullable
    public String getComponentId() {
        NlComponent component2 = this.getComponent();
        if (component2 == null) {
            return null;
        }
        return component2.getAttribute("http://schemas.android.com/apk/res/android", "id");
    }

    @Nullable
    public String getConstraintSetId() {
        if (this.myType != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MotionSceneTag tag2 = this.getMotionSceneTag();
        MTag parent = null;
        if (tag2 != null) {
            parent = tag2.getParent();
        } else {
            MotionAttributes attrs = this.getMotionAttributes();
            if (attrs != null) {
                parent = attrs.getConstraintSet();
            }
        }
        return parent != null ? parent.getAttributeValue("id") : null;
    }

    @Nullable
    public NlComponent getComponent() {
        NlComponentTag componentTag = this.getNlComponentTag();
        if (componentTag != null) {
            return componentTag.getComponent();
        }
        MotionSceneTag motionTag = this.getMotionSceneTag();
        if (motionTag == null || !Objects.equals(motionTag.getTagName(), "Constraint")) {
            return null;
        }
        return this.getComponentFromConstraintTag(motionTag);
    }

    @Nullable
    public NlComponent getComponentForCustomAttributeCompletions() {
        NlComponentTag componentTag = this.getNlComponentTag();
        if (componentTag != null) {
            return componentTag.getComponent();
        }
        MotionSceneTag motionTag = this.getMotionSceneTag();
        if (motionTag == null || motionTag.getTagName() == null) {
            return null;
        }
        switch (motionTag.getTagName()) {
            case "Constraint": {
                return this.getComponentFromConstraintTag(motionTag);
            }
            case "KeyAttribute": 
            case "KeyCycle": 
            case "KeyTimeCycle": {
                return this.getComponentFromKeyWithArbitraryBackup(motionTag);
            }
        }
        return null;
    }

    @Nullable
    private NlComponent getComponentFromConstraintTag(@NotNull MTag constraintTag) {
        String constraintId;
        if (constraintTag == null) {
            MotionSelection.$$$reportNull$$$0(10);
        }
        if ((constraintId = MotionSelection.parseId(constraintTag.getAttributeValue("id"))) == null) {
            return null;
        }
        return this.getViewById(constraintId);
    }

    @Nullable
    private NlComponent getViewById(@NotNull String id2) {
        NlComponent motionLayout;
        if (id2 == null) {
            MotionSelection.$$$reportNull$$$0(11);
        }
        if ((motionLayout = this.getMotionLayoutComponent()) == null) {
            return null;
        }
        return motionLayout.getChildren().stream().filter(view2 -> id2.equals(view2.getId())).findFirst().orElse(null);
    }

    @Nullable
    private NlComponent getMotionLayoutComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        NlComponent motionLayout = this.myComponents.get(0);
        if (!AndroidXConstants.MOTION_LAYOUT.isEquals(motionLayout.getTagName())) {
            motionLayout = motionLayout.getParent();
        }
        if (motionLayout == null || !AndroidXConstants.MOTION_LAYOUT.isEquals(motionLayout.getTagName())) {
            return null;
        }
        return motionLayout;
    }

    private NlComponent getComponentFromKeyWithArbitraryBackup(@NotNull MotionSceneTag keyTag) {
        if (keyTag == null) {
            MotionSelection.$$$reportNull$$$0(12);
        }
        if (this.myComponents.isEmpty()) {
            return null;
        }
        NlComponent component2 = this.getComponentFromKey(keyTag);
        return component2 != null ? component2 : this.myComponents.get(0);
    }

    private NlComponent getComponentFromKey(@NotNull MotionSceneTag keyTag) {
        String motionTarget;
        if (keyTag == null) {
            MotionSelection.$$$reportNull$$$0(13);
        }
        if ((motionTarget = keyTag.getAttributeValue("motionTarget")) == null) {
            return null;
        }
        String target = MotionSelection.parseId(motionTarget);
        if (target != null) {
            return this.getViewById(target);
        }
        NlComponent motionLayout = this.getMotionLayoutComponent();
        if (motionLayout == null) {
            return null;
        }
        return motionLayout.getChildren().stream().filter(component2 -> MotionSelection.matches(component2, motionTarget)).findFirst().orElse(null);
    }

    private static boolean matches(@NotNull NlComponent component2, @NotNull String motionTarget) {
        String tag2;
        if (component2 == null) {
            MotionSelection.$$$reportNull$$$0(14);
        }
        if (motionTarget == null) {
            MotionSelection.$$$reportNull$$$0(15);
        }
        return (tag2 = component2.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTag")) != null && tag2.matches(motionTarget);
    }

    @Nullable
    private static String parseId(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)value2);
        if (url == null || url.type != ResourceType.ID || url.name.isEmpty()) {
            return null;
        }
        return url.name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/MotionSelection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintTag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "motionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/MotionSelection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeConstraintSetTags";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sameSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromConstraintTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getViewById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromKeyWithArbitraryBackup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromKey";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

