/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.property.CustomAttributeType;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyType;
import com.android.tools.property.panel.api.TableLineModel;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NewCustomAttributePanel
extends DialogWrapper {
    private JTextField myAttributeNameEditor;
    private JTextField myInitialValueEditor;
    private JPanel myContentPanel;
    private ComboBox<CustomAttributeType> myDataType;
    private JCheckBox myAcceptAnyway;
    private JLabel myError;
    private MyTextFieldModel myNewAttributeNameModel;
    private MyTextFieldModel myInitialValueModel;
    private final MotionLayoutAttributesModel myPropertiesModel;
    private final MotionSelection mySelection;
    private final TableLineModel myLineModel;
    private final Supplier<CustomAttributeType> myTypeSupplier;
    private final DefaultComboBoxModel<CustomAttributeType> myModel;
    private final WindowFocusListener myWindowFocusListener;
    private NlPropertyItem myProperty;

    public NewCustomAttributePanel(@NotNull MotionLayoutAttributesModel propertiesModel, @NotNull MotionSelection selection, @NotNull TableLineModel lineModel) {
        if (propertiesModel == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(0);
        }
        if (selection == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(1);
        }
        if (lineModel == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(2);
        }
        super(propertiesModel.getProject(), false, DialogWrapper.IdeModalityType.MODELESS);
        this.myPropertiesModel = propertiesModel;
        this.mySelection = selection;
        this.myLineModel = lineModel;
        this.$$$setupUI$$$();
        this.myModel = new DefaultComboBoxModel();
        this.myTypeSupplier = () -> {
            Object selectedType = this.myDataType.getSelectedItem();
            if (selectedType instanceof CustomAttributeType) {
                return (CustomAttributeType)((Object)((Object)selectedType));
            }
            return CustomAttributeType.CUSTOM_STRING;
        };
        NlComponent component2 = selection.getComponentForCustomAttributeCompletions();
        if (component2 != null) {
            this.myNewAttributeNameModel.setEditingSupport(new AttributeNameEditingSupport(component2, this.myTypeSupplier));
        }
        Arrays.stream(CustomAttributeType.values()).forEach(type -> this.myModel.addElement((CustomAttributeType)((Object)type)));
        this.myModel.setSelectedItem((Object)CustomAttributeType.CUSTOM_STRING);
        this.myDataType.setModel(this.myModel);
        this.myDataType.setEditable(false);
        this.initValidations();
        this.init();
        this.myWindowFocusListener = new WindowFocusListener(){
            private boolean myActivated;

            @Override
            public void windowGainedFocus(WindowEvent event) {
                Runnable setActive = () -> {
                    if (NewCustomAttributePanel.this.getWindow().isFocused()) {
                        this.myActivated = true;
                    } else {
                        NewCustomAttributePanel.this.close(0);
                    }
                };
                JobScheduler.getScheduler().schedule(setActive, 1L, TimeUnit.SECONDS);
            }

            @Override
            public void windowLostFocus(WindowEvent event) {
                if (this.myActivated) {
                    NewCustomAttributePanel.this.close(0);
                }
            }
        };
        this.getWindow().addWindowFocusListener(this.myWindowFocusListener);
    }

    protected void dispose() {
        this.getWindow().removeWindowFocusListener(this.myWindowFocusListener);
        super.dispose();
    }

    @TestOnly
    public JTextField getAttributeNameEditor() {
        return this.myAttributeNameEditor;
    }

    @TestOnly
    public JTextField getInitialValueEditor() {
        return this.myInitialValueEditor;
    }

    @TestOnly
    public ComboBox<CustomAttributeType> getDataTypeComboBox() {
        return this.myDataType;
    }

    @TestOnly
    public JCheckBox getAcceptAnyway() {
        return this.myAcceptAnyway;
    }

    @TestOnly
    public JLabel getErrorLabel() {
        return this.myError;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDataType;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    protected ActionListener createCancelAction() {
        ActionListener actionListener = e -> this.doCancelAction(e);
        if (actionListener == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(4);
        }
        return actionListener;
    }

    protected void doOKAction() {
        String attributeName = this.getAttributeName();
        String value2 = this.getInitialValue();
        CustomAttributeType type = this.getType();
        this.myPropertiesModel.addCustomProperty(attributeName, value2, type, this.mySelection, this.myLineModel);
        super.doOKAction();
    }

    @NotNull
    public String getAttributeName() {
        String string2 = this.myAttributeNameEditor.getText();
        if (string2 == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public CustomAttributeType getType() {
        CustomAttributeType customAttributeType = this.myTypeSupplier.get();
        if (customAttributeType == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(6);
        }
        return customAttributeType;
    }

    @NotNull
    public String getInitialValue() {
        String string2 = this.myInitialValueEditor.getText();
        if (string2 == null) {
            NewCustomAttributePanel.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private void initValidations() {
        this.myDataType.addActionListener(event -> this.updateAfterTypeChange());
        this.myAcceptAnyway.addActionListener(event -> this.updateErrorStatus());
        this.updateAfterTypeChange();
    }

    private void updateAfterTypeChange() {
        String typeTag = this.getType().getTagName();
        NlPropertyType propertyType = MotionLayoutPropertyProvider.mapFromCustomType(typeTag);
        if (this.myProperty == null || propertyType != this.myProperty.getType()) {
            this.myProperty = MotionLayoutPropertyProvider.createCustomProperty("property", typeTag, this.mySelection, this.myPropertiesModel);
            this.myInitialValueModel.setEditingSupport(this.myProperty.getEditingSupport());
        }
        this.myNewAttributeNameModel.updateNow();
        this.myInitialValueModel.updateNow();
        this.updateErrorStatus();
    }

    private void updateErrorStatus() {
        Pair<EditingErrorCategory, String> status = this.myNewAttributeNameModel.validate();
        if (status == EditingSupportKt.EDITOR_NO_ERROR) {
            status = this.myInitialValueModel.validate();
        }
        this.myAcceptAnyway.setVisible(status.getFirst() == EditingErrorCategory.ERROR);
        this.setOKActionEnabled(status.getFirst() != EditingErrorCategory.ERROR || this.myAcceptAnyway.isSelected() && !this.myNewAttributeNameModel.getText().isEmpty());
        switch ((EditingErrorCategory)status.getFirst()) {
            case ERROR: {
                this.myError.setVisible(true);
                this.myError.setText((String)status.getSecond());
                this.myError.setIcon(StudioIcons.Common.ERROR_INLINE);
                break;
            }
            case WARNING: {
                this.myError.setVisible(true);
                this.myError.setText((String)status.getSecond());
                this.myError.setIcon(StudioIcons.Common.WARNING_INLINE);
                break;
            }
            default: {
                this.myError.setVisible(false);
            }
        }
    }

    private void createUIComponents() {
        this.myNewAttributeNameModel = new MyTextFieldModel(this::updateErrorStatus);
        this.myAttributeNameEditor = new CommonTextField((CommonTextFieldModel)this.myNewAttributeNameModel);
        this.myInitialValueModel = new MyTextFieldModel(this::updateErrorStatus);
        this.myInitialValueEditor = new CommonTextField((CommonTextFieldModel)this.myInitialValueModel);
        this.myDataType = new ComboBox();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Attribute Name");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JTextField jTextField = this.myAttributeNameEditor;
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(300, -1), null));
        JTextField jTextField2 = this.myInitialValueEditor;
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(300, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Value");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAcceptAnyway = jCheckBox = new JCheckBox();
        jCheckBox.setAlignmentY(0.5f);
        jCheckBox.setMargin(new Insets(1, 1, 0, 1));
        jCheckBox.setText("Accept definition with errors");
        jCheckBox.setVerticalAlignment(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 5, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Data Type");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox<CustomAttributeType> comboBox = this.myDataType;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(300, -1), null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCancelAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }

    private static class MyTextFieldModel
    implements CommonTextFieldModel {
        private final List<ValueChangedListener> myListeners;
        private final Runnable myTextChanged;
        private String myText;
        private EditingSupport myEditingSupport;

        private MyTextFieldModel(@NotNull Runnable textChanged) {
            if (textChanged == null) {
                MyTextFieldModel.$$$reportNull$$$0(0);
            }
            this.myText = "";
            this.myListeners = new ArrayList<ValueChangedListener>();
            this.myEditingSupport = new DefaultEditingSupport();
            this.myTextChanged = textChanged;
        }

        private void setEditingSupport(final @NotNull EditingSupport editingSupport2) {
            if (editingSupport2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(1);
            }
            this.myEditingSupport = new DefaultEditingSupport(){

                @Override
                @NotNull
                public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
                    Function1 function1 = editingSupport2.getValidation();
                    if (function1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return function1;
                }

                @Override
                @NotNull
                public Function1<String, List<String>> getCompletion() {
                    Function1 function1 = editingSupport2.getCompletion();
                    if (function1 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return function1;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$MyTextFieldModel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getValidation";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getCompletion";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }

        private Pair<EditingErrorCategory, String> validate() {
            return (Pair)this.myEditingSupport.getValidation().invoke((Object)this.myText);
        }

        @NotNull
        public String getValue() {
            String string2 = this.myText;
            if (string2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(2);
            }
            return string2;
        }

        public boolean getEnabled() {
            return true;
        }

        public boolean getEditable() {
            return true;
        }

        @NotNull
        public String getPlaceHolderValue() {
            return "";
        }

        @NotNull
        public String getText() {
            String string2 = this.myText;
            if (string2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public void setText(@NotNull String text) {
            if (text == null) {
                MyTextFieldModel.$$$reportNull$$$0(4);
            }
            this.myText = text;
            this.myTextChanged.run();
        }

        public void updateNow() {
            this.myListeners.forEach(listener2 -> listener2.valueChanged());
        }

        @NotNull
        public EditingSupport getEditingSupport() {
            EditingSupport editingSupport2 = this.myEditingSupport;
            if (editingSupport2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(5);
            }
            return editingSupport2;
        }

        public void addListener(@NotNull ValueChangedListener listener2) {
            if (listener2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(6);
            }
            this.myListeners.add(listener2);
        }

        public void removeListener(@NotNull ValueChangedListener listener2) {
            if (listener2 == null) {
                MyTextFieldModel.$$$reportNull$$$0(7);
            }
            this.myListeners.remove(listener2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textChanged";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editingSupport";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$MyTextFieldModel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$MyTextFieldModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditingSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setEditingSupport";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeListener";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 5 -> new IllegalStateException(string2);
            };
        }
    }

    private static class AttributeNameEditingSupport
    implements EditingSupport {
        private final NlComponent myComponent;
        private final Supplier<CustomAttributeType> myType;
        private CustomAttributeType myLastLookupType;
        private Set<String> myLastLookup;
        private List<String> myCompletions;

        private AttributeNameEditingSupport(@NotNull NlComponent component2, @NotNull Supplier<CustomAttributeType> type) {
            if (component2 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(1);
            }
            this.myLastLookup = Collections.emptySet();
            this.myCompletions = Collections.emptyList();
            this.myComponent = component2;
            this.myType = type;
        }

        @NotNull
        public Function1<Runnable, Unit> getUiExecution() {
            Function1 function1 = runnable -> {
                runnable.run();
                return Unit.INSTANCE;
            };
            if (function1 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(2);
            }
            return function1;
        }

        @NotNull
        public Function1<Runnable, Future<?>> getExecution() {
            Function1 function1 = EditingSupportKt.EDITOR_IMMEDIATE_EXECUTION;
            if (function1 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(3);
            }
            return function1;
        }

        @NotNull
        public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
            Function1 function1 = value2 -> this.validate((String)value2);
            if (function1 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(4);
            }
            return function1;
        }

        @NotNull
        public Function1<String, List<String>> getCompletion() {
            Function1 function1 = forText -> this.getCompletions();
            if (function1 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(5);
            }
            return function1;
        }

        public boolean getAllowCustomValues() {
            return true;
        }

        private Pair<EditingErrorCategory, String> validate(@Nullable String value2) {
            if (value2 == null || value2.isEmpty()) {
                return new Pair((Object)EditingErrorCategory.ERROR, (Object)"Please supply an attribute name");
            }
            this.updateLookups();
            if (this.myLastLookup.contains(value2)) {
                return EditingSupportKt.EDITOR_NO_ERROR;
            }
            String message = "Method not found: " + AttributeNameEditingSupport.getMethodName(value2) + ";  check arguments";
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)message);
        }

        @NotNull
        private static String getMethodName(@NotNull String attributeName) {
            if (attributeName == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(6);
            }
            String string2 = "set" + StringUtil.capitalize((String)attributeName);
            if (string2 == null) {
                AttributeNameEditingSupport.$$$reportNull$$$0(7);
            }
            return string2;
        }

        private List<String> getCompletions() {
            this.updateLookups();
            return this.myCompletions;
        }

        private void updateLookups() {
            CustomAttributeType type = this.myType.get();
            if (type != this.myLastLookupType) {
                this.myLastLookup = MotionAttributes.getCustomAttributesFor(this.myComponent, type.getTagName());
                this.myLastLookupType = type;
                this.myCompletions = new ArrayList<String>(this.myLastLookup);
                this.myCompletions.sort(String::compareTo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$AttributeNameEditingSupport";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$AttributeNameEditingSupport";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiExecution";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecution";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletion";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getMethodName";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 4, 5, 7 -> new IllegalStateException(string2);
            };
        }
    }

    private static class DefaultEditingSupport
    implements EditingSupport {
        private DefaultEditingSupport() {
        }

        @NotNull
        public Function1<Runnable, Unit> getUiExecution() {
            Function1 function1 = runnable -> {
                runnable.run();
                return Unit.INSTANCE;
            };
            if (function1 == null) {
                DefaultEditingSupport.$$$reportNull$$$0(0);
            }
            return function1;
        }

        @NotNull
        public Function1<Runnable, Future<?>> getExecution() {
            Function1 function1 = EditingSupportKt.EDITOR_IMMEDIATE_EXECUTION;
            if (function1 == null) {
                DefaultEditingSupport.$$$reportNull$$$0(1);
            }
            return function1;
        }

        @NotNull
        public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
            Function1 function1 = value2 -> EditingSupportKt.EDITOR_NO_ERROR;
            if (function1 == null) {
                DefaultEditingSupport.$$$reportNull$$$0(2);
            }
            return function1;
        }

        @NotNull
        public Function1<String, List<String>> getCompletion() {
            Function1 function1 = forText -> Collections.emptyList();
            if (function1 == null) {
                DefaultEditingSupport.$$$reportNull$$$0(3);
            }
            return function1;
        }

        public boolean getAllowCustomValues() {
            return true;
        }

        public boolean getAlwaysRefreshCompletions() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/uibuilder/handlers/motion/property/NewCustomAttributePanel$DefaultEditingSupport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUiExecution";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecution";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletion";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

