/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.base.Strings;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreferenceHandler
extends ViewHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public abstract String getXml(@NotNull String var1, @NotNull XmlType var2);

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (newChild == null) {
            PreferenceHandler.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PreferenceHandler.$$$reportNull$$$0(1);
        }
        if (type.equals((Object)InsertType.CREATE)) {
            NlWriteCommandActionUtil.run(newChild, "Clearing Width and Height", () -> {
                newChild.removeAndroidAttribute("layout_width");
                newChild.removeAndroidAttribute("layout_height");
            });
        }
        return true;
    }

    @NotNull
    static String generateKey(@NotNull NlComponent component2, @NotNull String tagName, @NotNull String keyPrefix) {
        XmlTag preferenceScreen;
        if (component2 == null) {
            PreferenceHandler.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            PreferenceHandler.$$$reportNull$$$0(3);
        }
        if (keyPrefix == null) {
            PreferenceHandler.$$$reportNull$$$0(4);
        }
        if ((preferenceScreen = component2.getModel().getFile().getRootTag()) == null) {
            return "";
        }
        XmlTag[] preferences = preferenceScreen.findSubTags(tagName);
        int i = 1;
        String key = keyPrefix + i++;
        while (PreferenceHandler.anyPreferenceKeyEquals(preferences, key)) {
            key = keyPrefix + i++;
        }
        String string2 = key;
        if (string2 == null) {
            PreferenceHandler.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static boolean anyPreferenceKeyEquals(@NotNull XmlTag[] preferences, @NotNull String key) {
        if (key == null) {
            PreferenceHandler.$$$reportNull$$$0(6);
        }
        if (preferences == null) {
            PreferenceHandler.$$$reportNull$$$0(7);
        }
        return Arrays.stream(preferences).map(preference -> preference.getAttributeValue("key", "http://schemas.android.com/apk/res/android")).anyMatch(key::equals);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        if (component2 == null) {
            PreferenceHandler.$$$reportNull$$$0(8);
        }
        String string2 = Strings.nullToEmpty((String)component2.getAndroidAttribute("title"));
        if (string2 == null) {
            PreferenceHandler.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPrefix";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/preference/PreferenceHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateKey";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "anyPreferenceKeyEquals";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 9 -> new IllegalStateException(string2);
        };
    }
}

