/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.handlers.relative.targets.AlignAttributeRules;
import com.android.tools.idea.uibuilder.handlers.relative.targets.BaseRelativeTarget;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeDragTargetKt;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeUtilitiesKt;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J3\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDropHandler;", "", "myComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "(Lcom/android/tools/idea/common/scene/SceneComponent;)V", "hasHorizontalConstraint", "", "hasVerticalConstraint", "getMyComponent", "()Lcom/android/tools/idea/common/scene/SceneComponent;", "targetSnapper", "Lcom/android/tools/idea/uibuilder/scene/target/TargetSnapper;", "targetX", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/BaseRelativeTarget;", "targetY", "addHorizontalParentConstraints", "", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "x", "", "addVerticalParentConstraint", "y", "hideHighlightTargets", "isAutoConnectionEnabled", "preProcessAttribute", "Lcom/android/tools/idea/common/model/AttributesTransaction;", "processHorizontalAttributes", "processVerticalAttributes", "updateAlignAttributeIfNeed", "attributesToUpdate", "", "", "coordinateToUpdate", "rules", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "(Lcom/android/tools/idea/common/model/NlAttributesHolder;[Ljava/lang/String;ILcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;)V", "updateAttributes", "updateCurrentHorizontalConstraints", "updateVerticalConstraints", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nRelativeDragTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativeDragTarget.kt\ncom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDropHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,361:1\n10242#2:362\n10664#2,5:363\n12744#2,2:378\n1855#3,2:368\n1855#3,2:370\n1855#3,2:372\n1855#3,2:374\n1855#3,2:376\n*S KotlinDebug\n*F\n+ 1 RelativeDragTarget.kt\ncom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDropHandler\n*L\n119#1:362\n119#1:363,5\n293#1:378,2\n120#1:368,2\n189#1:370,2\n192#1:372,2\n198#1:374,2\n201#1:376,2\n*E\n"})
public final class RelativeDropHandler {
    @NotNull
    private final SceneComponent myComponent;
    @NotNull
    private final TargetSnapper targetSnapper;
    @Nullable
    private BaseRelativeTarget targetX;
    @Nullable
    private BaseRelativeTarget targetY;
    private boolean hasHorizontalConstraint;
    private boolean hasVerticalConstraint;

    public RelativeDropHandler(@NotNull SceneComponent myComponent) {
        Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
        this.myComponent = myComponent;
        this.targetSnapper = new TargetSnapper();
        this.hasHorizontalConstraint = RelativeDragTargetKt.access$hasHorizontalConstraint(this.myComponent);
        this.hasVerticalConstraint = RelativeDragTargetKt.access$hasVerticalConstraint(this.myComponent);
        AttributesTransaction attributesTransaction = this.myComponent.getAuthoritativeNlComponent().startAttributeTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)attributesTransaction, (String)"myComponent.authoritativ\u2026artAttributeTransaction()");
        this.preProcessAttribute(attributesTransaction);
        this.targetSnapper.reset();
        this.targetSnapper.gatherNotches(this.myComponent);
    }

    @NotNull
    public final SceneComponent getMyComponent() {
        return this.myComponent;
    }

    private final boolean isAutoConnectionEnabled() {
        return ToggleAutoConnectAction.Companion.isAutoconnectOn();
    }

    /*
     * WARNING - void declaration
     */
    private final void preProcessAttribute(AttributesTransaction attributes) {
        String margin = attributes.getAndroidAttribute("layout_margin");
        if (margin != null) {
            void $this$flatMapTo$iv$iv;
            String[] $this$flatMap$iv = RelativeDragTargetKt.access$getMARGINS_WITHOUT_RTL$p();
            boolean $i$f$flatMap = false;
            String[] stringArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = RelativeUtilitiesKt.getProperAttributesForLayout(this.myComponent, (String)it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                attributes.setAndroidAttribute(it, margin);
            }
        }
        AttributesTransaction $this$preProcessAttribute_u24lambda_u242 = attributes;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)$this$preProcessAttribute_u24lambda_u242.getAndroidAttribute("layout_centerInParent"), (Object)"true")) {
            $this$preProcessAttribute_u24lambda_u242.removeAndroidAttribute("layout_centerInParent");
            $this$preProcessAttribute_u24lambda_u242.setAndroidAttribute("layout_centerHorizontal", "true");
            $this$preProcessAttribute_u24lambda_u242.setAndroidAttribute("layout_centerVertical", "true");
        }
    }

    public final void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        int newX = this.processHorizontalAttributes(attributes, x);
        int newY = this.processVerticalAttributes(attributes, y);
        this.myComponent.setPosition(newX, newY);
    }

    public final void hideHighlightTargets() {
        BaseRelativeTarget baseRelativeTarget = this.targetX;
        if (baseRelativeTarget != null) {
            baseRelativeTarget.setMyIsHighlight(false);
        }
        BaseRelativeTarget baseRelativeTarget2 = this.targetY;
        if (baseRelativeTarget2 != null) {
            baseRelativeTarget2.setMyIsHighlight(false);
        }
    }

    private final int processHorizontalAttributes(NlAttributesHolder attributes, int x) {
        SceneComponent sceneComponent = this.myComponent.getParent();
        Intrinsics.checkNotNull((Object)sceneComponent);
        SceneComponent parent = sceneComponent;
        BaseRelativeTarget baseRelativeTarget = this.targetX;
        if (baseRelativeTarget != null) {
            baseRelativeTarget.setMyIsHighlight(false);
        }
        if (this.hasHorizontalConstraint) {
            this.updateCurrentHorizontalConstraints(attributes);
            return x;
        }
        RelativeDragTargetKt.access$clearHorizontalConstrains(attributes);
        attributes.removeAndroidAttribute("layout_centerHorizontal");
        int dx = Math.max(RelativeUtilitiesKt.getDrawLeft(parent), Math.min(x, RelativeUtilitiesKt.getDrawRight(parent) - this.myComponent.getDrawWidth()));
        if (!this.isAutoConnectionEnabled()) {
            return dx;
        }
        OptionalInt optionalInt = this.targetSnapper.trySnapHorizontal(dx);
        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"targetSnapper.trySnapHorizontal(dx)");
        OptionalInt snappedX = optionalInt;
        if (snappedX.isPresent()) {
            this.targetSnapper.applyNotches(attributes);
            BaseRelativeTarget baseRelativeTarget2 = this.targetX = (BaseRelativeTarget)this.targetSnapper.getSnappedHorizontalTarget();
            if (baseRelativeTarget2 != null) {
                baseRelativeTarget2.setMyIsHighlight(true);
            }
            this.targetSnapper.clearSnappedNotches();
            return snappedX.getAsInt();
        }
        this.addHorizontalParentConstraints(attributes, dx);
        return dx;
    }

    private final void addHorizontalParentConstraints(NlAttributesHolder attributes, int x) {
        SceneComponent sceneComponent = this.myComponent.getParent();
        Intrinsics.checkNotNull((Object)sceneComponent);
        SceneComponent parent = sceneComponent;
        if (x + this.myComponent.getDrawWidth() / 2 < RelativeUtilitiesKt.getDrawCenterX(parent)) {
            String it;
            Iterable $this$forEach$iv = RelativeUtilitiesKt.getProperAttributesForLayout(this.myComponent, "layout_alignParentLeft");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                attributes.setAndroidAttribute(it, "true");
            }
            $this$forEach$iv = RelativeUtilitiesKt.getProperAttributesForLayout(this.myComponent, "layout_marginLeft");
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                attributes.setAndroidAttribute(it, RelativeUtilitiesKt.toDpString(Math.max(x - RelativeUtilitiesKt.getDrawLeft(parent), 0)));
            }
        } else {
            String it;
            Iterable $this$forEach$iv = RelativeUtilitiesKt.getProperAttributesForLayout(this.myComponent, "layout_alignParentRight");
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                attributes.setAndroidAttribute(it, "true");
            }
            $this$forEach$iv = RelativeUtilitiesKt.getProperAttributesForLayout(this.myComponent, "layout_marginRight");
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                attributes.setAndroidAttribute(it, RelativeUtilitiesKt.toDpString(Math.max(RelativeUtilitiesKt.getDrawRight(parent) - (x + this.myComponent.getDrawWidth()), 0)));
            }
        }
    }

    private final void updateCurrentHorizontalConstraints(NlAttributesHolder attributes) {
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getLEFT_ALIGN_ATTRIBUTES(), RelativeUtilitiesKt.getDrawLeft(this.myComponent), RelativeUtilitiesKt.getLEFT_ATTRIBUTE_RULES());
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getRIGHT_ALIGN_ATTRIBUTES(), RelativeUtilitiesKt.getDrawRight(this.myComponent), RelativeUtilitiesKt.getRIGHT_ATTRIBUTE_RULES());
        boolean isRtl = this.myComponent.getScene().isInRTL();
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getSTART_ALIGN_ATTRIBUTES(), isRtl ? RelativeUtilitiesKt.getDrawRight(this.myComponent) : RelativeUtilitiesKt.getDrawLeft(this.myComponent), isRtl ? RelativeUtilitiesKt.getRTL_START_ATTRIBUTE_RULES() : RelativeUtilitiesKt.getSTART_ATTRIBUTE_RULES());
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getEND_ALIGN_ATTRIBUTES(), isRtl ? RelativeUtilitiesKt.getDrawLeft(this.myComponent) : RelativeUtilitiesKt.getDrawRight(this.myComponent), isRtl ? RelativeUtilitiesKt.getRTL_END_ATTRIBUTE_RULES() : RelativeUtilitiesKt.getEND_ATTRIBUTE_RULES());
    }

    private final int processVerticalAttributes(NlAttributesHolder attributes, int y) {
        SceneComponent sceneComponent = this.myComponent.getParent();
        Intrinsics.checkNotNull((Object)sceneComponent);
        SceneComponent parent = sceneComponent;
        BaseRelativeTarget baseRelativeTarget = this.targetY;
        if (baseRelativeTarget != null) {
            baseRelativeTarget.setMyIsHighlight(false);
        }
        if (this.hasVerticalConstraint) {
            this.updateVerticalConstraints(attributes);
            return y;
        }
        RelativeDragTargetKt.access$clearVerticalConstrains(attributes);
        attributes.removeAndroidAttribute("layout_centerVertical");
        int dy = Math.max(RelativeUtilitiesKt.getDrawTop(parent), Math.min(y, RelativeUtilitiesKt.getDrawBottom(parent) - this.myComponent.getDrawHeight()));
        if (!this.isAutoConnectionEnabled()) {
            return dy;
        }
        OptionalInt optionalInt = this.targetSnapper.trySnapVertical(dy);
        Intrinsics.checkNotNullExpressionValue((Object)optionalInt, (String)"targetSnapper.trySnapVertical(dy)");
        OptionalInt snappedY = optionalInt;
        if (snappedY.isPresent()) {
            this.targetSnapper.applyNotches(attributes);
            BaseRelativeTarget baseRelativeTarget2 = this.targetY = (BaseRelativeTarget)this.targetSnapper.getSnappedVerticalTarget();
            if (baseRelativeTarget2 != null) {
                baseRelativeTarget2.setMyIsHighlight(true);
            }
            this.targetSnapper.clearSnappedNotches();
            return snappedY.getAsInt();
        }
        this.addVerticalParentConstraint(attributes, dy);
        return dy;
    }

    private final void addVerticalParentConstraint(NlAttributesHolder attributes, int y) {
        SceneComponent sceneComponent = this.myComponent.getParent();
        Intrinsics.checkNotNull((Object)sceneComponent);
        SceneComponent parent = sceneComponent;
        if (y + this.myComponent.getDrawHeight() / 2 < RelativeUtilitiesKt.getDrawCenterY(parent)) {
            attributes.setAndroidAttribute("layout_alignParentTop", "true");
            attributes.setAndroidAttribute("layout_marginTop", RelativeUtilitiesKt.toDpString(Math.max(y - RelativeUtilitiesKt.getDrawTop(parent), 0)));
        } else {
            attributes.setAndroidAttribute("layout_alignParentBottom", "true");
            attributes.setAndroidAttribute("layout_marginBottom", RelativeUtilitiesKt.toDpString(Math.max(RelativeUtilitiesKt.getDrawBottom(parent) - (y + this.myComponent.getDrawHeight()), 0)));
        }
    }

    private final void updateVerticalConstraints(NlAttributesHolder attributes) {
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getTOP_ALIGN_ATTRIBUTES(), RelativeUtilitiesKt.getDrawTop(this.myComponent), RelativeUtilitiesKt.getTOP_ATTRIBUTE_RULES());
        this.updateAlignAttributeIfNeed(attributes, RelativeUtilitiesKt.getBOTTOM_ALIGN_ATTRIBUTES(), RelativeUtilitiesKt.getDrawBottom(this.myComponent), RelativeUtilitiesKt.getBOTTOM_ATTRIBUTE_RULES());
    }

    private final void updateAlignAttributeIfNeed(NlAttributesHolder attributes, String[] attributesToUpdate, int coordinateToUpdate, AlignAttributeRules rules) {
        boolean bl;
        block2: {
            String[] $this$any$iv = attributesToUpdate;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(attributes.getAndroidAttribute(it) != null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            RelativeUtilitiesKt.updateAlignAttribute(this.myComponent, attributes, coordinateToUpdate, rules);
        }
    }
}

