/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.lint;

import com.android.tools.idea.common.model.NlComponent;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"createDefaultHyperLinkListener", "Ljavax/swing/event/HyperlinkListener;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "intellij.android.designer"})
public final class LintUtilKt {
    @NotNull
    public static final HyperlinkListener createDefaultHyperLinkListener() {
        return LintUtilKt::createDefaultHyperLinkListener$lambda$0;
    }

    @Nullable
    public static final TextRange getTextRange(@NotNull NlComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        XmlTag xmlTag = component2.getTag();
        if (xmlTag != null) {
            ASTNode nameElement;
            XmlTag tag2 = xmlTag;
            boolean bl = false;
            ASTNode aSTNode = nameElement = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag2.getNode());
            return aSTNode != null ? aSTNode.getTextRange() : null;
        }
        return null;
    }

    private static final void createDefaultHyperLinkListener$lambda$0(HyperlinkEvent it) {
        String url = it.getDescription();
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                BrowserUtil.browse((String)url);
            }
            catch (Exception exception) {
                Project project = null;
                StringBuilder builder2 = new StringBuilder();
                builder2.append("Unable to open a default browser. \n");
                builder2.append("Please open a browser manually and goto the url.\n");
                try {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                    builder2.append("\"" + url + "\" has been copied to the clipboard.\n");
                }
                catch (Exception exception2) {
                    builder2.append("\"" + url + "\"");
                }
                Messages.showErrorDialog(project, (String)builder2.toString(), (String)"Error");
            }
        }
    }
}

