/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.AndroidXConstants;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0007\u001a\u0012\u0010\u000f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"CUSTOM_DENSITY_ID", "", "updateConfigurationScreenSize", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "xDimension", "", "yDimension", "original", "Lcom/android/sdklib/devices/Device;", "currentActivityIsDerivedFromAppCompatActivity", "", "Lcom/android/tools/idea/common/model/NlModel;", "moduleDependsOnAppCompat", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nNlModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlModelHelper.kt\ncom/android/tools/idea/uibuilder/model/NlModelHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n661#2,11:117\n661#2,11:128\n1549#2:139\n1620#2,3:140\n1855#2,2:143\n*S KotlinDebug\n*F\n+ 1 NlModelHelper.kt\ncom/android/tools/idea/uibuilder/model/NlModelHelperKt\n*L\n71#1:117,11\n72#1:128,11\n88#1:139\n88#1:140,3\n89#1:143,2\n*E\n"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension, @Nullable Device original) {
        State state;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (original == null) {
            return;
        }
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state2 : device.getAllStates()) {
            Screen screen = state2.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi2 = screen.getPixelDensity().getDpiValue();
            double width2 = (double)xDimension / dpi2;
            double height2 = (double)yDimension / dpi2;
            double diagonalLength = Math.hypot(width2, height2);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio((int)xDimension, (int)yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        if (xDimension > yDimension) {
            Object v1;
            block8: {
                List list = device.getAllStates();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"device.allStates");
                $this$singleOrNull$iv = list;
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    if (!(it.getOrientation() == ScreenOrientation.LANDSCAPE)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block8;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            state = v1;
        } else {
            Object v4;
            block9: {
                List list = device.getAllStates();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"device.allStates");
                $this$singleOrNull$iv = list;
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    if (!(it.getOrientation() == ScreenOrientation.PORTRAIT)) continue;
                    if (found$iv) {
                        v4 = null;
                        break block9;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            state = v4;
        }
        State newState = state;
        configuration.setEffectiveDevice(device, newState);
    }

    public static /* synthetic */ void updateConfigurationScreenSize$default(Configuration configuration, int n, int n2, Device device, int n3, Object object) {
        if ((n3 & 8) != 0) {
            device = configuration.getCachedDevice();
        }
        NlModelHelperKt.updateConfigurationScreenSize(configuration, n, n2, device);
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $this$overrideConfigurationDensity, @NotNull Density density) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$overrideConfigurationDensity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Device device = $this$overrideConfigurationDensity.getConfiguration().getCachedDevice();
        if (device == null) {
            return;
        }
        Device original = device;
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setTagId(original.getTagId());
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device2 = deviceBuilder.build();
        List list = device2.getAllStates();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"device.allStates");
        Iterable iterable = list;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHardware().getScreen());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Screen it = (Screen)element$iv;
            boolean bl = false;
            it.setPixelDensity(density);
        }
        $this$overrideConfigurationDensity.getConfiguration().setEffectiveDevice(device2, device2.getDefaultState());
    }

    @Deprecated(message="Use NlModel.module.dependsOnAppCompat()", replaceWith=@ReplaceWith(expression="com.android.tools.idea.util.dependsOnAppCompat()", imports={}))
    public static final boolean moduleDependsOnAppCompat(@NotNull NlModel $this$moduleDependsOnAppCompat) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleDependsOnAppCompat, (String)"<this>");
        Module module2 = $this$moduleDependsOnAppCompat.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
        return DependencyManagementUtil.dependsOnAppCompat((Module)module2);
    }

    public static final boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel $this$currentActivityIsDerivedFromAppCompatActivity) {
        PsiClass activityClass;
        Intrinsics.checkNotNullParameter((Object)$this$currentActivityIsDerivedFromAppCompatActivity, (String)"<this>");
        String string2 = $this$currentActivityIsDerivedFromAppCompatActivity.getConfiguration().getActivity();
        if (string2 == null) {
            return true;
        }
        Object activityClassName = string2;
        if (StringsKt.startsWith$default((String)activityClassName, (String)".", (boolean)false, (int)2, null)) {
            AndroidFacet androidFacet = $this$currentActivityIsDerivedFromAppCompatActivity.getFacet();
            Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"facet");
            String string3 = StringUtil.notNullize((String)ProjectSystemUtil.getModuleSystem((AndroidFacet)androidFacet).getPackageName());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"notNullize(facet.getModu\u2026ystem().getPackageName())");
            String pkg = string3;
            activityClassName = pkg + (String)activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$this$currentActivityIsDerivedFromAppCompatActivity.getProject());
        for (activityClass = facade.findClass((String)activityClassName, $this$currentActivityIsDerivedFromAppCompatActivity.getModule().getModuleScope()); activityClass != null && !AndroidXConstants.CLASS_APP_COMPAT_ACTIVITY.isEquals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }

    @JvmOverloads
    public static final void updateConfigurationScreenSize(@NotNull Configuration configuration, int xDimension, int yDimension) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        NlModelHelperKt.updateConfigurationScreenSize$default(configuration, xDimension, yDimension, null, 8, null);
    }
}

