/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.support.CachedEnumSupport;
import com.android.tools.idea.uibuilder.property.support.DerivedStyleFinder;
import com.android.tools.idea.uibuilder.property.support.StyleEnumSupport;
import com.android.tools.property.panel.api.EnumValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eH\u0004J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010 \u001a\n !*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010\"\u001a\u00020\u001cH\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010%\u001a\u00020\u001eH\u0002J&\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010'\u001a\u00020\u001e2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0)H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/uibuilder/property/support/StyleEnumSupport;", "Lcom/android/tools/idea/uibuilder/property/support/CachedEnumSupport;", "property", "Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "(Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;)V", "derivedStyles", "Lcom/android/tools/idea/uibuilder/property/support/DerivedStyleFinder;", "getDerivedStyles", "()Lcom/android/tools/idea/uibuilder/property/support/DerivedStyleFinder;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "lastResult", "", "Lcom/android/tools/property/panel/api/EnumValue;", "getProperty", "()Lcom/android/tools/idea/uibuilder/property/NlPropertyItem;", "resolver", "Lcom/android/ide/common/resources/ResourceResolver;", "getResolver", "()Lcom/android/ide/common/resources/ResourceResolver;", "values", "getValues", "()Ljava/util/List;", "cache", "convertStyles", "styles", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "determineHeaderFromLibraryName", "", "libraryName", "displayName", "kotlin.jvm.PlatformType", "style", "generate", "getWidgetBaseStyles", "tagName", "resolve", "qualifiedStyleName", "prefixMap", "", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nStyleEnumSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleEnumSupport.kt\ncom/android/tools/idea/uibuilder/property/support/StyleEnumSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1603#2,9:123\n1855#2:132\n1856#2:134\n1612#2:135\n1#3:133\n*S KotlinDebug\n*F\n+ 1 StyleEnumSupport.kt\ncom/android/tools/idea/uibuilder/property/support/StyleEnumSupport\n*L\n110#1:123,9\n110#1:132\n110#1:134\n110#1:135\n110#1:133\n*E\n"})
public class StyleEnumSupport
implements CachedEnumSupport {
    @NotNull
    private final NlPropertyItem property;
    @NotNull
    private final AndroidFacet facet;
    @Nullable
    private final ResourceResolver resolver;
    @NotNull
    private final DerivedStyleFinder derivedStyles;
    @Nullable
    private List<? extends EnumValue> lastResult;

    public StyleEnumSupport(@NotNull NlPropertyItem property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.property = property;
        this.facet = this.property.getModel().getFacet();
        this.resolver = this.property.getResolver();
        this.derivedStyles = new DerivedStyleFinder(this.facet, this.resolver);
    }

    @NotNull
    public final NlPropertyItem getProperty() {
        return this.property;
    }

    @NotNull
    protected final AndroidFacet getFacet() {
        return this.facet;
    }

    @Nullable
    protected final ResourceResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    protected final DerivedStyleFinder getDerivedStyles() {
        return this.derivedStyles;
    }

    @NotNull
    public List<EnumValue> getValues() {
        List<EnumValue> list = this.lastResult;
        if (list == null) {
            list = this.cache(this.generate());
        }
        return list;
    }

    private final List<EnumValue> cache(List<? extends EnumValue> values2) {
        this.lastResult = values2;
        return values2;
    }

    @NotNull
    protected List<EnumValue> generate() {
        String tagName = this.property.getTagName();
        if (((CharSequence)tagName).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List<StyleResourceValue> baseStyles = this.getWidgetBaseStyles(tagName);
        List<StyleResourceValue> styles2 = this.derivedStyles.find(baseStyles, (Function1<? super StyleResourceValue, Boolean>)((Function1)generate.styles.1.INSTANCE), (Function1)generate.styles.2.INSTANCE);
        return this.convertStyles(styles2);
    }

    protected String displayName(@NotNull StyleResourceValue style2) {
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        return style2.getName();
    }

    @NotNull
    protected final List<EnumValue> convertStyles(@NotNull List<? extends StyleResourceValue> styles2) {
        Intrinsics.checkNotNullParameter(styles2, (String)"styles");
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance((AndroidFacet)this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(facet)");
        StudioResourceRepositoryManager resourceManager = studioResourceRepositoryManager;
        ResourceNamespace resourceNamespace = resourceManager.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"resourceManager.namespace");
        ResourceNamespace currentNamespace = resourceNamespace;
        ResourceNamespace.Resolver namespaceResolver2 = this.property.getNamespaceResolver();
        StyleResourceValue prev = null;
        List result = new ArrayList();
        for (StyleResourceValue styleResourceValue : styles2) {
            String xmlValue;
            Intrinsics.checkNotNullExpressionValue((Object)styleResourceValue.asReference().getRelativeResourceUrl(currentNamespace, namespaceResolver2).toString(), (String)"style.asReference().getR\u2026spaceResolver).toString()");
            String string2 = this.displayName(styleResourceValue);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"displayName(style)");
            EnumValue value2 = EnumValue.Companion.indented(xmlValue, string2);
            if (prev != null && Intrinsics.areEqual((Object)styleResourceValue.getNamespace(), (Object)prev.getNamespace()) && Intrinsics.areEqual((Object)styleResourceValue.getLibraryName(), (Object)prev.getLibraryName())) {
                result.add(value2);
            } else {
                String string3;
                ResourceNamespace resourceNamespace2 = styleResourceValue.getNamespace();
                if (Intrinsics.areEqual((Object)resourceNamespace2, (Object)ResourceNamespace.ANDROID)) {
                    string3 = "Android";
                } else if (Intrinsics.areEqual((Object)resourceNamespace2, (Object)ResourceNamespace.TODO())) {
                    string3 = this.determineHeaderFromLibraryName(styleResourceValue.getLibraryName());
                } else {
                    String string4 = styleResourceValue.getNamespace().getPackageName();
                    if (string4 == null) {
                        string4 = "Other";
                    }
                    String string5 = StringUtil.getShortName((String)string4, (char)'.');
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getShortName(style.names\u2026ame ?: OTHER_HEADER, '.')");
                }
                String header = string3;
                result.add(EnumValue.Companion.header(header));
                result.add(value2);
            }
            prev = styleResourceValue;
        }
        return result;
    }

    private final String determineHeaderFromLibraryName(String libraryName) {
        CharSequence charSequence = libraryName;
        return charSequence == null || charSequence.length() == 0 ? "Project" : (StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"appcompat", (boolean)false, (int)2, null) ? "AppCompat" : "Library");
    }

    /*
     * WARNING - void declaration
     */
    private final List<StyleResourceValue> getWidgetBaseStyles(String tagName) {
        void $this$mapNotNullTo$iv$iv;
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(this.facet);
        Intrinsics.checkNotNullExpressionValue((Object)viewHandlerManager, (String)"get(facet)");
        ViewHandlerManager manager = viewHandlerManager;
        ViewHandler viewHandler = manager.getHandler(tagName);
        if (viewHandler == null) {
            return CollectionsKt.emptyList();
        }
        ViewHandler handler = viewHandler;
        List<String> list = handler.getBaseStyles(tagName);
        Intrinsics.checkNotNullExpressionValue(list, (String)"handler.getBaseStyles(tagName)");
        List<String> possibleNames = list;
        Map<String, String> map2 = handler.getPrefixToNamespaceMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"handler.prefixToNamespaceMap");
        Map<String, String> prefixMap = map2;
        Iterable $this$mapNotNull$iv = possibleNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            StyleResourceValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.resolve(it, prefixMap) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StyleResourceValue resolve(String qualifiedStyleName, Map<String, String> prefixMap) {
        if (this.resolver == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parseStyleParentReference((String)qualifiedStyleName);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        ResourceReference resourceReference = url.resolve(ResourceNamespace.ANDROID, arg_0 -> StyleEnumSupport.resolve$lambda$1(prefixMap, arg_0));
        if (resourceReference == null) {
            return null;
        }
        ResourceReference reference = resourceReference;
        return this.resolver.getStyle(reference);
    }

    private static final String resolve$lambda$1(Map $prefixMap, String it) {
        Intrinsics.checkNotNullParameter((Object)$prefixMap, (String)"$prefixMap");
        return (String)$prefixMap.get(it);
    }
}

