/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Graphics2D;

public class DrawResize
extends DrawRegion {
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    public static final int SIZE = JBUIScale.scale((int)8);
    int myMode;

    public DrawResize(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
    }

    public DrawResize(int x, int y, int mode) {
        super(x - SIZE / 2, y - SIZE / 2, SIZE, SIZE);
        this.myMode = mode;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getSelectedFrames();
        Color borderColor = colorSet.getComponentObligatoryBackground();
        g.setColor(background);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setColor(borderColor);
        g.drawRect(this.x, this.y, this.width, this.height);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, int mode) {
        int l = transform.getSwingXDip(left);
        int t = transform.getSwingYDip(top);
        list.add(new DrawResize(l, t, mode));
    }
}

