/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalNotch;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalNotch;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notch {
    protected static final int DEFAULT_GAP = 8;
    static final int TYPE_HORIZONTAL = 1;
    static final int TYPE_VERTICAL = 2;
    static final int TYPE_CIRCLE = 4;
    @NotNull
    protected SceneComponent myOwner;
    protected int myType;
    protected int myGap;
    @Nullable
    Action myAction;
    @Nullable
    Target myTarget;

    protected Notch(@NotNull SceneComponent owner, int type, @Nullable Action action2) {
        if (owner == null) {
            Notch.$$$reportNull$$$0(0);
        }
        this.myGap = 8;
        this.myOwner = owner;
        this.myType = type;
        this.myAction = action2;
    }

    public void setGap(int gap) {
        this.myGap = gap;
    }

    public void setAction(@Nullable Action action2) {
        this.myAction = action2;
    }

    public void applyAction(@NotNull NlAttributesHolder attributes) {
        if (attributes == null) {
            Notch.$$$reportNull$$$0(1);
        }
        if (this.myAction != null) {
            this.myAction.apply(attributes);
        }
    }

    abstract boolean isSnappable(int var1, int var2, @NotNull Point var3);

    public final int getType() {
        return this.myType;
    }

    public final void setTarget(@Nullable Target target) {
        this.myTarget = target;
    }

    @Nullable
    public final Target getTarget() {
        return this.myTarget;
    }

    public abstract void render(@NotNull DisplayList var1, @NotNull SceneContext var2, @NotNull SceneComponent var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Action {
        public void apply(@NotNull NlAttributesHolder var1);
    }

    public static class SmallVertical
    extends Vertical {
        public SmallVertical(@NotNull SceneComponent owner, int valueY, int displayValueY) {
            if (owner == null) {
                SmallVertical.$$$reportNull$$$0(0);
            }
            super(owner, valueY, displayValueY, null);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            if (list == null) {
                SmallVertical.$$$reportNull$$$0(1);
            }
            if (context == null) {
                SmallVertical.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                SmallVertical.$$$reportNull$$$0(3);
            }
            int gap = 16;
            int x1 = Math.min(this.myOwner.getDrawX(), component2.getDrawX()) - gap;
            int x2 = Math.max(this.myOwner.getDrawX() + this.myOwner.getDrawWidth(), component2.getDrawX() + component2.getDrawWidth()) + gap;
            DrawHorizontalNotch.add(list, context, x1, this.myDisplayValueY, x2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch$SmallVertical";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SmallHorizontal
    extends Horizontal {
        public SmallHorizontal(@NotNull SceneComponent owner, int valueX, int displayValueX) {
            if (owner == null) {
                SmallHorizontal.$$$reportNull$$$0(0);
            }
            super(owner, valueX, displayValueX, null);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            if (list == null) {
                SmallHorizontal.$$$reportNull$$$0(1);
            }
            if (context == null) {
                SmallHorizontal.$$$reportNull$$$0(2);
            }
            if (component2 == null) {
                SmallHorizontal.$$$reportNull$$$0(3);
            }
            int gap = 16;
            int y1 = Math.min(this.myOwner.getDrawY(), component2.getDrawY()) - gap;
            int y2 = Math.max(this.myOwner.getDrawY() + this.myOwner.getDrawHeight(), component2.getDrawY() + component2.getDrawHeight()) + gap;
            DrawVerticalNotch.add(list, context, this.myDisplayValueX, y1, y2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch$SmallHorizontal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Circle
    extends Notch {
        private int myValueX;
        private int myValueY;

        public Circle(@NotNull SceneComponent owner, int valueX, int valueY) {
            if (owner == null) {
                Circle.$$$reportNull$$$0(0);
            }
            this(owner, valueX, valueY, null);
        }

        public Circle(@NotNull SceneComponent owner, int valueX, int valueY, @Nullable Action action2) {
            if (owner == null) {
                Circle.$$$reportNull$$$0(1);
            }
            super(owner, 4, action2);
            this.myValueX = valueX;
            this.myValueY = valueY;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            int dy;
            int dx;
            if (retPoint == null) {
                Circle.$$$reportNull$$$0(2);
            }
            if ((dx = valueX - this.myValueX) * dx + (dy = valueY - this.myValueY) * dy <= this.myGap * this.myGap) {
                retPoint.x = this.myValueX;
                retPoint.y = this.myValueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            if (list == null) {
                Circle.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Circle.$$$reportNull$$$0(4);
            }
            if (component2 == null) {
                Circle.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "retPoint";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch$Circle";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSnappable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Vertical
    extends Notch {
        protected int myValueY;
        protected int myDisplayValueY;

        public Vertical(@NotNull SceneComponent owner, int valueY, int displayValueY) {
            if (owner == null) {
                Vertical.$$$reportNull$$$0(0);
            }
            this(owner, valueY, displayValueY, null);
        }

        public Vertical(@NotNull SceneComponent owner, int valueY, int displayValueY, @Nullable Action action2) {
            if (owner == null) {
                Vertical.$$$reportNull$$$0(1);
            }
            super(owner, 2, action2);
            this.myValueY = valueY;
            this.myDisplayValueY = displayValueY;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            if (retPoint == null) {
                Vertical.$$$reportNull$$$0(2);
            }
            if (Math.abs(valueY - this.myValueY) <= this.myGap) {
                retPoint.x = valueX;
                retPoint.y = this.myValueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            SceneComponent parent;
            if (list == null) {
                Vertical.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Vertical.$$$reportNull$$$0(4);
            }
            if (component2 == null) {
                Vertical.$$$reportNull$$$0(5);
            }
            if ((parent = component2.getParent()) != null) {
                DrawHorizontalNotch.add(list, context, parent.getDrawX(), this.myDisplayValueY, parent.getDrawX() + parent.getDrawWidth());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "retPoint";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch$Vertical";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSnappable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Horizontal
    extends Notch {
        protected int myValueX;
        protected int myDisplayValueX;

        public Horizontal(@NotNull SceneComponent owner, int valueX, int displayValueX) {
            if (owner == null) {
                Horizontal.$$$reportNull$$$0(0);
            }
            this(owner, valueX, displayValueX, null);
        }

        public Horizontal(@NotNull SceneComponent owner, int valueX, int displayValueX, @Nullable Action action2) {
            if (owner == null) {
                Horizontal.$$$reportNull$$$0(1);
            }
            super(owner, 1, action2);
            this.myValueX = valueX;
            this.myDisplayValueX = displayValueX;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            if (retPoint == null) {
                Horizontal.$$$reportNull$$$0(2);
            }
            if (Math.abs(valueX - this.myValueX) <= this.myGap) {
                retPoint.x = this.myValueX;
                retPoint.y = valueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            SceneComponent parent;
            if (list == null) {
                Horizontal.$$$reportNull$$$0(3);
            }
            if (context == null) {
                Horizontal.$$$reportNull$$$0(4);
            }
            if (component2 == null) {
                Horizontal.$$$reportNull$$$0(5);
            }
            if ((parent = component2.getParent()) != null) {
                DrawVerticalNotch.add(list, context, this.myDisplayValueX, parent.getDrawY(), parent.getDrawY() + parent.getDrawHeight());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "retPoint";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/Notch$Horizontal";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSnappable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Provider {
        public void fill(@NotNull SceneComponent var1, @NotNull SceneComponent var2, @NotNull ImmutableList.Builder<Notch> var3);
    }
}

