/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Cursor;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public abstract class ResizeBaseTarget
extends BaseTarget {
    protected final Type myType;
    protected int myStartX1;
    protected int myStartY1;
    protected int myStartX2;
    protected int myStartY2;

    public Type getType() {
        return this.myType;
    }

    public ResizeBaseTarget(@NotNull Type type) {
        if (type == null) {
            ResizeBaseTarget.$$$reportNull$$$0(0);
        }
        this.myType = type;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            ResizeBaseTarget.$$$reportNull$$$0(1);
        }
        int width2 = r - l;
        int height2 = b - t;
        int horizontalCenter = l + width2 / 2;
        int verticalCenter = t + height2 / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = l;
                this.myTop = verticalCenter;
                break;
            }
            case TOP: {
                this.myLeft = horizontalCenter;
                this.myTop = t;
                break;
            }
            case RIGHT: {
                this.myLeft = r;
                this.myTop = verticalCenter;
                break;
            }
            case BOTTOM: {
                this.myLeft = horizontalCenter;
                this.myTop = b;
                break;
            }
            case LEFT_TOP: {
                this.myLeft = l;
                this.myTop = t;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = l;
                this.myTop = b;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = r;
                this.myTop = t;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = r;
                this.myTop = b;
            }
        }
        this.myRight = this.myLeft;
        this.myBottom = this.myTop;
        return false;
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        switch (this.myType) {
            case LEFT: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.W_RESIZE);
            }
            case RIGHT: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.E_RESIZE);
            }
            case TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.N_RESIZE);
            }
            case BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.S_RESIZE);
            }
            case LEFT_TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.NW_RESIZE);
            }
            case LEFT_BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.SW_RESIZE);
            }
            case RIGHT_TOP: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.NE_RESIZE);
            }
            case RIGHT_BOTTOM: {
                return AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.SE_RESIZE);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ResizeBaseTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            ResizeBaseTarget.$$$reportNull$$$0(3);
        }
        if (this.isHittable()) {
            DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.mIsOver ? 1 : 0);
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            ResizeBaseTarget.$$$reportNull$$$0(4);
        }
        if (picker == null) {
            ResizeBaseTarget.$$$reportNull$$$0(5);
        }
        if (this.isHittable()) {
            int halfSize = DrawResize.SIZE / 2;
            picker.addRect(this, 0, transform.getSwingXDip(this.myLeft) - halfSize, transform.getSwingYDip(this.myTop) - halfSize, transform.getSwingXDip(this.myRight) + halfSize, transform.getSwingYDip(this.myBottom) + halfSize);
        }
    }

    @Override
    protected boolean isHittable() {
        SceneComponent component2 = this.getComponent();
        if (component2.getScene().getSelection().size() > 1) {
            return false;
        }
        if (component2.isSelected()) {
            if (component2.canShowBaseline()) {
                return true;
            }
            return !component2.isDragging();
        }
        Scene.FilterType filterType = component2.getScene().getFilterType();
        return filterType == Scene.FilterType.RESIZE || filterType == Scene.FilterType.ALL;
    }

    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    @Override
    public int getPreferenceLevel() {
        return 60;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myStartX1 = this.myComponent.getDrawX();
        this.myStartY1 = this.myComponent.getDrawY();
        this.myStartX2 = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
        this.myStartY2 = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        if (closestTargets == null) {
            ResizeBaseTarget.$$$reportNull$$$0(6);
        }
        if (ignored == null) {
            ResizeBaseTarget.$$$reportNull$$$0(7);
        }
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ResizeBaseTarget.$$$reportNull$$$0(8);
        }
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(component2, "Resize " + StringUtil.getShortName((String)component2.getTagName()));
        this.updateAttributes(modification, x, y);
        modification.commit();
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public void mouseCancel() {
        this.myComponent.setPosition(this.myStartX1, this.myStartY1);
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.rollback();
        component2.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myComponent.getScene().markNeedsLayout(1);
    }

    @Override
    public String getToolTipText() {
        return "Resize View";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/ResizeBaseTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        LEFT,
        LEFT_TOP,
        LEFT_BOTTOM,
        TOP,
        BOTTOM,
        RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

