/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.IncludeHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.lint.detector.api.Category;
import com.intellij.lang.annotation.HighlightSeverity;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlATFIncludeIssue;", "Lcom/android/tools/idea/common/error/Issue;", "include", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "category", "", "getCategory", "()Ljava/lang/String;", "description", "getDescription", "fixes", "Ljava/util/stream/Stream;", "Lcom/android/tools/idea/common/error/Issue$Fix;", "getFixes", "()Ljava/util/stream/Stream;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "source", "Lcom/android/tools/idea/common/error/IssueSource;", "getSource", "()Lcom/android/tools/idea/common/error/IssueSource;", "summary", "getSummary", "suppresses", "Lcom/android/tools/idea/common/error/Issue$Suppress;", "getSuppresses", "intellij.android.designer"})
public final class NlATFIncludeIssue
extends Issue {
    @NotNull
    private final NlComponent include;

    public NlATFIncludeIssue(@NotNull NlComponent include) {
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        this.include = include;
    }

    @Override
    @NotNull
    public String getSummary() {
        return "Included layout may contain accessibility issues.";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "We found some potential accessibility issues that may have came from included layout.";
    }

    @Override
    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WARNING");
        return highlightSeverity;
    }

    @Override
    @NotNull
    public IssueSource getSource() {
        return IssueSource.Companion.fromNlComponent(this.include);
    }

    @Override
    @NotNull
    public String getCategory() {
        return Category.A11Y.getName();
    }

    @Override
    @NotNull
    public Stream<Issue.Fix> getFixes() {
        Issue.Fix fix = new Issue.Fix("Open the layout", "Open the include layout.", () -> NlATFIncludeIssue._get_fixes_$lambda$1(this));
        Stream<Issue.Fix> stream = Stream.of(fix);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(goto)");
        return stream;
    }

    @Override
    @NotNull
    public Stream<Issue.Suppress> getSuppresses() {
        Issue.Suppress ignore = new Issue.Suppress("Suppress", "Suppress this check if it is false positive.", () -> NlATFIncludeIssue._get_suppresses_$lambda$4(this));
        Stream<Issue.Suppress> stream = Stream.of(ignore);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(ignore)");
        return stream;
    }

    private static final void _get_fixes_$lambda$1(NlATFIncludeIssue this$0) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(this$0.include);
            if (viewHandler == null) break block1;
            ViewHandler handler = viewHandler;
            boolean bl = false;
            if (handler instanceof IncludeHandler) {
                IncludeHandler.openIncludedLayout(this$0.include);
            }
        }
    }

    private static final void _get_suppresses_$lambda$4$lambda$3(NlATFIncludeIssue this$0, String $attr) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attr, (String)"$attr");
        this$0.include.setAttribute("http://schemas.android.com/tools", "ignore", $attr);
    }

    private static final void _get_suppresses_$lambda$4(NlATFIncludeIssue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String it = this$0.include.getAttribute("http://schemas.android.com/tools", "ignore");
        boolean bl = false;
        CharSequence charSequence = it;
        Object attr2 = charSequence == null || charSequence.length() == 0 ? "ignoreA11yLints" : it + ",ignoreA11yLints";
        NlWriteCommandActionUtil.run(this$0.include, "Suppress A11Y lints", () -> NlATFIncludeIssue._get_suppresses_$lambda$4$lambda$3(this$0, (String)attr2));
    }
}

