/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.actions.LayoutPreviewHandler;
import com.android.tools.idea.actions.LayoutPreviewHandlerKt;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interactable;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.LayoutScannerControl;
import com.android.tools.idea.common.surface.LayoutScannerEnabled;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SurfaceInteractable;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewportScroller;
import com.android.tools.idea.common.surface.layout.TopBoundCenterScroller;
import com.android.tools.idea.common.surface.layout.ZoomCenterScroller;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NavigationHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfacePositionableContentLayoutManager;
import com.android.tools.idea.uibuilder.surface.NlInteractionHandler;
import com.android.tools.idea.uibuilder.surface.NlLayoutScanner;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.layout.GridSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.GroupedListSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.android.tools.idea.uibuilder.visual.VisualizationToolWindowFactory;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NlDesignSurface
extends DesignSurface<LayoutlibSceneManager>
implements ViewGroupHandler.AccessoryPanelVisibility,
LayoutPreviewHandler {
    private boolean myPreviewWithToolsVisibilityAndPosition;
    private static final double DEFAULT_MIN_SCALE = 0.025;
    private static final double DEFAULT_MAX_SCALE = 10.0;
    @Nullable
    private final DataProvider myDelegateDataProvider;
    @NotNull
    private ScreenViewProvider myScreenViewProvider;
    private boolean myIsCanvasResizing;
    private final RenderListener myRenderListener;
    @NotNull
    private ImmutableList<? extends IssueProvider> myRenderIssueProviders;
    private final AccessoryPanel myAccessoryPanel;
    @NotNull
    private final NlAnalyticsManager myAnalyticsManager;
    private final BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
    @NotNull
    private SurfaceLayoutManager myLayoutManager;
    @Nullable
    private final NavigationHandler myNavigationHandler;
    private final double myMinScale;
    private final double myMaxScale;
    @Nullable
    private DesignSurfaceViewportScroller myViewportScroller;
    private boolean myIsRenderingSynchronously;
    private boolean myIsAnimationScrubbing;
    private float myRotateSurfaceDegree;
    private final Dimension myScrollableViewMinSize;
    @Nullable
    private LayoutScannerControl myScannerControl;
    @NotNull
    private final Set<NlSupportedActions> mySupportedActions;
    private final boolean myShouldRunVisualLintService;
    private boolean myShouldRenderErrorsPanel;
    private final VisualLintIssueProvider myVisualLintIssueProvider;

    /*
     * WARNING - void declaration
     */
    private NlDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider2, @NotNull SurfaceLayoutManager defaultLayoutManager, @NotNull Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> actionManagerProvider, @NotNull Function<DesignSurface<LayoutlibSceneManager>, Interactable> interactableProvider, @NotNull Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> interactionHandlerProvider, @Nullable NavigationHandler navigationHandler, double minScale, double maxScale, @NotNull Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> actionHandlerProvider, @Nullable DataProvider delegateDataProvider, @NotNull SelectionModel selectionModel, DesignSurface.ZoomControlsPolicy zoomControlsPolicy, boolean shouldRunVisualLintService, @NotNull Set<NlSupportedActions> supportedActions, boolean bl, double d) {
        void shouldRenderErrorsPanel;
        void maxFitIntoZoomLevel;
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(1);
        }
        if (sceneManagerProvider2 == null) {
            NlDesignSurface.$$$reportNull$$$0(2);
        }
        if (defaultLayoutManager == null) {
            NlDesignSurface.$$$reportNull$$$0(3);
        }
        if (actionManagerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(4);
        }
        if (interactableProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(5);
        }
        if (interactionHandlerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(6);
        }
        if (actionHandlerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(7);
        }
        if (selectionModel == null) {
            NlDesignSurface.$$$reportNull$$$0(8);
        }
        if (supportedActions == null) {
            NlDesignSurface.$$$reportNull$$$0(9);
        }
        super(project, parentDisposable, actionManagerProvider, interactableProvider, interactionHandlerProvider, surface2 -> new NlDesignSurfacePositionableContentLayoutManager((NlDesignSurface)surface2, defaultLayoutManager), actionHandlerProvider, selectionModel, zoomControlsPolicy, (double)maxFitIntoZoomLevel);
        this.myPreviewWithToolsVisibilityAndPosition = true;
        this.myScreenViewProvider = NlScreenViewProvider.Companion.loadPreferredMode();
        this.myIsCanvasResizing = false;
        this.myRenderListener = this::modelRendered;
        this.myRenderIssueProviders = ImmutableList.of();
        this.myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);
        this.myViewportScroller = null;
        this.myIsRenderingSynchronously = false;
        this.myIsAnimationScrubbing = false;
        this.myRotateSurfaceDegree = Float.NaN;
        this.myScrollableViewMinSize = new Dimension();
        this.myAnalyticsManager = new NlAnalyticsManager(this);
        this.myAccessoryPanel.setSurface(this);
        this.myLayoutManager = defaultLayoutManager;
        this.mySceneManagerProvider = sceneManagerProvider2;
        this.myNavigationHandler = navigationHandler;
        this.mySupportedActions = supportedActions;
        this.myShouldRunVisualLintService = shouldRunVisualLintService;
        this.myShouldRenderErrorsPanel = shouldRenderErrorsPanel;
        this.myVisualLintIssueProvider = new VisualLintIssueProvider(this);
        if (this.myNavigationHandler != null) {
            Disposer.register((Disposable)this, (Disposable)this.myNavigationHandler);
        }
        this.myMinScale = minScale;
        this.myMaxScale = maxScale;
        this.getViewport().addChangeListener(e -> {
            DesignSurfaceViewportScroller scroller = this.myViewportScroller;
            this.myViewportScroller = null;
            if (scroller != null) {
                scroller.scroll(this.getViewport());
            }
        });
        this.myScannerControl = new NlLayoutScanner(this);
        this.myDelegateDataProvider = delegateDataProvider;
    }

    @NotNull
    public static LayoutlibSceneManager defaultSceneManagerProvider(@NotNull NlDesignSurface surface2, @NotNull NlModel model2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(10);
        }
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(11);
        }
        LayoutlibSceneManager sceneManager = new LayoutlibSceneManager(model2, surface2, new LayoutScannerEnabled());
        RenderSettings settings = RenderSettings.getProjectSettings((Project)model2.getProject());
        sceneManager.setShowDecorations(settings.getShowDecorations());
        sceneManager.setUseImagePool(settings.getUseLiveRendering());
        sceneManager.setQuality(settings.getQuality());
        LayoutlibSceneManager layoutlibSceneManager = sceneManager;
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(12);
        }
        return layoutlibSceneManager;
    }

    @NotNull
    public static SurfaceLayoutManager createDefaultSurfaceLayoutManager() {
        return new SingleDirectionLayoutManager(50, 50, 48, 48, SingleDirectionLayoutManager.Alignment.CENTER);
    }

    @NotNull
    public static ActionManager<? extends NlDesignSurface> defaultActionManagerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(13);
        }
        return new NlActionManager((NlDesignSurface)surface2);
    }

    @NotNull
    public static NlInteractionHandler defaultInteractionHandlerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(14);
        }
        return new NlInteractionHandler(surface2);
    }

    @NotNull
    public static NlDesignSurfaceActionHandler defaultActionHandlerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(15);
        }
        return new NlDesignSurfaceActionHandler(surface2);
    }

    @NotNull
    public static Builder builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(16);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(17);
        }
        return new Builder(project, parentDisposable);
    }

    @Override
    @NotNull
    protected LayoutlibSceneManager createSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(18);
        }
        LayoutlibSceneManager manager = this.mySceneManagerProvider.apply(this, model2);
        manager.addRenderListener(this.myRenderListener);
        LayoutlibSceneManager layoutlibSceneManager = manager;
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(19);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public NlAnalyticsManager getAnalyticsManager() {
        NlAnalyticsManager nlAnalyticsManager = this.myAnalyticsManager;
        if (nlAnalyticsManager == null) {
            NlDesignSurface.$$$reportNull$$$0(20);
        }
        return nlAnalyticsManager;
    }

    @Override
    @Nullable
    public LayoutScannerControl getLayoutScannerControl() {
        return this.myScannerControl;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
        this.setSurfaceAutoscrolls(isResizing);
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public ScreenViewProvider getScreenViewProvider() {
        ScreenViewProvider screenViewProvider = this.myScreenViewProvider;
        if (screenViewProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(21);
        }
        return screenViewProvider;
    }

    public void setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
        if (screenViewProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(22);
        }
        if (setAsDefault && screenViewProvider instanceof NlScreenViewProvider) {
            NlScreenViewProvider.Companion.savePreferredMode((NlScreenViewProvider)screenViewProvider);
        }
        if (screenViewProvider != this.myScreenViewProvider) {
            this.myScreenViewProvider.onViewProviderReplaced();
            this.myScreenViewProvider = screenViewProvider;
            for (SceneManager manager : this.getSceneManagers()) {
                manager.updateSceneView();
                manager.requestLayoutAndRenderAsync(false);
            }
            this.revalidateScrollArea();
        }
    }

    public void setColorBlindMode(ColorBlindMode mode) {
        this.myScreenViewProvider.setColorBlindFilter(mode);
        for (SceneManager manager : this.getSceneManagers()) {
            manager.updateSceneView();
            manager.requestLayoutAndRenderAsync(false);
        }
        this.revalidateScrollArea();
    }

    @Nullable
    public NavigationHandler getNavigationHandler() {
        return this.myNavigationHandler;
    }

    @Override
    public boolean shouldRenderErrorsPanel() {
        return this.myShouldRenderErrorsPanel;
    }

    @NotNull
    public static NlDesignSurface build(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(24);
        }
        NlDesignSurface nlDesignSurface = new Builder(project, parentDisposable).build();
        if (nlDesignSurface == null) {
            NlDesignSurface.$$$reportNull$$$0(25);
        }
        return nlDesignSurface;
    }

    public void forceLayersPaint(boolean value2) {
        for (SceneView view2 : this.getSceneViews()) {
            view2.setForceLayersRepaint(value2);
        }
        this.repaint();
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        AccessoryPanel accessoryPanel = this.myAccessoryPanel;
        if (accessoryPanel == null) {
            NlDesignSurface.$$$reportNull$$$0(26);
        }
        return accessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show2) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show2);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show2) {
        if (type == null) {
            NlDesignSurface.$$$reportNull$$$0(27);
        }
        this.showInspectorAccessoryPanel(show2);
    }

    @Override
    public double getScreenScalingFactor() {
        return JBUIScale.sysScale((Component)((Object)this));
    }

    @Override
    @NotNull
    public ActionManager<NlDesignSurface> getActionManager() {
        ActionManager actionManager = super.getActionManager();
        if (actionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(28);
        }
        return actionManager;
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component2 -> new DnDTransferComponent(component2.getTagName(), component2.getTagDeprecated().getText(), NlComponentHelperKt.getW(component2), NlComponentHelperKt.getH(component2))).collect(ImmutableList.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Override
    protected Dimension getScrollToVisibleOffset() {
        return new Dimension(100, 100);
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        this.myRenderIssueProviders = ImmutableList.of();
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        ViewHandler handler;
        if (component2 == null) {
            NlDesignSurface.$$$reportNull$$$0(29);
        }
        if ((handler = NlComponentHelperKt.getViewHandler(component2)) != null) {
            handler.onActivateInDesignSurface(component2, x, y);
        }
        super.notifyComponentActivate(component2, x, y);
    }

    public void updateErrorDisplay() {
        if (this.myIsRenderingSynchronously) {
            return;
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                Project project;
                Map results;
                if (NlDesignSurface.this.myScannerControl != null) {
                    NlDesignSurface.this.myScannerControl.resume();
                }
                if ((results = NlDesignSurface.this.getSceneManagers().stream().filter(sceneManager -> sceneManager.getRenderResult() != null).collect(Collectors.toMap(Function.identity(), LayoutlibSceneManager::getRenderResult))).isEmpty()) {
                    return;
                }
                if (NlDesignSurface.this.myScannerControl != null) {
                    for (Map.Entry entry : results.entrySet()) {
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)entry.getKey();
                        if (!manager.getLayoutScannerConfig().isIntegrateWithDefaultIssuePanel()) continue;
                        NlDesignSurface.this.myScannerControl.validateAndUpdateLint(entry.getValue(), manager.getModel());
                    }
                }
                if ((project = NlDesignSurface.this.getProject()).isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    ImmutableList renderIssueProviders = null;
                    if (GradleBuildState.getInstance((Project)project).isBuildInProgress()) {
                        for (Map.Entry entry2 : results.entrySet()) {
                            if (!((RenderResult)entry2.getValue()).getLogger().hasErrors()) continue;
                            renderIssueProviders = ImmutableList.of((Object)new RenderIssueProvider(((LayoutlibSceneManager)entry2.getKey()).getModel(), RenderErrorModel.STILL_BUILDING_ERROR_MODEL));
                            break;
                        }
                    }
                    if (renderIssueProviders == null) {
                        renderIssueProviders = (ImmutableList)results.entrySet().stream().map(entry -> {
                            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel((EditorDesignSurface)NlDesignSurface.this, (RenderResult)((RenderResult)entry.getValue()), null);
                            return new RenderIssueProvider(((LayoutlibSceneManager)entry.getKey()).getModel(), errorModel);
                        }).collect(ImmutableList.toImmutableList());
                    }
                    NlDesignSurface.this.myRenderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
                    NlDesignSurface.this.myRenderIssueProviders = renderIssueProviders;
                    renderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().addIssueProvider((IssueProvider)renderIssueProvider));
                });
                if (NlDesignSurface.this.myShouldRunVisualLintService && !VisualizationToolWindowFactory.hasVisibleValidationWindow(project)) {
                    VisualLintService.getInstance(project).runVisualLintAnalysis(NlDesignSurface.this, NlDesignSurface.this.myVisualLintIssueProvider, (List<? extends NlModel>)NlDesignSurface.this.getModels());
                }
            }

            public boolean canEat(@NotNull Update update2) {
                if (update2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/android/tools/idea/uibuilder/surface/NlDesignSurface$1", "canEat"));
            }
        });
    }

    private void modelRendered() {
        this.updateErrorDisplay();
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
    }

    @Override
    public void deactivate() {
        this.myRenderIssueProviders.forEach(renderIssueProvider -> this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
        this.myRenderIssueProviders = ImmutableList.of();
        this.myVisualLintIssueProvider.clear();
        super.deactivate();
    }

    @Override
    public void activate() {
        super.activate();
        this.updateErrorDisplay();
    }

    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        BackgroundableProcessIndicator refreshProgressIndicator = new BackgroundableProcessIndicator(this.getProject(), "Refreshing...", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false);
        CompletionStage completionStage = this.requestSequentialRender(manager -> {
            manager.forceReinflate();
            return manager.requestUserInitiatedRenderAsync();
        }).whenComplete((r, t) -> refreshProgressIndicator.processFinish());
        if (completionStage == null) {
            NlDesignSurface.$$$reportNull$$$0(30);
        }
        return completionStage;
    }

    @NotNull
    public CompletableFuture<Void> forceRefresh() {
        CompletableFuture<Void> completableFuture = this.requestSequentialRender(manager -> {
            manager.forceReinflate();
            return manager.requestRenderAsync();
        });
        if (completableFuture == null) {
            NlDesignSurface.$$$reportNull$$$0(31);
        }
        return completableFuture;
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getFocusedSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = (LayoutlibSceneManager)this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return this.myMinScale;
    }

    @Override
    protected double getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    public boolean canZoomToFit() {
        double zoomToFitScale;
        double currentScale = this.getScale();
        return currentScale > (zoomToFitScale = this.getFitScale()) && this.canZoomOut() || currentScale < zoomToFitScale && this.canZoomIn();
    }

    @Override
    public boolean canZoomToActual() {
        double scaleOfActual;
        double currentScale = this.getScale();
        return currentScale > (scaleOfActual = 1.0 / this.getScreenScalingFactor()) && this.canZoomOut() || currentScale < scaleOfActual && this.canZoomIn();
    }

    @Override
    public double getFitScale() {
        Dimension extent = this.getExtentSize();
        double scale = ((NlDesignSurfacePositionableContentLayoutManager)this.getSceneViewLayoutManager()).getLayoutManager().getFitIntoScale(this.getPositionableContent(), extent.width, extent.height);
        return Math.min(scale, this.myMaxFitIntoScale);
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        boolean changed = super.setScale(scale, x, y);
        if (changed) {
            DesignSurfaceViewport port = this.getViewport();
            if (this.myLayoutManager instanceof GroupedListSurfaceLayoutManager) {
                Point scrollPosition = this.getScrollPosition();
                this.myViewportScroller = new TopBoundCenterScroller(new Dimension(port.getViewSize()), new Point(scrollPosition));
            } else if (!(this.myLayoutManager instanceof GridSurfaceLayoutManager)) {
                if (x < 0 || y < 0) {
                    x = port.getViewportComponent().getWidth() / 2;
                    y = port.getViewportComponent().getHeight() / 2;
                }
                Point scrollPosition = this.getScrollPosition();
                Point zoomCenterInView = new Point(scrollPosition.x + x, scrollPosition.y + y);
                this.myViewportScroller = new ZoomCenterScroller(new Dimension(port.getViewSize()), new Point(scrollPosition), zoomCenterInView);
            }
        }
        return changed;
    }

    public final void zoomAndCenter(@NotNull SceneView sceneView, @NotNull Rectangle rectangle) {
        if (sceneView == null) {
            NlDesignSurface.$$$reportNull$$$0(32);
        }
        if (rectangle == null) {
            NlDesignSurface.$$$reportNull$$$0(33);
        }
        if (this.myScrollPane == null) {
            Logger.getInstance(NlDesignSurface.class).warn("The scroll pane is null, cannot zoom and center.");
            return;
        }
        Dimension offset2 = this.getScrollToVisibleOffset();
        Dimension availableSize = this.getExtentSize();
        Dimension curSize = new Dimension(rectangle.width, rectangle.height);
        double scaleChangeNeeded = Math.min((availableSize.getWidth() - (double)(2 * offset2.width)) / curSize.getWidth(), (availableSize.getHeight() - (double)(2 * offset2.height)) / curSize.getHeight());
        double curScale = this.getScale();
        double boundedNewScale = this.getBoundedScale(curScale * scaleChangeNeeded);
        scaleChangeNeeded = boundedNewScale / curScale;
        rectangle.setRect((double)rectangle.x * scaleChangeNeeded, (double)rectangle.y * scaleChangeNeeded, (double)rectangle.width * scaleChangeNeeded, (double)rectangle.height * scaleChangeNeeded);
        if (this.setScale(boundedNewScale)) {
            this.myViewportScroller = port -> this.scrollToCenter(sceneView, rectangle);
        } else {
            this.scrollToCenter(sceneView, rectangle);
        }
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(34);
        }
        Scene scene = this.getScene();
        SceneView view2 = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view2 == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component2 = scene.getSceneComponent((NlComponent)nlComponent);
            if (component2 == null) {
                return;
            }
            component2.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view2, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, areaToCenter.getSize());
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            NlDesignSurface.$$$reportNull$$$0(35);
        }
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(36);
            }
            return list;
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(37);
            }
            return list;
        }
        NlComponent root = (NlComponent)roots.get(0);
        if (root == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(38);
            }
            return list;
        }
        List<NlComponent> list = root.flatten().collect(Collectors.toList());
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(39);
        }
        return list;
    }

    public void setRenderSynchronously(boolean enabled) {
        this.myIsRenderingSynchronously = enabled;
        if (this.myScannerControl != null) {
            if (enabled) {
                this.myScannerControl.pause();
            } else {
                this.myScannerControl.resume();
            }
        }
    }

    public boolean isRenderingSynchronously() {
        return this.myIsRenderingSynchronously;
    }

    public void setAnimationScrubbing(boolean value2) {
        this.myIsAnimationScrubbing = value2;
    }

    public void setRotateSufaceDegree(float value2) {
        this.myRotateSurfaceDegree = value2;
    }

    public float getRotateSurfaceDegree() {
        return this.myRotateSurfaceDegree;
    }

    public boolean isInAnimationScrubbing() {
        return this.myIsAnimationScrubbing;
    }

    public void setScrollableViewMinSize(@NotNull Dimension dimension) {
        if (dimension == null) {
            NlDesignSurface.$$$reportNull$$$0(40);
        }
        this.myScrollableViewMinSize.setSize(dimension);
    }

    @Override
    public Object getData(@NotNull String dataId) {
        Object data;
        if (dataId == null) {
            NlDesignSurface.$$$reportNull$$$0(41);
        }
        Object object = data = this.myDelegateDataProvider != null ? this.myDelegateDataProvider.getData(dataId) : null;
        if (data != null) {
            return data;
        }
        if (LayoutPreviewHandlerKt.LAYOUT_PREVIEW_HANDLER_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Set<NlSupportedActions> getSupportedActions() {
        Set<NlSupportedActions> set = this.mySupportedActions;
        if (set == null) {
            NlDesignSurface.$$$reportNull$$$0(42);
        }
        return set;
    }

    @Override
    public boolean getPreviewWithToolsVisibilityAndPosition() {
        return this.myPreviewWithToolsVisibilityAndPosition;
    }

    @Override
    public void setPreviewWithToolsVisibilityAndPosition(boolean isPreviewWithToolsVisibilityAndPosition) {
        if (this.myPreviewWithToolsVisibilityAndPosition != isPreviewWithToolsVisibilityAndPosition) {
            this.myPreviewWithToolsVisibilityAndPosition = isPreviewWithToolsVisibilityAndPosition;
            this.forceRefresh();
        }
    }

    @NotNull
    Dimension getScrollableViewMinSize() {
        Dimension dimension = this.myScrollableViewMinSize;
        if (dimension == null) {
            NlDesignSurface.$$$reportNull$$$0(43);
        }
        return dimension;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 19, 20, 21, 25, 26, 28, 30, 31, 36, 37, 38, 39, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManagerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLayoutManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactableProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionHandlerProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandlerProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedActions";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenViewProvider";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectangle";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSceneManagerProvider";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewProvider";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessoryPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "forceUserRequestedRefresh";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "forceRefresh";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectableComponents";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedActions";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollableViewMinSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "defaultSceneManagerProvider";
                break;
            }
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defaultActionManagerProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "defaultInteractionHandlerProvider";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "defaultActionHandlerProvider";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setScreenViewProvider";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "zoomAndCenter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setScrollableViewMinSize";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 19, 20, 21, 25, 26, 28, 30, 31, 36, 37, 38, 39, 42, 43 -> new IllegalStateException(string2);
        };
    }

    public static class Builder {
        private final Project myProject;
        private final Disposable myParentDisposable;
        private BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
        private SurfaceLayoutManager myLayoutManager;
        private NavigationHandler myNavigationHandler;
        private double myMinScale;
        private double myMaxScale;
        @Nullable
        private DataProvider myDelegateDataProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> myActionManagerProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, Interactable> myInteractableProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> myInteractionHandlerProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> myActionHandlerProvider;
        @Nullable
        private SelectionModel mySelectionModel;
        private DesignSurface.ZoomControlsPolicy myZoomControlsPolicy;
        @NotNull
        private Set<NlSupportedActions> mySupportedActions;
        private boolean myShouldRunVisualLintService;
        private boolean myShouldRenderErrorsPanel;
        @Nullable
        private ScreenViewProvider myScreenViewProvider;
        private boolean mySetDefaultScreenViewProvider;
        private double myMaxFitIntoZoomLevel;

        private Builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.mySceneManagerProvider = NlDesignSurface::defaultSceneManagerProvider;
            this.myMinScale = 0.025;
            this.myMaxScale = 10.0;
            this.myDelegateDataProvider = null;
            this.myActionManagerProvider = NlDesignSurface::defaultActionManagerProvider;
            this.myInteractableProvider = SurfaceInteractable::new;
            this.myInteractionHandlerProvider = NlDesignSurface::defaultInteractionHandlerProvider;
            this.myActionHandlerProvider = NlDesignSurface::defaultActionHandlerProvider;
            this.mySelectionModel = null;
            this.myZoomControlsPolicy = DesignSurface.ZoomControlsPolicy.AUTO_HIDE;
            this.mySupportedActions = Collections.emptySet();
            this.myShouldRunVisualLintService = false;
            this.myShouldRenderErrorsPanel = false;
            this.myScreenViewProvider = null;
            this.mySetDefaultScreenViewProvider = false;
            this.myMaxFitIntoZoomLevel = Double.MAX_VALUE;
            this.myProject = project;
            this.myParentDisposable = parentDisposable;
        }

        @NotNull
        public Builder setSceneManagerProvider(@NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider2) {
            if (sceneManagerProvider2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.mySceneManagerProvider = sceneManagerProvider2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        public Builder setLayoutManager(@NotNull SurfaceLayoutManager layoutManager) {
            if (layoutManager == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myLayoutManager = layoutManager;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder setActionManagerProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> actionManagerProvider) {
            if (actionManagerProvider == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myActionManagerProvider = actionManagerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @TestOnly
        @NotNull
        public Builder setInteractableProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, Interactable> interactableProvider) {
            if (interactableProvider == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myInteractableProvider = interactableProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder setInteractionHandlerProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> interactionHandlerProvider) {
            if (interactionHandlerProvider == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myInteractionHandlerProvider = interactionHandlerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder2;
        }

        @NotNull
        public Builder setNavigationHandler(NavigationHandler navigationHandler) {
            this.myNavigationHandler = navigationHandler;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        public Builder setMinScale(double scale) {
            if (scale <= 0.0) {
                throw new IllegalStateException("The min scale (" + scale + ") is not larger than 0");
            }
            this.myMinScale = scale;
            return this;
        }

        public Builder setMaxScale(double scale) {
            this.myMaxScale = scale;
            return this;
        }

        @NotNull
        public Builder setActionHandler(@NotNull Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> actionHandlerProvider) {
            if (actionHandlerProvider == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myActionHandlerProvider = actionHandlerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder setDelegateDataProvider(@NotNull DataProvider dataProvider) {
            if (dataProvider == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myDelegateDataProvider = dataProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public Builder setSelectionModel(@NotNull SelectionModel selectionModel) {
            if (selectionModel == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.mySelectionModel = selectionModel;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder2;
        }

        @NotNull
        public Builder setZoomControlsPolicy(@NotNull DesignSurface.ZoomControlsPolicy policy) {
            if (policy == null) {
                Builder.$$$reportNull$$$0(19);
            }
            this.myZoomControlsPolicy = policy;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder2;
        }

        @NotNull
        public Builder setRunVisualLintAnalysis(boolean value2) {
            this.myShouldRunVisualLintService = value2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return builder2;
        }

        @NotNull
        public Builder setSupportedActions(@NotNull Set<NlSupportedActions> supportedActions) {
            if (supportedActions == null) {
                Builder.$$$reportNull$$$0(22);
            }
            this.mySupportedActions = supportedActions;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(23);
            }
            return builder2;
        }

        @NotNull
        public Builder setShouldRenderErrorsPanel(Boolean shouldRenderErrorsPanel) {
            this.myShouldRenderErrorsPanel = shouldRenderErrorsPanel;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder2;
        }

        @NotNull
        public Builder setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
            if (screenViewProvider == null) {
                Builder.$$$reportNull$$$0(25);
            }
            this.myScreenViewProvider = screenViewProvider;
            this.mySetDefaultScreenViewProvider = setAsDefault;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(26);
            }
            return builder2;
        }

        @NotNull
        public Builder setMaxFitIntoZoomLevel(double maxFitIntoZoomLevel) {
            this.myMaxFitIntoZoomLevel = maxFitIntoZoomLevel;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(27);
            }
            return builder2;
        }

        @NotNull
        public NlDesignSurface build() {
            SurfaceLayoutManager layoutManager;
            SurfaceLayoutManager surfaceLayoutManager = layoutManager = this.myLayoutManager != null ? this.myLayoutManager : NlDesignSurface.createDefaultSurfaceLayoutManager();
            if (this.myMinScale > this.myMaxScale) {
                throw new IllegalStateException("The max scale (" + this.myMaxScale + ") is lower than min scale (" + this.myMinScale + ")");
            }
            NlDesignSurface surface2 = new NlDesignSurface(this.myProject, this.myParentDisposable, this.mySceneManagerProvider, layoutManager, this.myActionManagerProvider, this.myInteractableProvider, this.myInteractionHandlerProvider, this.myNavigationHandler, this.myMinScale, this.myMaxScale, this.myActionHandlerProvider, this.myDelegateDataProvider, this.mySelectionModel != null ? this.mySelectionModel : new DefaultSelectionModel(), this.myZoomControlsPolicy, this.myShouldRunVisualLintService, this.mySupportedActions, this.myShouldRenderErrorsPanel, this.myMaxFitIntoZoomLevel);
            if (this.myScreenViewProvider != null) {
                surface2.setScreenViewProvider(this.myScreenViewProvider, this.mySetDefaultScreenViewProvider);
            }
            NlDesignSurface nlDesignSurface = surface2;
            if (nlDesignSurface == null) {
                Builder.$$$reportNull$$$0(28);
            }
            return nlDesignSurface;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 7, 9, 11, 12, 14, 16, 18, 20, 21, 23, 24, 26, 27, 28 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sceneManagerProvider";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutManager";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionManagerProvider";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactableProvider";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactionHandlerProvider";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionHandlerProvider";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataProvider";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionModel";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supportedActions";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenViewProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSceneManagerProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLayoutManager";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setActionManagerProvider";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInteractableProvider";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInteractionHandlerProvider";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNavigationHandler";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setActionHandler";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDelegateDataProvider";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSelectionModel";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setZoomControlsPolicy";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRunVisualLintAnalysis";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSupportedActions";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setShouldRenderErrorsPanel";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setScreenViewProvider";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxFitIntoZoomLevel";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSceneManagerProvider";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setLayoutManager";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionManagerProvider";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setInteractableProvider";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setInteractionHandlerProvider";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionHandler";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegateDataProvider";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelectionModel";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "setZoomControlsPolicy";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "setSupportedActions";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "setScreenViewProvider";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 5, 7, 9, 11, 12, 14, 16, 18, 20, 21, 23, 24, 26, 27, 28 -> new IllegalStateException(string2);
            };
        }
    }
}

