/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.validator.ValidatorData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u001dJ8\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\r2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020&0%J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R(\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser;", "", "()V", "_includeComponents", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/common/model/NlComponent;", "Lkotlin/collections/ArrayList;", "<set-?>", "", "componentCount", "getComponentCount", "()I", "idToComponent", "Lcom/google/common/collect/BiMap;", "getIdToComponent$annotations", "getIdToComponent", "()Lcom/google/common/collect/BiMap;", "includeComponents", "", "getIncludeComponents", "()Ljava/util/List;", "nodeIdToComponent", "", "getNodeIdToComponent", "viewToComponent", "Landroid/view/View;", "getViewToComponent$annotations", "getViewToComponent", "buildViewToComponentMap", "", "component", "clear", "findComponent", "result", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "map", "nodeInfoMap", "Lcom/google/common/collect/ImmutableBiMap;", "Landroid/view/accessibility/AccessibilityNodeInfo;", "isEmpty", "", "tryFindingRootWithViewInfo", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nNlScannerLayoutParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlScannerLayoutParser.kt\ncom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1855#2,2:132\n1855#2,2:134\n*S KotlinDebug\n*F\n+ 1 NlScannerLayoutParser.kt\ncom/android/tools/idea/uibuilder/surface/NlScannerLayoutParser\n*L\n78#1:132,2\n93#1:134,2\n*E\n"})
public final class NlScannerLayoutParser {
    @NotNull
    private final BiMap<Integer, NlComponent> idToComponent;
    @NotNull
    private final BiMap<View, NlComponent> viewToComponent;
    @NotNull
    private final BiMap<Long, NlComponent> nodeIdToComponent;
    @NotNull
    private final ArrayList<NlComponent> _includeComponents;
    private int componentCount;

    public NlScannerLayoutParser() {
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create()");
        this.idToComponent = (BiMap)hashBiMap;
        HashBiMap hashBiMap2 = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap2, (String)"create()");
        this.viewToComponent = (BiMap)hashBiMap2;
        HashBiMap hashBiMap3 = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap3, (String)"create()");
        this.nodeIdToComponent = (BiMap)hashBiMap3;
        this._includeComponents = new ArrayList();
    }

    @NotNull
    public final BiMap<Integer, NlComponent> getIdToComponent() {
        return this.idToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIdToComponent$annotations() {
    }

    @NotNull
    public final BiMap<View, NlComponent> getViewToComponent() {
        return this.viewToComponent;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewToComponent$annotations() {
    }

    @NotNull
    public final BiMap<Long, NlComponent> getNodeIdToComponent() {
        return this.nodeIdToComponent;
    }

    @NotNull
    public final List<NlComponent> getIncludeComponents() {
        return this._includeComponents;
    }

    public final int getComponentCount() {
        return this.componentCount;
    }

    public final void buildViewToComponentMap(@NotNull NlComponent component2) {
        block5: {
            Object accessibilityNodeInfo;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            NlComponent root = this.tryFindingRootWithViewInfo(component2);
            int n = this.componentCount;
            this.componentCount = n + 1;
            String string2 = root.getTagName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"root.tagName");
            String className = string2;
            if (Intrinsics.areEqual((Object)className, (Object)"include") && !Intrinsics.areEqual((Object)root.getAttribute("http://schemas.android.com/tools", "ignore"), (Object)"ignoreA11yLints")) {
                this._includeComponents.add(root);
                return;
            }
            ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(root);
            if (viewInfo == null) break block5;
            ViewInfo viewInfo2 = viewInfo;
            boolean bl = false;
            Object viewObj = viewInfo2.getViewObject();
            if (viewObj instanceof View) {
                ((Map)this.viewToComponent).put(viewObj, component2);
                if (-1 != ((View)viewObj).getId()) {
                    ((Map)this.idToComponent).put(((View)viewObj).getId(), component2);
                }
            }
            if ((accessibilityNodeInfo = viewInfo2.getAccessibilityObject()) instanceof AccessibilityNodeInfo) {
                ((Map)this.nodeIdToComponent).put(((AccessibilityNodeInfo)accessibilityNodeInfo).getSourceNodeId(), component2);
            }
            List<NlComponent> list = component2.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NlComponent it = (NlComponent)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.buildViewToComponentMap(it);
            }
        }
    }

    @NotNull
    public final NlComponent tryFindingRootWithViewInfo(@NotNull NlComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component2);
        if ((viewInfo != null ? viewInfo.getViewObject() : null) != null) {
            return component2;
        }
        List<NlComponent> list = component2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it = (NlComponent)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ViewInfo viewInfo2 = NlComponentHelperKt.getViewInfo(it);
            if ((viewInfo2 != null ? viewInfo2.getViewObject() : null) == null) continue;
            return it;
        }
        return component2;
    }

    @Nullable
    public final NlComponent findComponent(@NotNull ValidatorData.Issue result, @NotNull BiMap<Long, View> map2, @NotNull ImmutableBiMap<Long, AccessibilityNodeInfo> nodeInfoMap) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter(nodeInfoMap, (String)"nodeInfoMap");
        View view2 = (View)map2.get((Object)result.mSrcId);
        if (view2 != null) {
            NlComponent toReturn = (NlComponent)this.viewToComponent.get((Object)view2);
            if (toReturn == null) {
                toReturn = (NlComponent)this.idToComponent.get((Object)view2.getId());
            }
            return toReturn;
        }
        AccessibilityNodeInfo accessibilityNodeInfo = (AccessibilityNodeInfo)nodeInfoMap.get((Object)result.mSrcId);
        if (accessibilityNodeInfo == null) {
            return null;
        }
        AccessibilityNodeInfo node = accessibilityNodeInfo;
        return (NlComponent)this.nodeIdToComponent.get((Object)node.getSourceNodeId());
    }

    public final void clear() {
        this.viewToComponent.clear();
        this.idToComponent.clear();
        this.nodeIdToComponent.clear();
        this._includeComponents.clear();
        this.componentCount = 0;
    }

    public final boolean isEmpty() {
        return this.viewToComponent.isEmpty() && this.idToComponent.isEmpty() && this._includeComponents.isEmpty();
    }
}

