/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.AndroidColorSet;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.layer.BorderLayer;
import com.android.tools.idea.uibuilder.surface.layer.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.layer.OverlayLayer;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.collect.ImmutableList;
import java.awt.Dimension;
import java.util.function.Function;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ScreenView
extends ScreenViewBase {
    public static final ContentSizePolicy DEVICE_CONTENT_SIZE_POLICY = (screenView, outDimension) -> {
        State state;
        Configuration configuration = screenView.getConfiguration();
        Device device = configuration.getCachedDevice();
        if (device != null && (state = configuration.getDeviceState()) != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
                float densityRatio = (float)Density.DEFAULT_DENSITY * 1.0f / (float)config.getDensity().getDpiValue();
                int dpWidth = Math.round((float)config.getScreenWidth() * densityRatio);
                int dpHeight = Math.round((float)config.getScreenHeight() * densityRatio);
                outDimension.setSize(dpWidth, dpHeight);
            } else {
                outDimension.setSize(config.getScreenWidth(), config.getScreenHeight());
            }
        }
    };
    private static final Function<ScreenView, ImmutableList<Layer>> DEFAULT_LAYERS_PROVIDER = screenView -> {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (screenView.hasBorderLayer()) {
            builder2.add((Object)new BorderLayer((SceneView)screenView, (Function0<Float>)((Function0)() -> Float.valueOf(screenView.getSurface().getRotateSurfaceDegree()))));
        }
        builder2.add((Object)new ScreenViewLayer((ScreenView)screenView));
        NlDesignSurface surface2 = screenView.getSurface();
        SceneLayer sceneLayer = new SceneLayer(surface2, (SceneView)screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder2.add((Object)sceneLayer);
        if (((Boolean)StudioFlags.NELE_OVERLAY_PROVIDER.get()).booleanValue()) {
            builder2.add((Object)new OverlayLayer((SceneView)screenView));
        }
        if (screenView.myIsResizeable && screenView.getSceneManager().getModel().getType().isEditable()) {
            builder2.add((Object)new CanvasResizeLayer((ScreenView)screenView, (Function0<Unit>)((Function0)() -> {
                surface2.repaint();
                return null;
            })));
        }
        if (((Boolean)StudioFlags.NELE_RENDER_DIAGNOSTICS.get()).booleanValue()) {
            builder2.add((Object)new DiagnosticsLayer(surface2));
        }
        return builder2.build();
    };
    private final boolean myHasBorderLayer;
    private final boolean myIsResizeable;
    @NotNull
    private final ColorSet myColorSet;
    @NotNull
    private final Function<ScreenView, ImmutableList<Layer>> myLayersProvider;
    @NotNull
    private final ContentSizePolicy myContentSizePolicy;

    @NotNull
    public static Builder newBuilder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
        if (surface2 == null) {
            ScreenView.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ScreenView.$$$reportNull$$$0(1);
        }
        return new Builder(surface2, manager);
    }

    private ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull SceneView.ShapePolicy shapePolicy, boolean isResizeable, boolean hasBorderLayer, @NotNull ColorSet colorSet, @NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider, @NotNull ContentSizePolicy contentSizePolicy) {
        if (surface2 == null) {
            ScreenView.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            ScreenView.$$$reportNull$$$0(3);
        }
        if (shapePolicy == null) {
            ScreenView.$$$reportNull$$$0(4);
        }
        if (colorSet == null) {
            ScreenView.$$$reportNull$$$0(5);
        }
        if (layersProvider == null) {
            ScreenView.$$$reportNull$$$0(6);
        }
        if (contentSizePolicy == null) {
            ScreenView.$$$reportNull$$$0(7);
        }
        super(surface2, manager, shapePolicy);
        this.myHasBorderLayer = hasBorderLayer;
        this.myIsResizeable = isResizeable;
        this.myColorSet = colorSet;
        this.myLayersProvider = layersProvider;
        this.myContentSizePolicy = contentSizePolicy;
    }

    @TestOnly
    public ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull ContentSizePolicy contentSizePolicy) {
        if (surface2 == null) {
            ScreenView.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ScreenView.$$$reportNull$$$0(9);
        }
        if (contentSizePolicy == null) {
            ScreenView.$$$reportNull$$$0(10);
        }
        this(surface2, manager, SQUARE_SHAPE_POLICY, true, false, new AndroidColorSet(), DEFAULT_LAYERS_PROVIDER, contentSizePolicy);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        this.myContentSizePolicy.measure(this, dimension);
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            ScreenView.$$$reportNull$$$0(11);
        }
        return dimension2;
    }

    @Override
    @NotNull
    protected ImmutableList<Layer> createLayers() {
        ImmutableList<Layer> immutableList = this.myLayersProvider.apply(this);
        if (immutableList == null) {
            ScreenView.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    public boolean hasBorderLayer() {
        return this.myHasBorderLayer;
    }

    private static boolean isErrorResult(@NotNull RenderResult result) {
        if (result == null) {
            ScreenView.$$$reportNull$$$0(13);
        }
        ImagePool.Image image = result.getRenderedImage();
        return result.getLogger().hasErrors() && (!image.isValid() || image.getWidth() * image.getHeight() < 2);
    }

    @Override
    public boolean hasContentSize() {
        return this.myContentSizePolicy.hasContentSize(this);
    }

    @Override
    @NotNull
    public ColorSet getColorSet() {
        ColorSet colorSet = this.myColorSet;
        if (colorSet == null) {
            ScreenView.$$$reportNull$$$0(14);
        }
        return colorSet;
    }

    @Override
    public boolean isResizeable() {
        return this.myIsResizeable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shapePolicy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layersProvider";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentSizePolicy";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isErrorResult";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11, 12, 14 -> new IllegalStateException(string2);
        };
    }

    public static class Builder {
        @NotNull
        final NlDesignSurface mySurface;
        @NotNull
        final LayoutlibSceneManager myManager;
        boolean isResizeable;
        boolean hasBorderLayer;
        @Nullable
        ColorSet myColorSet;
        @NotNull
        Function<ScreenView, ImmutableList<Layer>> myLayersProvider;
        @NotNull
        private ContentSizePolicy myContentSizePolicy;
        @NotNull
        private SceneView.ShapePolicy myShapePolicy;

        private Builder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
            if (surface2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.isResizeable = false;
            this.myColorSet = null;
            this.myLayersProvider = DEFAULT_LAYERS_PROVIDER;
            this.myContentSizePolicy = DEVICE_CONTENT_SIZE_POLICY;
            this.myShapePolicy = SceneView.DEVICE_CONFIGURATION_SHAPE_POLICY;
            this.mySurface = surface2;
            this.myManager = manager;
            this.hasBorderLayer = manager.getModel().getType() instanceof LayoutEditorFileType;
        }

        @NotNull
        public Builder resizeable() {
            this.isResizeable = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder withColorSet(@NotNull ColorSet colorSet) {
            if (colorSet == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myColorSet = colorSet;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder withLayersProvider(@NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider) {
            if (layersProvider == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myLayersProvider = layersProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder withContentSizePolicy(@NotNull ContentSizePolicy contentSizePolicy) {
            if (contentSizePolicy == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myContentSizePolicy = contentSizePolicy;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder withShapePolicy(@NotNull SceneView.ShapePolicy shapePolicy) {
            if (shapePolicy == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myShapePolicy = shapePolicy;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder decorateContentSizePolicy(@NotNull Function<ContentSizePolicy, ContentSizePolicy> contentSizePolicyProvider) {
            if (contentSizePolicyProvider == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myContentSizePolicy = contentSizePolicyProvider.apply(this.myContentSizePolicy);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder disableBorder() {
            this.hasBorderLayer = false;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder2;
        }

        @NotNull
        public ScreenView build() {
            return new ScreenView(this.mySurface, this.myManager, this.myShapePolicy, this.isResizeable, this.hasBorderLayer, this.myColorSet == null ? new AndroidColorSet() : this.myColorSet, this.myLayersProvider, this.myContentSizePolicy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 8, 10, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenView$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorSet";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layersProvider";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentSizePolicy";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shapePolicy";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentSizePolicyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenView$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resizeable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withColorSet";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLayersProvider";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withContentSizePolicy";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShapePolicy";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorateContentSizePolicy";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "disableBorder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withColorSet";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withLayersProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withContentSizePolicy";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withShapePolicy";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "decorateContentSizePolicy";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 4, 6, 8, 10, 12, 13 -> new IllegalStateException(string2);
            };
        }
    }

    public static interface ContentSizePolicy {
        public void measure(@NotNull ScreenView var1, @NotNull Dimension var2);

        default public boolean hasContentSize(@NotNull ScreenView screenView) {
            if (screenView == null) {
                ContentSizePolicy.$$$reportNull$$$0(0);
            }
            if (!screenView.isVisible()) {
                return false;
            }
            RenderResult result = screenView.getSceneManager().getRenderResult();
            return result != null && !ScreenView.isErrorResult(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenView", "com/android/tools/idea/uibuilder/surface/ScreenView$ContentSizePolicy", "hasContentSize"));
        }
    }

    public static final class ImageContentSizePolicy
    implements ContentSizePolicy {
        @NotNull
        private final ContentSizePolicy mySizePolicyDelegate;
        private Dimension cachedDimension;

        public ImageContentSizePolicy(@NotNull ContentSizePolicy delegate) {
            if (delegate == null) {
                ImageContentSizePolicy.$$$reportNull$$$0(0);
            }
            this.cachedDimension = null;
            this.mySizePolicyDelegate = delegate;
        }

        @Override
        public void measure(@NotNull ScreenView screenView, @NotNull Dimension outDimension) {
            RenderResult result;
            if (screenView == null) {
                ImageContentSizePolicy.$$$reportNull$$$0(1);
            }
            if (outDimension == null) {
                ImageContentSizePolicy.$$$reportNull$$$0(2);
            }
            if ((result = screenView.getSceneManager().getRenderResult()) != null && result.getSystemRootViews().size() == 1) {
                ViewInfo viewInfo = (ViewInfo)result.getSystemRootViews().get(0);
                try {
                    if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
                        outDimension.setSize(Coordinates.pxToDp((SceneView)screenView, viewInfo.getRight()), Coordinates.pxToDp((SceneView)screenView, viewInfo.getBottom()));
                    } else {
                        outDimension.setSize(viewInfo.getRight(), viewInfo.getBottom());
                    }
                    if (this.cachedDimension == null) {
                        this.cachedDimension = new Dimension(outDimension);
                    } else {
                        this.cachedDimension.setSize(outDimension);
                    }
                    return;
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
            if (this.cachedDimension != null) {
                outDimension.setSize(this.cachedDimension);
                return;
            }
            this.mySizePolicyDelegate.measure(screenView, outDimension);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outDimension";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenView$ImageContentSizePolicy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "measure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

