/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolImageDisposer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConverter;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myCachedVisibleImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private final Rectangle myScreenViewVisibleRect;
    private final Dimension myScreenViewSize;
    private final Rectangle myCachedScreenViewDisplayRect;
    private double myLastScale;
    private final ColorConverter myImageFilter;
    private static final Color CLEAR_BACKGROUND = new Color(255, 255, 255, 0);

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this(screenView, ColorBlindMode.NONE);
    }

    public ScreenViewLayer(@NotNull ScreenView screenView, @NotNull ColorBlindMode colorBlindFilter) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        if (colorBlindFilter == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        this(screenView, colorBlindFilter == ColorBlindMode.NONE ? null : new ColorConverter(colorBlindFilter));
    }

    private ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ColorConverter imageFilter) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        this.myScreenViewVisibleRect = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myCachedScreenViewDisplayRect = new Rectangle();
        this.myScreenView = screenView;
        this.myLastScale = this.myScreenView.getScale();
        this.myImageFilter = imageFilter;
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
        if (this.myImageFilter != null) {
            Disposer.register((Disposable)this, (Disposable)this.myImageFilter);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage getPreviewImage(@NotNull GraphicsConfiguration configuration, @NotNull ImagePool.Image renderedImage, int screenViewX, int screenViewY, @NotNull Rectangle screenViewVisibleSize, double xScaleFactor, double yScaleFactor, @Nullable BufferedImage bufferedImage, boolean bl) {
        boolean clearBackground;
        BufferedImage image;
        void screenViewHasBorderLayer;
        BufferedImage existingBuffer;
        boolean bufferWithScreenViewSizeExists;
        if (configuration == null) {
            ScreenViewLayer.$$$reportNull$$$0(4);
        }
        if (renderedImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(5);
        }
        if (screenViewVisibleSize == null) {
            ScreenViewLayer.$$$reportNull$$$0(6);
        }
        int sx1 = (int)Math.round((double)(screenViewVisibleSize.x - screenViewX) * xScaleFactor);
        int sy1 = (int)Math.round((double)(screenViewVisibleSize.y - screenViewY) * yScaleFactor);
        int sx2 = sx1 + (int)Math.round((double)screenViewVisibleSize.width * xScaleFactor);
        int sy2 = sy1 + (int)Math.round((double)screenViewVisibleSize.height * yScaleFactor);
        boolean bl2 = bufferWithScreenViewSizeExists = existingBuffer != null && ImageUtil.getUserWidth((Image)existingBuffer) == screenViewVisibleSize.width && ImageUtil.getUserHeight((Image)existingBuffer) == screenViewVisibleSize.height;
        if (screenViewHasBorderLayer != false && bufferWithScreenViewSizeExists) {
            image = existingBuffer;
            clearBackground = true;
        } else {
            existingBuffer = image = ImageUtil.createImage((GraphicsConfiguration)configuration, (int)screenViewVisibleSize.width, (int)screenViewVisibleSize.height, (int)3);
            clearBackground = false;
        }
        int previewImageWidth = ImageUtil.getUserWidth((Image)image);
        int previewImageHeight = ImageUtil.getUserHeight((Image)image);
        Graphics2D cacheImageGraphics = image.createGraphics();
        if (clearBackground) {
            cacheImageGraphics.setColor(CLEAR_BACKGROUND);
            cacheImageGraphics.setComposite(AlphaComposite.Clear);
            cacheImageGraphics.fillRect(0, 0, previewImageWidth, previewImageHeight);
            cacheImageGraphics.setComposite(AlphaComposite.Src);
        }
        cacheImageGraphics.setRenderingHints(HQ_RENDERING_HINTS);
        renderedImage.drawImageTo((Graphics)cacheImageGraphics, 0, 0, previewImageWidth, previewImageHeight, sx1, sy1, sx2, sy2);
        cacheImageGraphics.dispose();
        BufferedImage bufferedImage2 = existingBuffer;
        if (bufferedImage2 == null) {
            ScreenViewLayer.$$$reportNull$$$0(7);
        }
        return bufferedImage2;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        if (graphics2D == null) {
            ScreenViewLayer.$$$reportNull$$$0(8);
        }
        this.myScreenView.getScaledContentSize(this.myScreenViewSize);
        this.myScreenViewVisibleRect.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle clipBounds = graphics2D.getClipBounds();
        if (!this.myScreenViewVisibleRect.intersects((Rectangle2D)clipBounds)) {
            return;
        }
        if ((double)this.myScreenViewVisibleRect.width > ((RectangularShape)clipBounds).getWidth() || (double)this.myScreenViewVisibleRect.height > ((RectangularShape)clipBounds).getHeight()) {
            Rectangle2D.intersect(this.myScreenViewVisibleRect, clipBounds, this.myScreenViewVisibleRect);
        }
        BufferedImage previousVisibleImage = this.myCachedVisibleImage;
        RenderResult renderResult = this.myScreenView.getResult();
        boolean drawNewImg = false;
        if (this.newRenderImageAvailable(renderResult)) {
            this.setLastRenderResult(renderResult);
            this.myScreenView.getScene().needsRebuildList();
            drawNewImg = true;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        BufferedImage[] cachedVisibleImage = new BufferedImage[]{drawNewImg ? null : previousVisibleImage};
        double currentScale = this.myScreenView.getScale();
        if ((drawNewImg || currentScale != this.myLastScale || !this.myScreenViewVisibleRect.equals(this.myCachedScreenViewDisplayRect)) && this.myLastRenderResult != null) {
            ImagePool.Image image = this.myLastRenderResult.getRenderedImage();
            ImagePoolImageDisposer.runWithDisposeLock((ImagePool.Image)image, theImage -> {
                if (theImage.isValid()) {
                    int resultImageWidth = theImage.getWidth();
                    int resultImageHeight = theImage.getHeight();
                    this.myCachedScreenViewDisplayRect.setBounds(this.myScreenViewVisibleRect);
                    double xScaleFactor = (double)resultImageWidth / (double)this.myScreenViewSize.width;
                    double yScaleFactor = (double)resultImageHeight / (double)this.myScreenViewSize.height;
                    cachedVisibleImage[0] = ScreenViewLayer.getPreviewImage(g.getDeviceConfiguration(), theImage, this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewVisibleRect, xScaleFactor, yScaleFactor, previousVisibleImage, this.myScreenView.hasBorderLayer());
                    this.myCachedVisibleImage = cachedVisibleImage[0];
                    this.myLastScale = currentScale;
                } else {
                    cachedVisibleImage[0] = this.myCachedVisibleImage;
                }
            });
        }
        if (cachedVisibleImage[0] != null) {
            NlDesignSurface surface2;
            float degree;
            Shape screenShape = this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g.clip(screenShape);
            }
            if (!Float.isNaN(degree = (surface2 = this.myScreenView.getSurface()).getRotateSurfaceDegree())) {
                g.rotate(Math.toRadians(degree), this.myScreenView.getX() + this.myScreenViewSize.width / 2, this.myScreenView.getY() + this.myScreenViewSize.height / 2);
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)cachedVisibleImage[0], (int)this.myScreenViewVisibleRect.x, (int)this.myScreenViewVisibleRect.y, null);
        }
        g.dispose();
    }

    protected void setLastRenderResult(@Nullable RenderResult result) {
        this.myLastRenderResult = result;
        if (this.myImageFilter == null || result == null) {
            return;
        }
        result.processImageIfNotDisposed(image -> {
            if (image == null) {
                return;
            }
            BufferedImage copy = image.getCopy();
            if (copy == null) {
                return;
            }
            this.myImageFilter.convert(copy, copy);
            image.paint(g2D -> {
                int w = image.getWidth();
                int h = image.getHeight();
                g2D.drawImage(copy, 0, 0, w, h, 0, 0, w, h, null);
            });
        });
    }

    private boolean newRenderImageAvailable(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.getRenderResult().isSuccess() && renderResult.getRenderedImage().isValid() && renderResult != this.myLastRenderResult;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setLastRenderResult(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorBlindFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderedImage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenViewVisibleSize";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics2D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewImage";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }
}

