/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.layer;

import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.layer.BorderColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/uibuilder/surface/layer/BorderPainter;", "", "()V", "paint", "", "g2d", "Ljava/awt/Graphics2D;", "screenView", "Lcom/android/tools/idea/common/surface/SceneView;", "colorConfig", "Lcom/android/tools/idea/uibuilder/surface/layer/BorderColor;", "intellij.android.designer"})
final class BorderPainter {
    @NotNull
    public static final BorderPainter INSTANCE = new BorderPainter();

    private BorderPainter() {
    }

    public final void paint(@NotNull Graphics2D g2d, @NotNull SceneView screenView, @NotNull BorderColor colorConfig) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)((Object)colorConfig), (String)"colorConfig");
        int borderSize = JBUI.scale((int)colorConfig.getSize$intellij_android_designer());
        GradientPaint gradLeft = new GradientPaint(0.0f, 0.0f, colorConfig.getColorOutside$intellij_android_designer(), borderSize, 0.0f, colorConfig.getColorInside$intellij_android_designer());
        GradientPaint gradTop = new GradientPaint(0.0f, 0.0f, colorConfig.getColorOutside$intellij_android_designer(), 0.0f, borderSize, colorConfig.getColorInside$intellij_android_designer());
        GradientPaint gradRight = new GradientPaint(0.0f, 0.0f, colorConfig.getColorInside$intellij_android_designer(), borderSize, 0.0f, colorConfig.getColorOutside$intellij_android_designer());
        GradientPaint gradBottom = new GradientPaint(0.0f, 0.0f, colorConfig.getColorInside$intellij_android_designer(), 0.0f, borderSize, colorConfig.getColorOutside$intellij_android_designer());
        Object[] objectArray = new float[]{0.0f, 1.0f};
        float[] fArray = objectArray;
        objectArray = new Color[2];
        objectArray[0] = (float)colorConfig.getColorInside$intellij_android_designer();
        objectArray[1] = (float)colorConfig.getColorOutside$intellij_android_designer();
        RadialGradientPaint gradCorner = new RadialGradientPaint(borderSize, (float)borderSize, borderSize, fArray, (Color[])objectArray);
        Dimension dimension = screenView.getScaledContentSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"screenView.scaledContentSize");
        Dimension size = dimension;
        int x = screenView.getX();
        int y = screenView.getY();
        RenderingHints hints = g2d.getRenderingHints();
        AffineTransform tx = g2d.getTransform();
        Paint paint = g2d.getPaint();
        g2d.translate(x - borderSize, y);
        g2d.scale(1.0, (double)size.height / (double)borderSize);
        g2d.setPaint(gradLeft);
        g2d.fillRect(0, 0, borderSize, borderSize);
        g2d.translate(size.width + borderSize, 0);
        g2d.setPaint(gradRight);
        g2d.fillRect(0, 0, borderSize, borderSize);
        g2d.translate(-size.width, 0);
        g2d.scale(1.0, (double)borderSize / (double)size.height);
        g2d.translate(0, -borderSize);
        g2d.scale((double)size.width / (double)borderSize, 1.0);
        g2d.setPaint(gradTop);
        g2d.fillRect(0, 0, borderSize, borderSize);
        g2d.translate(0, size.height + borderSize);
        g2d.setPaint(gradBottom);
        g2d.fillRect(0, 0, borderSize, borderSize);
        g2d.setTransform(tx);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(gradCorner);
        g2d.translate(x - borderSize, y - borderSize);
        g2d.fillArc(0, 0, borderSize * 2, borderSize * 2, 90, 90);
        g2d.translate(size.width, 0);
        g2d.fillArc(0, 0, borderSize * 2, borderSize * 2, 0, 90);
        g2d.translate(0, size.height);
        g2d.fillArc(0, 0, borderSize * 2, borderSize * 2, 270, 90);
        g2d.translate(-size.width, 0);
        g2d.fillArc(0, 0, borderSize * 2, borderSize * 2, 180, 90);
        g2d.setTransform(tx);
        g2d.setRenderingHints(hints);
        g2d.setPaint(paint);
    }
}

