/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.troubleshooting;

import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.uibuilder.troubleshooting.DesignToolsTroubleInfoCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/troubleshooting/DesignToolsDiagnosticsSummaryFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "()V", "name", "", "getName", "()Ljava/lang/String;", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.designer"})
public final class DesignToolsDiagnosticsSummaryFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    private final String name;

    public DesignToolsDiagnosticsSummaryFileProvider() {
        this.name = "Design Tools";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        String string2 = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLogPath()");
        Path outputFile = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string2).resolve("DesignTools.log");
        Files.writeString(outputFile, (CharSequence)new DesignToolsTroubleInfoCollector(null, 1, null).collectInfo(project), new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
        Path path = Paths.get("DesignTools.log", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(outputLogFileName)");
        return CollectionsKt.listOf((Object)new FileInfo(outputFile, path));
    }
}

