/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.visual.VisualizationEditorChangeHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/uibuilder/visual/MyFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "visualizationEditorChangeHandler", "Lcom/android/tools/idea/uibuilder/visual/VisualizationEditorChangeHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/android/tools/idea/uibuilder/visual/VisualizationEditorChangeHandler;)V", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "getActiveLayoutEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/psi/PsiFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nVisualizationToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualizationToolWindowFactory.kt\ncom/android/tools/idea/uibuilder/visual/MyFileEditorManagerListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1282#2:198\n1283#2:200\n1#3:199\n*S KotlinDebug\n*F\n+ 1 VisualizationToolWindowFactory.kt\ncom/android/tools/idea/uibuilder/visual/MyFileEditorManagerListener\n*L\n191#1:198\n191#1:200\n*E\n"})
final class MyFileEditorManagerListener
implements FileEditorManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @NotNull
    private final VisualizationEditorChangeHandler visualizationEditorChangeHandler;

    public MyFileEditorManagerListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull VisualizationEditorChangeHandler visualizationEditorChangeHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)visualizationEditorChangeHandler, (String)"visualizationEditorChangeHandler");
        this.project = project;
        this.toolWindow = toolWindow;
        this.visualizationEditorChangeHandler = visualizationEditorChangeHandler;
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(file2);
        FileEditor fileEditor = this.getActiveLayoutEditor(psiFile2);
        if (fileEditor != null) {
            this.visualizationEditorChangeHandler.onFileEditorChange(fileEditor, this.project, this.toolWindow);
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.visualizationEditorChangeHandler.onFileClose(source, this.toolWindow, file2);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        PsiFile psiFile2;
        VirtualFile newVirtualFile;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor editorForLayout = null;
        FileEditor newEditor = event.getNewEditor();
        if (newEditor != null && (newVirtualFile = newEditor.getFile()) != null && IdeResourcesUtil.getFolderType((PsiFile)(psiFile2 = PsiManager.getInstance((Project)this.project).findFile(newVirtualFile))) == ResourceFolderType.LAYOUT) {
            editorForLayout = newEditor;
        }
        this.visualizationEditorChangeHandler.onFileEditorChange(editorForLayout, this.project, this.toolWindow);
    }

    private final FileEditor getActiveLayoutEditor(PsiFile file2) {
        return (FileEditor)ApplicationManager.getApplication().runReadAction(() -> MyFileEditorManagerListener.getActiveLayoutEditor$lambda$2(this, file2));
    }

    private static final FileEditor getActiveLayoutEditor$lambda$2(MyFileEditorManagerListener this$0, PsiFile $file) {
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this$0.project).getSelectedEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getInstance(project).selectedEditors");
            Object[] $this$firstOrNull$iv = fileEditorArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                VirtualFile virtualFile2;
                FileEditor editor = (FileEditor)element$iv;
                boolean bl2 = false;
                VirtualFile virtualFile3 = virtualFile2 = editor.getFile();
                if (virtualFile3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"file");
                    VirtualFile editorFile = virtualFile2;
                    boolean bl3 = false;
                    bl = Intrinsics.areEqual((Object)editorFile, (Object)$file);
                } else {
                    bl = false;
                }
                if (!bl) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        return (FileEditor)object;
    }
}

