/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorLut;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorUtilKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import com.intellij.openapi.Disposable;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter;", "Lcom/intellij/openapi/Disposable;", "mode", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "(Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;)V", "cbmCLut", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "getMode", "()Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "alphaCorrect", "", "color", "convert", "", "startImage", "Ljava/awt/image/BufferedImage;", "postImage", "dispose", "", "Companion", "intellij.android.designer"})
public final class ColorConverter
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorBlindMode mode;
    @Nullable
    private ColorLut cbmCLut;
    @Nullable
    private static double[] removeGammaCLut;

    public ColorConverter(@NotNull ColorBlindMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
    }

    @NotNull
    public final ColorBlindMode getMode() {
        return this.mode;
    }

    public final boolean convert(@NotNull BufferedImage startImage, @NotNull BufferedImage postImage) {
        Intrinsics.checkNotNullParameter((Object)startImage, (String)"startImage");
        Intrinsics.checkNotNullParameter((Object)postImage, (String)"postImage");
        if (this.cbmCLut == null || removeGammaCLut == null) {
            removeGammaCLut = ColorUtilKt.buildGammaCLut(ColorConverter::convert$lambda$0);
            Intrinsics.checkNotNull((Object)removeGammaCLut);
            this.cbmCLut = ColorUtilKt.buildColorLut(16, this.mode, removeGammaCLut);
        }
        if (startImage.getType() != 2 || postImage.getType() != 2) {
            System.out.println((Object)"Error:: BufferedImage not supported for color blind mode.");
            return false;
        }
        DataBuffer dataBuffer = startImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] inData = ((DataBufferInt)dataBuffer).getData();
        DataBuffer dataBuffer2 = postImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] outData = ((DataBufferInt)dataBuffer2).getData();
        int n = inData.length;
        for (int i = 0; i < n; ++i) {
            ColorLut colorLut = this.cbmCLut;
            Intrinsics.checkNotNull((Object)colorLut);
            outData[i] = 0xFF000000 | colorLut.interpolate(this.alphaCorrect(inData[i]));
        }
        return true;
    }

    private final int alphaCorrect(int color2) {
        double a = (double)MathUtilKt.a(color2) / 255.0;
        double whiteBg = (1.0 - a) * (double)255;
        return MathUtilKt.combine(a * (double)MathUtilKt.r(color2) + whiteBg, a * (double)MathUtilKt.g(color2) + whiteBg, a * (double)MathUtilKt.b(color2) + whiteBg);
    }

    public void dispose() {
        removeGammaCLut = null;
        this.cbmCLut = null;
    }

    private static final Double convert$lambda$0(Double it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.pow(it / 255.0, 2.2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter$Companion;", "", "()V", "removeGammaCLut", "", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

