/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint;

import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintServiceKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "visualLintAnalyzerExecutorService", "Ljava/util/concurrent/ExecutorService;", "visualLintExecutorService", "visualLintTimeout", "", "createRenderResult", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "requireRender", "", "intellij.android.designer"})
public final class VisualLintServiceKt {
    @NotNull
    private static final ExecutorService visualLintExecutorService;
    @NotNull
    private static final ExecutorService visualLintAnalyzerExecutorService;
    private static final long visualLintTimeout;
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final CompletableFuture<RenderResult> createRenderResult(@NotNull NlModel model2, boolean requireRender) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Project project = model2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"model.project");
        RenderService renderService = StudioRenderService.Companion.getInstance(project);
        RenderLogger logger2 = StudioRenderServiceKt.createLogger((RenderService)renderService, (Project)model2.getProject());
        AndroidFacet androidFacet = model2.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"model.facet");
        Configuration configuration = model2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"model.configuration");
        CompletionStage completionStage = StudioRenderServiceKt.taskBuilder((RenderService)renderService, (AndroidFacet)androidFacet, (Configuration)configuration, (RenderLogger)logger2).withPsiFile(model2.getFile()).withLayoutScanner(Boolean.valueOf(requireRender)).withPriority(RenderAsyncActionExecutor.RenderingPriority.LOW).withMinDownscalingFactor(0.25f).withQuality(0.0f).build().thenCompose(arg_0 -> VisualLintServiceKt.createRenderResult$lambda$0((Function1)new Function1<RenderTask, CompletionStage<RenderResult>>(logger2, requireRender){
            final /* synthetic */ RenderLogger $logger;
            final /* synthetic */ boolean $requireRender;
            {
                this.$logger = $logger;
                this.$requireRender = $requireRender;
                super(1);
            }

            public final CompletionStage<RenderResult> invoke(RenderTask newTask) {
                if (newTask == null) {
                    this.$logger.error("INFLATE", "Error inflating view for visual lint on background. No RenderTask Created.", null, null, null);
                    return CompletableFuture.failedFuture(new IllegalArgumentException());
                }
                CompletableFuture completableFuture = this.$requireRender ? newTask.render() : newTask.inflate();
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"if (requireRender) newTa\u2026() else newTask.inflate()");
                CompletableFuture renderResult = completableFuture;
                return renderResult.whenComplete((arg_0, arg_1) -> createRenderResult.1.invoke$lambda$0((Function2)new Function2<RenderResult, Throwable, Unit>(this.$logger, newTask){
                    final /* synthetic */ RenderLogger $logger;
                    final /* synthetic */ RenderTask $newTask;
                    {
                        this.$logger = $logger;
                        this.$newTask = $newTask;
                        super(2);
                    }

                    public final void invoke(RenderResult result, Throwable inflateException) {
                        Throwable exception;
                        Throwable throwable = inflateException;
                        if (throwable == null) {
                            throwable = result.getRenderResult().getException();
                        }
                        if ((exception = throwable) != null || result == null) {
                            this.$logger.error("INFLATE", "Error inflating views for visual lint on background", exception, null, null);
                        }
                        this.$newTask.dispose();
                    }
                }, arg_0, arg_1));
            }

            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"requireRender: Boolean):\u2026k.dispose()\n      }\n    }");
        return completionStage;
    }

    private static final CompletionStage createRenderResult$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ExecutorService access$getVisualLintExecutorService$p() {
        return visualLintExecutorService;
    }

    public static final /* synthetic */ ExecutorService access$getVisualLintAnalyzerExecutorService$p() {
        return visualLintAnalyzerExecutorService;
    }

    public static final /* synthetic */ long access$getVisualLintTimeout$p() {
        return visualLintTimeout;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Visual Lint Service", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026\"Visual Lint Service\", 1)");
        visualLintExecutorService = executorService;
        ExecutorService executorService2 = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Visual Lint Analyzer", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"createBoundedApplication\u2026Visual Lint Analyzer\", 1)");
        visualLintAnalyzerExecutorService = executorService2;
        visualLintTimeout = ApplicationManager.getApplication().isUnitTestMode() ? 30L : 5L;
        Logger logger2 = Logger.getInstance(VisualLintService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(VisualLintService::class.java)");
        LOG = logger2;
    }
}

