/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BottomAppBarAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BottomAppBarAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BottomAppBarAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nBottomAppBarAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BottomAppBarAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BottomAppBarAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 BottomAppBarAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BottomAppBarAnalyzer\n*L\n53#1:84,2\n*E\n"})
public final class BottomAppBarAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final BottomAppBarAnalyzer INSTANCE = new BottomAppBarAnalyzer();

    private BottomAppBarAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.BOTTOM_APP_BAR;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return BottomAppBarAnalyzerInspection.INSTANCE.getBottomAppBarBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        Configuration configuration = model2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"model.configuration");
        Configuration configuration2 = configuration;
        State state = configuration2.getDeviceState();
        Object object = state != null ? state.getOrientation() : null;
        if (object == null) {
            return issues;
        }
        ScreenOrientation orientation2 = object;
        Device device = configuration2.getDevice();
        Dimension dimension = device != null ? device.getScreenSize(orientation2) : null;
        if (dimension == null) {
            return issues;
        }
        Dimension dimension2 = dimension;
        int width2 = Coordinates.pxToDp(model2, dimension2.width);
        int height2 = Coordinates.pxToDp(model2, dimension2.height);
        if (width2 > 600 && height2 > 360) {
            ImmutableList immutableList = renderResult.getRootViews();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
            ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
            while (!((Collection)viewsToAnalyze).isEmpty()) {
                ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
                List list = view2.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ViewInfo it = (ViewInfo)element$iv;
                    boolean bl = false;
                    viewsToAnalyze.addLast((Object)it);
                }
                if (!Intrinsics.areEqual((Object)view2.getClassName(), (Object)"com.google.android.material.bottomappbar.BottomAppBar")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
                issues.add(this.createIssueContent(view2));
            }
        }
        return issues;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view2) {
        Function1 content2 = createIssueContent.content.1.INSTANCE;
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, "Bottom app bars are only recommended for compact screens", (Function1<? super Integer, ? extends HtmlBuilder>)content2);
    }

    public static final /* synthetic */ String access$previewConfigurations(BottomAppBarAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }
}

