/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.widget.ScrollView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BoundsAnalyzerInspection;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.BoundsAnalyzerKt;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BoundsAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "isOutOfBounds", "child", "width", "", "height", "isScrollingView", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nBoundsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundsAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BoundsAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n819#2:99\n847#2,2:100\n1855#2,2:102\n12744#3,2:104\n*S KotlinDebug\n*F\n+ 1 BoundsAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/BoundsAnalyzer\n*L\n48#1:99\n48#1:100,2\n53#1:102,2\n89#1:104,2\n*E\n"})
public final class BoundsAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final BoundsAnalyzer INSTANCE = new BoundsAnalyzer();

    private BoundsAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.BOUNDS;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return BoundsAnalyzerInspection.INSTANCE.getBoundsBackground();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        ViewInfo it;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
        Iterable $this$filterNot$iv = (Iterable)immutableList;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ViewInfo)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (INSTANCE.isScrollingView(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ArrayDeque viewsToAnalyze = new ArrayDeque(collection);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
            int width2 = view2.getRight() - view2.getLeft();
            int height2 = view2.getBottom() - view2.getTop();
            List list = view2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ViewInfo)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (INSTANCE.isScrollingView(it)) continue;
                viewsToAnalyze.addLast((Object)it);
                if (!INSTANCE.isOutOfBounds(it, width2, height2)) continue;
                issues.add(INSTANCE.createIssueContent(it));
            }
        }
        return issues;
    }

    private final boolean isOutOfBounds(ViewInfo child, int width2, int height2) {
        return child.getTop() < 0 || child.getBottom() > height2 || child.getLeft() < 0 || child.getRight() > width2;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view2) {
        String viewName = this.simpleName(view2);
        String summary = this.nameWithId(view2) + " is partially hidden in layout";
        Function1 provider2 = (Function1)new Function1<Integer, HtmlBuilder>(viewName){
            final /* synthetic */ String $viewName;
            {
                this.$viewName = $viewName;
                super(1);
            }

            public final HtmlBuilder invoke(int count) {
                return new HtmlBuilder().add(this.$viewName + " is partially hidden in layout because it is not contained within the bounds of its parent in " + BoundsAnalyzer.access$previewConfigurations(BoundsAnalyzer.INSTANCE, count) + ".").newline().add("Fix this issue by adjusting the size or position of " + this.$viewName + ".");
            }
        };
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)provider2);
    }

    private final boolean isScrollingView(ViewInfo view2) {
        boolean bl;
        block2: {
            if (view2.getViewObject() instanceof ScrollView) {
                return true;
            }
            Class<?>[] classArray = view2.getViewObject().getClass().getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"view.viewObject.javaClass.interfaces");
            Object[] $this$any$iv = classArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                if (!BoundsAnalyzerKt.access$getScrollViewInterfaces$p().contains(it.getName())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String access$previewConfigurations(BoundsAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }
}

