/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.view.View;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.OverlapAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002J0\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/OverlapAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "firstView", "Lcom/android/ide/common/rendering/api/ViewInfo;", "secondView", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "findOverlapOfTextViewIssues", "", "view", "issueList", "", "isFirstViewUnderneath", "firstViewInfo", "firstViewIndex", "", "secondViewInfo", "secondViewIndex", "isPartiallyHidden", "i", "j", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nOverlapAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlapAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/OverlapAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1855#2,2:142\n766#2:144\n857#2,2:145\n*S KotlinDebug\n*F\n+ 1 OverlapAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/OverlapAnalyzer\n*L\n52#1:142,2\n59#1:144\n59#1:145,2\n*E\n"})
public final class OverlapAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final OverlapAnalyzer INSTANCE = new OverlapAnalyzer();

    private OverlapAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.OVERLAP;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return OverlapAnalyzerInspection.INSTANCE.getOverlapBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
            this.findOverlapOfTextViewIssues(view2, model2, issues);
        }
        return issues;
    }

    /*
     * Unable to fully structure code
     */
    private final void findOverlapOfTextViewIssues(ViewInfo view, NlModel model, List<VisualLintAnalyzer.VisualLintIssueContent> issueList) {
        v0 = view.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"view.children");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ViewInfo)element$iv$iv;
            $i$a$-filter-OverlapAnalyzer$findOverlapOfTextViewIssues$children$1 = false;
            if (it.getCookie() == null) ** GOTO lbl-1000
            var14_15 = it.getViewObject();
            v1 = var14_15 instanceof View != false ? (View)var14_15 : null;
            v2 = v1 != null ? v1.getVisibility() == 0 : false;
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        children = (List)destination$iv$iv;
        var6_6 = children.size();
        for (i = 0; i < var6_6; ++i) {
            firstView = (ViewInfo)children.get(i);
            if (!(firstView.getViewObject() instanceof TextView)) continue;
            var9_10 = children.size();
            for (j = 0; j < var9_10; ++j) {
                secondView = (ViewInfo)children.get(j);
                if (Intrinsics.areEqual((Object)firstView, (Object)secondView)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)firstView, (String)"firstView");
                Intrinsics.checkNotNullExpressionValue((Object)secondView, (String)"secondView");
                if (!this.isPartiallyHidden(firstView, i, secondView, j, model)) continue;
                issueList.add(this.createIssueContent(firstView, secondView));
            }
        }
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo firstView, ViewInfo secondView) {
        String summary = this.nameWithId(firstView) + " is covered by " + this.nameWithId(secondView);
        Function1 content2 = (Function1)new Function1<Integer, HtmlBuilder>(firstView, secondView){
            final /* synthetic */ ViewInfo $firstView;
            final /* synthetic */ ViewInfo $secondView;
            {
                this.$firstView = $firstView;
                this.$secondView = $secondView;
                super(1);
            }

            public final HtmlBuilder invoke(int count) {
                return new HtmlBuilder().add("Content of " + OverlapAnalyzer.access$nameWithId(OverlapAnalyzer.INSTANCE, this.$firstView) + " is partially covered by " + OverlapAnalyzer.access$nameWithId(OverlapAnalyzer.INSTANCE, this.$secondView) + " in " + OverlapAnalyzer.access$previewConfigurations(OverlapAnalyzer.INSTANCE, count) + ".").newline().add("This may affect text readability. Fix this issue by adjusting widget positioning.");
            }
        };
        return new VisualLintAnalyzer.VisualLintIssueContent(firstView, summary, (Function1<? super Integer, ? extends HtmlBuilder>)content2);
    }

    private final boolean isPartiallyHidden(ViewInfo firstViewInfo, int i, ViewInfo secondViewInfo, int j, NlModel model2) {
        Rectangle secondBounds;
        if (!this.isFirstViewUnderneath(firstViewInfo, i, secondViewInfo, j, model2)) {
            return false;
        }
        int firstWidth = firstViewInfo.getRight() - firstViewInfo.getLeft();
        int firstHeight = firstViewInfo.getBottom() - firstViewInfo.getTop();
        if (firstWidth == 0 || firstHeight == 0) {
            return false;
        }
        Rectangle firstBounds = new Rectangle(firstViewInfo.getLeft(), firstViewInfo.getTop(), firstWidth, firstHeight);
        Rectangle intersection = firstBounds.intersection(secondBounds = new Rectangle(secondViewInfo.getLeft(), secondViewInfo.getTop(), secondViewInfo.getRight() - secondViewInfo.getLeft(), secondViewInfo.getBottom() - secondViewInfo.getTop()));
        if (intersection.isEmpty()) {
            return false;
        }
        double coveredRatio = 1.0 * (double)intersection.width * (double)intersection.height / (double)(firstWidth * firstHeight);
        return coveredRatio >= 0.5;
    }

    private final boolean isFirstViewUnderneath(ViewInfo firstViewInfo, int firstViewIndex, ViewInfo secondViewInfo, int secondViewIndex, NlModel model2) {
        NlComponent comp1 = this.componentFromViewInfo(firstViewInfo, model2);
        NlComponent comp2 = this.componentFromViewInfo(secondViewInfo, model2);
        if (comp1 != null && comp2 != null) {
            int elev2;
            int elev1 = ConstraintComponentUtilities.getDpValue(comp1, comp1.getAttribute("http://schemas.android.com/apk/res/android", "elevation"));
            if (elev1 < (elev2 = ConstraintComponentUtilities.getDpValue(comp2, comp2.getAttribute("http://schemas.android.com/apk/res/android", "elevation")))) {
                return true;
            }
            if (elev1 > elev2) {
                return false;
            }
        }
        return firstViewIndex < secondViewIndex;
    }

    public static final /* synthetic */ String access$nameWithId(OverlapAnalyzer $this, ViewInfo viewInfo) {
        return $this.nameWithId(viewInfo);
    }

    public static final /* synthetic */ String access$previewConfigurations(OverlapAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }
}

