/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.ClassNameCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.ClickableSpanCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.DuplicateClickableBoundsCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.DuplicateSpeakableTextCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.EditableContentDescCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.ImageContrastCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.LinkPurposeUnclearCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.RedundantDescriptionCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.SpeakableTextPresentCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TextContrastCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TextSizeCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TouchTargetSizeCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.TraversalOrderCheck;
import com.google.android.apps.common.testing.accessibility.framework.checks.UnexposedTextCheck;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum AccessibilityCheckPreset {
    LATEST,
    VERSION_1_0_CHECKS,
    VERSION_2_0_CHECKS,
    VERSION_3_0_CHECKS,
    VERSION_3_1_CHECKS,
    VERSION_4_0_CHECKS,
    NO_CHECKS,
    PRERELEASE;

    private static final ImmutableClassToInstanceMap<AccessibilityHierarchyCheck> CLASS_TO_HIERARCHY_CHECK;
    private static final ImmutableMap<String, AccessibilityHierarchyCheck> CLASS_NAME_TO_HIERARCHY_CHECK;

    public static @Nullable AccessibilityHierarchyCheck getHierarchyCheckForClass(Class<? extends AccessibilityHierarchyCheck> clazz) {
        return (AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(clazz);
    }

    public static @Nullable AccessibilityHierarchyCheck getHierarchyCheckForClassName(String className) {
        return (AccessibilityHierarchyCheck)CLASS_NAME_TO_HIERARCHY_CHECK.get((Object)className);
    }

    public static ImmutableSet<AccessibilityHierarchyCheck> getAccessibilityHierarchyChecksForPreset(AccessibilityCheckPreset preset) {
        ImmutableSet.Builder checks = ImmutableSet.builder();
        if (preset == NO_CHECKS) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(SpeakableTextPresentCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(EditableContentDescCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(TouchTargetSizeCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(DuplicateSpeakableTextCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(TextContrastCheck.class)));
        if (preset == VERSION_1_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(ClickableSpanCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(DuplicateClickableBoundsCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(RedundantDescriptionCheck.class)));
        if (preset == VERSION_2_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(ImageContrastCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(ClassNameCheck.class)));
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(TraversalOrderCheck.class)));
        if (preset == VERSION_3_0_CHECKS) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(LinkPurposeUnclearCheck.class)));
        if (preset == VERSION_3_1_CHECKS) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(TextSizeCheck.class)));
        if (preset == VERSION_4_0_CHECKS) {
            return checks.build();
        }
        if (preset == LATEST) {
            return checks.build();
        }
        checks.add((Object)((AccessibilityHierarchyCheck)CLASS_TO_HIERARCHY_CHECK.get(UnexposedTextCheck.class)));
        if (preset == PRERELEASE) {
            return checks.build();
        }
        throw new IllegalArgumentException();
    }

    private static ImmutableMap<String, AccessibilityHierarchyCheck> mapClassNameToInstance(ImmutableClassToInstanceMap<AccessibilityHierarchyCheck> classToInstanceMap) {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (Map.Entry entry : classToInstanceMap.entrySet()) {
            builder2.put((Object)((Class)entry.getKey()).getName(), (Object)((AccessibilityHierarchyCheck)entry.getValue()));
        }
        return builder2.buildOrThrow();
    }

    static {
        CLASS_TO_HIERARCHY_CHECK = new ImmutableClassToInstanceMap.Builder().put(SpeakableTextPresentCheck.class, (Object)new SpeakableTextPresentCheck()).put(EditableContentDescCheck.class, (Object)new EditableContentDescCheck()).put(TouchTargetSizeCheck.class, (Object)new TouchTargetSizeCheck()).put(DuplicateSpeakableTextCheck.class, (Object)new DuplicateSpeakableTextCheck()).put(TextContrastCheck.class, (Object)new TextContrastCheck()).put(ClickableSpanCheck.class, (Object)new ClickableSpanCheck()).put(DuplicateClickableBoundsCheck.class, (Object)new DuplicateClickableBoundsCheck()).put(RedundantDescriptionCheck.class, (Object)new RedundantDescriptionCheck()).put(ImageContrastCheck.class, (Object)new ImageContrastCheck()).put(ClassNameCheck.class, (Object)new ClassNameCheck()).put(TraversalOrderCheck.class, (Object)new TraversalOrderCheck()).put(LinkPurposeUnclearCheck.class, (Object)new LinkPurposeUnclearCheck()).put(TextSizeCheck.class, (Object)new TextSizeCheck()).put(UnexposedTextCheck.class, (Object)new UnexposedTextCheck()).build();
        CLASS_NAME_TO_HIERARCHY_CHECK = AccessibilityCheckPreset.mapClassNameToInstance(CLASS_TO_HIERARCHY_CHECK);
    }
}

