/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityCheckResultDescriptor {
    public String describeResult(AccessibilityCheckResult result) {
        StringBuilder message = new StringBuilder();
        if (result instanceof AccessibilityViewCheckResult) {
            View view2 = ((AccessibilityViewCheckResult)result).getView();
            message.append(view2 != null ? this.describeView(view2) : this.describeElement(((AccessibilityViewCheckResult)result).getAccessibilityHierarchyCheckResult().getElement()));
            message.append(": ");
        } else if (result instanceof AccessibilityHierarchyCheckResult) {
            message.append(this.describeElement(((AccessibilityHierarchyCheckResult)result).getElement()));
            message.append(": ");
        }
        message.append(result.getMessage(Locale.ENGLISH));
        Class<? extends AccessibilityCheck> checkClass = result.getSourceCheckClass();
        if (checkClass != null) {
            String helpUrl;
            message.append(" Reported by ");
            message.append(result.getSourceCheckClass().getName());
            if (result instanceof AccessibilityHierarchyCheckResult && (helpUrl = ((AccessibilityHierarchyCheckResult)result).getHelpUrl()) != null) {
                message.append(". Learn more at ").append(helpUrl);
            }
        }
        return message.toString();
    }

    public String describeView(@Nullable View view2) {
        StringBuilder message = new StringBuilder();
        if (view2 != null && view2.getId() != -1 && view2.getId() != 0 && view2.getResources() != null && !ViewAccessibilityUtils.isViewIdGenerated(view2.getId())) {
            message.append("View ");
            try {
                message.append(view2.getResources().getResourceEntryName(view2.getId()));
            }
            catch (Exception e) {
                message.append("with no valid resource name");
            }
        } else {
            message.append("View with no valid resource name");
        }
        return message.toString();
    }

    public String describeElement(@Nullable ViewHierarchyElement element) {
        if (element == null) {
            return "<null>";
        }
        StringBuilder message = new StringBuilder();
        message.append("View ");
        if (!TextUtils.isEmpty(element.getResourceName())) {
            message.append(element.getResourceName());
        } else {
            Rect bounds2 = element.getBoundsInScreen();
            if (!bounds2.isEmpty()) {
                message.append("with bounds: ");
                message.append(bounds2.toShortString());
            } else {
                message.append("with no valid resource name or bounds");
            }
        }
        return message.toString();
    }
}

