/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.QuestionHandler;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AccessibilityHierarchyCheck
extends AccessibilityCheck {
    private static final String ANDROID_A11Y_HELP_URL = "https://support.google.com/accessibility/android/answer/%s";

    protected abstract @Nullable String getHelpTopic();

    public @Nullable String getHelpUrl() {
        String topic = this.getHelpTopic();
        return topic == null ? null : String.format(ANDROID_A11Y_HELP_URL, this.getHelpTopic());
    }

    public abstract AccessibilityCheck.Category getCategory();

    @Beta
    public @Nullable QuestionHandler getQuestionHandler() {
        return null;
    }

    public abstract String getTitleMessage(Locale var1);

    public String getMessageForResult(Locale locale, AccessibilityHierarchyCheckResult result) {
        return this.getMessageForResultData(locale, result.getResultId(), result.getMetadata());
    }

    public abstract String getMessageForResultData(Locale var1, int var2, @Nullable ResultMetadata var3);

    public String getShortMessageForResult(Locale locale, AccessibilityHierarchyCheckResult result) {
        return this.getShortMessageForResultData(locale, result.getResultId(), result.getMetadata());
    }

    public abstract String getShortMessageForResultData(Locale var1, int var2, @Nullable ResultMetadata var3);

    public abstract List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy var1, @Nullable ViewHierarchyElement var2, @Nullable Parameters var3);

    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy) {
        return this.runCheckOnHierarchy(hierarchy, null);
    }

    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot) {
        return this.runCheckOnHierarchy(hierarchy, fromRoot, null);
    }

    public @Nullable Double getSecondaryPriority(AccessibilityHierarchyCheckResult result) {
        return null;
    }

    protected static List<? extends ViewHierarchyElement> getElementsToEvaluate(@Nullable ViewHierarchyElement fromRoot, AccessibilityHierarchy hierarchy) {
        return fromRoot != null ? fromRoot.getSelfAndAllDescendants() : hierarchy.getActiveWindow().getAllViews();
    }

    protected static boolean isEnglish(AccessibilityHierarchy hierarchy) {
        return hierarchy.getDeviceState().getLocale().getLanguage().equals(Locale.ENGLISH.getLanguage());
    }
}

